/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.jline.builtins.ssh.Ssh;
import org.jline.builtins.telnet.Telnet;
import org.jline.terminal.Terminal;

public class Gogo {
    private final CommandProcessor processor;

    public Gogo(CommandProcessor processor) {
        this.processor = processor;
    }

    public Consumer<Ssh.ShellParams> shell() {
        return this::shell;
    }

    public Consumer<Ssh.ExecuteParams> command() {
        return this::command;
    }

    public Telnet.ShellProvider telnet() {
        return this::telnet;
    }

    private void shell(Ssh.ShellParams shell) {
        Terminal terminal = shell.getTerminal();
        CommandSession session = this.processor.createSession(terminal.input(), terminal.output(), terminal.output());
        session.put(".terminal", (Object)terminal);
        shell.getEnv().forEach((arg_0, arg_1) -> ((CommandSession)session).put(arg_0, arg_1));
        try {
            new Shell(this.context(shell.getCloser()::run), this.processor).gosh(session, new String[]{"--login"});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void command(Ssh.ExecuteParams exec) {
        CommandSession session = this.processor.createSession(exec.getIn(), exec.getOut(), exec.getErr());
        exec.getEnv().forEach((arg_0, arg_1) -> ((CommandSession)session).put(arg_0, arg_1));
        try {
            new Shell(this.context(null), this.processor).gosh(session, new String[]{"--login", "--nointeractive", "--noshutdown", "--command", exec.getCommand()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void telnet(Terminal terminal, Map<String, String> environment) {
        CommandSession session = this.processor.createSession(terminal.input(), terminal.output(), terminal.output());
        session.put(".terminal", (Object)terminal);
        environment.forEach((arg_0, arg_1) -> ((CommandSession)session).put(arg_0, arg_1));
        try {
            new Shell(this.context(() -> terminal.close()), this.processor).gosh(session, new String[]{"--login"});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Shell.Context context(final Closer closer) {
        return new Shell.Context(){

            public String getProperty(String name) {
                return System.getProperty(name);
            }

            public void exit() throws Exception {
                if (closer != null) {
                    closer.close();
                }
            }
        };
    }

    static interface Closer {
        public void close() throws Exception;
    }
}

