/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.ZeppelinContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSqlInterpreter
extends Interpreter {
    private Logger logger = LoggerFactory.getLogger(SparkSqlInterpreter.class);
    public static final String MAX_RESULTS = "zeppelin.spark.maxResult";
    AtomicInteger num = new AtomicInteger(0);
    private int maxResult;

    private String getJobGroup(InterpreterContext context) {
        return "zeppelin-" + context.getParagraphId();
    }

    public SparkSqlInterpreter(Properties property) {
        super(property);
    }

    @Override
    public void open() {
        this.maxResult = Integer.parseInt(this.getProperty(MAX_RESULTS));
    }

    private SparkInterpreter getSparkInterpreter() {
        LazyOpenInterpreter lazy = null;
        SparkInterpreter spark = null;
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class.getName());
        while (p instanceof WrappedInterpreter) {
            if (p instanceof LazyOpenInterpreter) {
                lazy = (LazyOpenInterpreter)p;
            }
            p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
        }
        spark = (SparkInterpreter)p;
        if (lazy != null) {
            lazy.open();
        }
        return spark;
    }

    public boolean concurrentSQL() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.concurrentSQL"));
    }

    @Override
    public void close() {
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) {
        SQLContext sqlc = null;
        SparkInterpreter sparkInterpreter = this.getSparkInterpreter();
        if (sparkInterpreter.getSparkVersion().isUnsupportedVersion()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Spark " + sparkInterpreter.getSparkVersion().toString() + " is not supported");
        }
        sparkInterpreter.populateSparkWebUrl(context);
        sqlc = this.getSparkInterpreter().getSQLContext();
        SparkContext sc = sqlc.sparkContext();
        if (this.concurrentSQL()) {
            sc.setLocalProperty("spark.scheduler.pool", "fair");
        } else {
            sc.setLocalProperty("spark.scheduler.pool", null);
        }
        sc.setJobGroup(this.getJobGroup(context), "Zeppelin", false);
        Object rdd = null;
        try {
            Method sqlMethod = sqlc.getClass().getMethod("sql", String.class);
            rdd = sqlMethod.invoke((Object)sqlc, st);
        }
        catch (InvocationTargetException ite) {
            if (Boolean.parseBoolean(this.getProperty("zeppelin.spark.sql.stacktrace"))) {
                throw new InterpreterException(ite);
            }
            this.logger.error("Invocation target exception", ite);
            String msg = ite.getTargetException().getMessage() + "\nset zeppelin.spark.sql.stacktrace = true to see full stacktrace";
            return new InterpreterResult(InterpreterResult.Code.ERROR, msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new InterpreterException(e);
        }
        String msg = ZeppelinContext.showDF(sc, context, rdd, this.maxResult);
        sc.clearJobGroup();
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, msg);
    }

    @Override
    public void cancel(InterpreterContext context) {
        SQLContext sqlc = this.getSparkInterpreter().getSQLContext();
        SparkContext sc = sqlc.sparkContext();
        sc.cancelJobGroup(this.getJobGroup(context));
    }

    @Override
    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    @Override
    public int getProgress(InterpreterContext context) {
        SparkInterpreter sparkInterpreter = this.getSparkInterpreter();
        return sparkInterpreter.getProgress(context);
    }

    @Override
    public Scheduler getScheduler() {
        if (this.concurrentSQL()) {
            int maxConcurrency = 10;
            return SchedulerFactory.singleton().createOrGetParallelScheduler(SparkSqlInterpreter.class.getName() + this.hashCode(), maxConcurrency);
        }
        Interpreter intp = this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class.getName());
        if (intp != null) {
            return intp.getScheduler();
        }
        return null;
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }
}

