/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import com.google.gson.Gson;
import java.util.List;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePoolUtils {
    static Logger logger = LoggerFactory.getLogger(ResourcePoolUtils.class);

    public static ResourceSet getAllResources() {
        return ResourcePoolUtils.getAllResourcesExcept(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceSet getAllResourcesExcept(String interpreterGroupExcludsion) {
        ResourceSet resourceSet = new ResourceSet();
        for (InterpreterGroup intpGroup : InterpreterGroup.getAll()) {
            if (interpreterGroupExcludsion != null && intpGroup.getId().equals(interpreterGroupExcludsion)) continue;
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool == null) continue;
                resourceSet.addAll(localPool.getAll());
                continue;
            }
            if (!remoteInterpreterProcess.isRunning()) continue;
            RemoteInterpreterService.Client client = null;
            boolean broken = false;
            try {
                client = remoteInterpreterProcess.getClient();
                List<String> resourceList = client.resourcePoolGetAll();
                Gson gson = new Gson();
                for (String res : resourceList) {
                    resourceSet.add(gson.fromJson(res, Resource.class));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                broken = true;
            }
            finally {
                if (client == null) continue;
                intpGroup.getRemoteInterpreterProcess().releaseClient(client, broken);
            }
        }
        return resourceSet;
    }

    public static void removeResourcesBelongsToNote(String noteId) {
        ResourcePoolUtils.removeResourcesBelongsToParagraph(noteId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResourcesBelongsToParagraph(String noteId, String paragraphId) {
        for (InterpreterGroup intpGroup : InterpreterGroup.getAll()) {
            ResourceSet resourceSet = new ResourceSet();
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool != null) {
                    resourceSet.addAll(localPool.getAll());
                }
                if (noteId != null) {
                    resourceSet = resourceSet.filterByNoteId(noteId);
                }
                if (paragraphId != null) {
                    resourceSet = resourceSet.filterByParagraphId(paragraphId);
                }
                for (Resource r : resourceSet) {
                    localPool.remove(r.getResourceId().getNoteId(), r.getResourceId().getParagraphId(), r.getResourceId().getName());
                }
                continue;
            }
            if (!remoteInterpreterProcess.isRunning()) continue;
            RemoteInterpreterService.Client client = null;
            boolean broken = false;
            try {
                client = remoteInterpreterProcess.getClient();
                List<String> resourceList = client.resourcePoolGetAll();
                Gson gson = new Gson();
                for (String res : resourceList) {
                    resourceSet.add(gson.fromJson(res, Resource.class));
                }
                if (noteId != null) {
                    resourceSet = resourceSet.filterByNoteId(noteId);
                }
                if (paragraphId != null) {
                    resourceSet = resourceSet.filterByParagraphId(paragraphId);
                }
                for (Resource r : resourceSet) {
                    client.resourceRemove(r.getResourceId().getNoteId(), r.getResourceId().getParagraphId(), r.getResourceId().getName());
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                broken = true;
            }
            finally {
                if (client == null) continue;
                intpGroup.getRemoteInterpreterProcess().releaseClient(client, broken);
            }
        }
    }
}

