/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.zeppelin.resource.ByteBufferInputStream;
import org.apache.zeppelin.resource.ResourceId;

public class Resource {
    private final transient Object r;
    private final boolean serializable;
    private final ResourceId resourceId;
    private final String className;

    Resource(ResourceId resourceId, Object r) {
        this.r = r;
        this.resourceId = resourceId;
        this.serializable = r instanceof Serializable;
        this.className = r.getClass().getName();
    }

    Resource(ResourceId resourceId, boolean serializable, String className) {
        this.r = null;
        this.resourceId = resourceId;
        this.serializable = serializable;
        this.className = className;
    }

    public ResourceId getResourceId() {
        return this.resourceId;
    }

    public String getClassName() {
        return this.className;
    }

    public Object get() {
        if (this.isLocal() || this.isSerializable()) {
            return this.r;
        }
        return null;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public boolean isLocal() {
        return true;
    }

    public static ByteBuffer serializeObject(Object o) throws IOException {
        if (o == null || !(o instanceof Serializable)) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(o);
            oos.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    public static Object deserializeObject(ByteBuffer buf) throws IOException, ClassNotFoundException {
        if (buf == null) {
            return null;
        }
        InputStream ins = ByteBufferInputStream.get(buf);
        Object object = null;
        ObjectInputStream oin = new ObjectInputStream(ins);
        object = oin.readObject();
        oin.close();
        ins.close();
        return object;
    }
}

