/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;

public class LocalResourcePool
implements ResourcePool {
    private final String resourcePoolId;
    private final Map<ResourceId, Resource> resources = Collections.synchronizedMap(new HashMap());

    public LocalResourcePool(String id) {
        this.resourcePoolId = id;
    }

    @Override
    public String id() {
        return this.resourcePoolId;
    }

    @Override
    public Resource get(String name) {
        ResourceId resourceId = new ResourceId(this.resourcePoolId, name);
        return this.resources.get(resourceId);
    }

    @Override
    public Resource get(String noteId, String paragraphId, String name) {
        ResourceId resourceId = new ResourceId(this.resourcePoolId, noteId, paragraphId, name);
        return this.resources.get(resourceId);
    }

    @Override
    public ResourceSet getAll() {
        return new ResourceSet(this.resources.values());
    }

    @Override
    public void put(String name, Object object) {
        ResourceId resourceId = new ResourceId(this.resourcePoolId, name);
        Resource resource = new Resource(resourceId, object);
        this.resources.put(resourceId, resource);
    }

    @Override
    public void put(String noteId, String paragraphId, String name, Object object) {
        ResourceId resourceId = new ResourceId(this.resourcePoolId, noteId, paragraphId, name);
        Resource resource = new Resource(resourceId, object);
        this.resources.put(resourceId, resource);
    }

    @Override
    public Resource remove(String name) {
        return this.resources.remove(new ResourceId(this.resourcePoolId, name));
    }

    @Override
    public Resource remove(String noteId, String paragraphId, String name) {
        return this.resources.remove(new ResourceId(this.resourcePoolId, noteId, paragraphId, name));
    }
}

