/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.util;

import java.io.IOException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.util.LogOutputStream;
import org.slf4j.Logger;

public class InterpreterOutputStream
extends LogOutputStream {
    public static Logger logger;
    InterpreterOutput interpreterOutput;
    boolean ignoreLeadingNewLinesFromScalaReporter = false;

    public InterpreterOutputStream(Logger logger) {
        InterpreterOutputStream.logger = logger;
    }

    public InterpreterOutput getInterpreterOutput() {
        return this.interpreterOutput;
    }

    public void setInterpreterOutput(InterpreterOutput interpreterOutput) {
        this.interpreterOutput = interpreterOutput;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.ignoreLeadingNewLinesFromScalaReporter && b == 10) {
            StackTraceElement[] stacks;
            for (StackTraceElement stack : stacks = Thread.currentThread().getStackTrace()) {
                if (!stack.getClassName().equals("scala.tools.nsc.interpreter.ReplReporter") || !stack.getMethodName().equals("error")) continue;
                return;
            }
        } else {
            this.ignoreLeadingNewLinesFromScalaReporter = false;
        }
        super.write(b);
        if (this.interpreterOutput != null) {
            this.interpreterOutput.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.write(b[i]);
        }
    }

    @Override
    protected void processLine(String s, int i) {
        logger.debug("Interpreter output:" + s);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.interpreterOutput != null) {
            this.interpreterOutput.close();
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.interpreterOutput != null) {
            this.interpreterOutput.flush();
        }
    }

    public void ignoreLeadingNewLinesFromScalaReporter() {
        this.ignoreLeadingNewLinesFromScalaReporter = true;
    }
}

