/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.interpreter.InterpreterOutputChangeListener;
import org.apache.zeppelin.interpreter.InterpreterOutputChangeWatcher;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutputListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterResultMessageOutput
extends OutputStream {
    Logger logger = LoggerFactory.getLogger(InterpreterResultMessageOutput.class);
    private final int NEW_LINE_CHAR = 10;
    private List<String> resourceSearchPaths;
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final List<Object> outList = new LinkedList<Object>();
    private InterpreterOutputChangeWatcher watcher;
    private final InterpreterResultMessageOutputListener flushListener;
    private InterpreterResult.Type type = InterpreterResult.Type.TEXT;
    private boolean firstWrite = true;

    public InterpreterResultMessageOutput(InterpreterResult.Type type, InterpreterResultMessageOutputListener listener) {
        this.type = type;
        this.flushListener = listener;
    }

    public InterpreterResultMessageOutput(InterpreterResult.Type type, InterpreterResultMessageOutputListener flushListener, InterpreterOutputChangeListener listener) throws IOException {
        this.type = type;
        this.flushListener = flushListener;
        this.watcher = new InterpreterOutputChangeWatcher(listener);
        this.watcher.start();
    }

    public InterpreterResult.Type getType() {
        return this.type;
    }

    public void setType(InterpreterResult.Type type) {
        if (this.type != type) {
            this.clear();
            this.type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Object> list = this.outList;
        synchronized (list) {
            this.buffer.reset();
            this.outList.clear();
            if (this.watcher != null) {
                this.watcher.clear();
            }
            if (this.flushListener != null) {
                this.flushListener.onUpdate(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        List<Object> list = this.outList;
        synchronized (list) {
            this.buffer.write(b);
            if (b == 10) {
                if (this.firstWrite) {
                    if (this.flushListener != null) {
                        this.flushListener.onUpdate(this);
                    }
                    this.firstWrite = false;
                }
                if (this.isAppendSupported()) {
                    this.flush(true);
                }
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        List<Object> list = this.outList;
        synchronized (list) {
            for (int i = off; i < len; ++i) {
                this.write(b[i]);
            }
        }
    }

    public void write(File file) throws IOException {
        this.outList.add(file);
        if (this.watcher != null) {
            this.watcher.watch(file);
        }
    }

    public void write(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void write(URL url) throws IOException {
        this.outList.add(url);
    }

    public void setResourceSearchPaths(List<String> resourceSearchPaths) {
        this.resourceSearchPaths = resourceSearchPaths;
    }

    public void writeResource(String resourceName) throws IOException {
        for (String path : this.resourceSearchPaths) {
            File res = new File(path + "/" + resourceName);
            if (!res.isFile()) continue;
            this.write(res);
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        this.write(cl.getResource(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedList<Object> all = new LinkedList<Object>();
        List<Object> list = this.outList;
        synchronized (list) {
            all.addAll(this.outList);
        }
        for (Object e : all) {
            if (e instanceof File) {
                File f = (File)e;
                FileInputStream fin = new FileInputStream(f);
                this.copyStream(fin, out);
                fin.close();
                continue;
            }
            if (e instanceof byte[]) {
                out.write((byte[])e);
                continue;
            }
            if (e instanceof Integer) {
                out.write((Integer)e);
                continue;
            }
            if (!(e instanceof URL)) continue;
            InputStream fin = ((URL)e).openStream();
            this.copyStream(fin, out);
            fin.close();
        }
        out.close();
        return out.toByteArray();
    }

    public InterpreterResultMessage toInterpreterResultMessage() throws IOException {
        return new InterpreterResultMessage(this.type, new String(this.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean append) throws IOException {
        List<Object> list = this.outList;
        synchronized (list) {
            this.buffer.flush();
            byte[] bytes = this.buffer.toByteArray();
            if (bytes != null && bytes.length > 0) {
                this.outList.add(bytes);
                if (append) {
                    if (this.flushListener != null) {
                        this.flushListener.onAppend(this, bytes);
                    }
                } else if (this.flushListener != null) {
                    this.flushListener.onUpdate(this);
                }
            }
            this.buffer.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(this.isAppendSupported());
    }

    public boolean isAppendSupported() {
        return this.type == InterpreterResult.Type.TEXT;
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        int bufferSize = 8192;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.watcher != null) {
            this.watcher.clear();
            this.watcher.shutdown();
        }
    }

    public String toString() {
        try {
            return "%" + this.type.name().toLowerCase() + " " + new String(this.toByteArray());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            return "%" + this.type.name().toLowerCase() + "\n";
        }
    }
}

