/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

public class InterpreterProperty {
    String envName;
    String propertyName;
    String defaultValue;
    String description;

    public InterpreterProperty(String envName, String propertyName, String defaultValue, String description) {
        this.envName = envName;
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public InterpreterProperty(String defaultValue, String description) {
        this(null, null, defaultValue, description);
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public String getValue() {
        String propValue;
        String envValue;
        if (this.envName != null && !this.envName.isEmpty() && (envValue = System.getenv().get(this.envName)) != null) {
            return envValue;
        }
        if (this.propertyName != null && !this.propertyName.isEmpty() && (propValue = System.getProperty(this.propertyName)) != null) {
            return propValue;
        }
        return this.defaultValue;
    }

    public String toString() {
        return String.format("{envName=%s, propertyName=%s, defaultValue=%s, description=%20s}", this.envName, this.propertyName, this.defaultValue, this.description);
    }
}

