/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.eclipse.jetty.util.thread;

import org.apache.spark-project.org.eclipse.jetty.util.log.Log;
import org.apache.spark-project.org.eclipse.jetty.util.log.Logger;

public class Timeout {
    private static final Logger LOG = Log.getLogger(Timeout.class);
    private Object _lock;
    private long _duration;
    private volatile long _now = System.currentTimeMillis();
    private Task _head = new Task();

    public Timeout() {
        this._lock = new Object();
        this._head._timeout = this;
    }

    public Timeout(Object lock2) {
        this._lock = lock2;
        this._head._timeout = this;
    }

    public long getDuration() {
        return this._duration;
    }

    public void setDuration(long duration) {
        this._duration = duration;
    }

    public long setNow() {
        this._now = System.currentTimeMillis();
        return this._now;
    }

    public long getNow() {
        return this._now;
    }

    public void setNow(long now) {
        this._now = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task expired() {
        Object object = this._lock;
        synchronized (object) {
            long _expiry = this._now - this._duration;
            if (this._head._next != this._head) {
                Task task = this._head._next;
                if (task._timestamp > _expiry) {
                    return null;
                }
                task.unlink();
                task._expired = true;
                return task;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long expiry = this._now - this._duration;
        Task task = null;
        block5: while (true) {
            try {
                while (true) {
                    Object object = this._lock;
                    synchronized (object) {
                        task = this._head._next;
                        if (task == this._head || task._timestamp > expiry) {
                            break block5;
                        }
                        task.unlink();
                        task._expired = true;
                        task.expire();
                    }
                    task.expired();
                }
            }
            catch (Throwable th) {
                LOG.warn("EXCEPTION ", th);
                continue;
            }
            break;
        }
    }

    public void tick(long now) {
        this._now = now;
        this.tick();
    }

    public void schedule(Task task) {
        this.schedule(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task, long delay) {
        Object object = this._lock;
        synchronized (object) {
            if (task._timestamp != 0L) {
                task.unlink();
                task._timestamp = 0L;
            }
            task._timeout = this;
            task._expired = false;
            task._delay = delay;
            task._timestamp = this._now + delay;
            Task last = this._head._prev;
            while (last != this._head && last._timestamp > task._timestamp) {
                last = last._prev;
            }
            last.link(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this._lock;
        synchronized (object) {
            this._head._next = this._head._prev = this._head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this._lock;
        synchronized (object) {
            return this._head._next == this._head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToNext() {
        Object object = this._lock;
        synchronized (object) {
            if (this._head._next == this._head) {
                return -1L;
            }
            long to_next = this._duration + this._head._next._timestamp - this._now;
            long l = to_next < 0L ? 0L : to_next;
            return l;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        Task task = this._head._next;
        while (task != this._head) {
            buf.append("-->");
            buf.append(task);
            task = task._next;
        }
        return buf.toString();
    }

    public static class Task {
        Task _next = this._prev = this;
        Task _prev;
        Timeout _timeout;
        long _delay;
        long _timestamp = 0L;
        boolean _expired = false;

        protected Task() {
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public long getAge() {
            long now;
            Timeout t = this._timeout;
            if (t != null && (now = t._now) != 0L && this._timestamp != 0L) {
                return now - this._timestamp;
            }
            return 0L;
        }

        private void unlink() {
            this._next._prev = this._prev;
            this._prev._next = this._next;
            this._next = this._prev = this;
            this._expired = false;
        }

        private void link(Task task) {
            Task next_next = this._next;
            this._next._prev = task;
            this._next = task;
            this._next._next = next_next;
            this._next._prev = this;
        }

        public void schedule(Timeout timer) {
            timer.schedule(this);
        }

        public void schedule(Timeout timer, long delay) {
            timer.schedule(this, delay);
        }

        public void reschedule() {
            Timeout timeout = this._timeout;
            if (timeout != null) {
                timeout.schedule(this, this._delay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Timeout timeout = this._timeout;
            if (timeout != null) {
                Object object = timeout._lock;
                synchronized (object) {
                    this.unlink();
                    this._timestamp = 0L;
                }
            }
        }

        public boolean isExpired() {
            return this._expired;
        }

        public boolean isScheduled() {
            return this._next != this;
        }

        protected void expire() {
        }

        public void expired() {
        }
    }
}

