/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.codehaus.jackson.map.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.spark-project.org.codehaus.jackson.JsonGenerationException;
import org.apache.spark-project.org.codehaus.jackson.JsonGenerator;
import org.apache.spark-project.org.codehaus.jackson.JsonNode;
import org.apache.spark-project.org.codehaus.jackson.map.JsonMappingException;
import org.apache.spark-project.org.codehaus.jackson.map.SerializationConfig;
import org.apache.spark-project.org.codehaus.jackson.map.SerializerProvider;
import org.apache.spark-project.org.codehaus.jackson.map.TypeSerializer;
import org.apache.spark-project.org.codehaus.jackson.map.ser.std.SerializerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnknownSerializer
extends SerializerBase<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonMappingException {
        if (provider.isEnabled(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(value);
        }
        jgen.writeStartObject();
        jgen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        if (provider.isEnabled(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(value);
        }
        typeSer.writeTypePrefixForObject(value, jgen);
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    protected void failForEmpty(Object value) throws JsonMappingException {
        throw new JsonMappingException("No serializer found for class " + value.getClass().getName() + " and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS) )");
    }
}

