/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hive.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.jar.Attributes;
import org.apache.spark-project.org.apache.hadoop.hive.metastore.TableType;
import org.apache.spark-project.org.apache.hive.jdbc.HiveConnection;
import org.apache.spark-project.org.apache.hive.jdbc.HiveDriver;
import org.apache.spark-project.org.apache.hive.jdbc.HiveMetaDataResultSet;
import org.apache.spark-project.org.apache.hive.jdbc.HiveQueryResultSet;
import org.apache.spark-project.org.apache.hive.jdbc.JdbcColumn;
import org.apache.spark-project.org.apache.hive.jdbc.JdbcTable;
import org.apache.spark-project.org.apache.hive.jdbc.Utils;
import org.apache.spark-project.org.apache.hive.service.cli.GetInfoType;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetCatalogsReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetCatalogsResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetColumnsReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetColumnsResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetFunctionsReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetFunctionsResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetInfoReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetInfoResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetInfoType;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetSchemasReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetSchemasResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetTableTypesReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetTableTypesResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetTablesReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetTablesResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetTypeInfoReq;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TGetTypeInfoResp;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.spark-project.org.apache.thrift.TException;

public class HiveDatabaseMetaData
implements DatabaseMetaData {
    private final HiveConnection connection;
    private final TCLIService.Iface client;
    private final TSessionHandle sessHandle;
    private static final String CATALOG_SEPARATOR = ".";
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private static final int maxColumnNameLength = 128;
    private String dbVersion = null;

    public HiveDatabaseMetaData(HiveConnection connection, TCLIService.Iface client, TSessionHandle sessHandle) {
        this.connection = connection;
        this.client = client;
        this.sessHandle = sessHandle;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return CATALOG_SEPARATOR;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "instance";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        TGetCatalogsResp catalogResp;
        try {
            catalogResp = this.client.GetCatalogs(new TGetCatalogsReq(this.sessHandle));
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(catalogResp.getStatus());
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(catalogResp.getOperationHandle()).build();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new SQLException("Method not supported");
    }

    private String convertPattern(String pattern) {
        if (pattern == null) {
            return ".*";
        }
        StringBuilder result = new StringBuilder(pattern.length());
        boolean escaped = false;
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (escaped) {
                if (c != '\\') {
                    escaped = false;
                }
                result.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '%') {
                result.append(".*");
                continue;
            }
            if (c == '_') {
                result.append('.');
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        TGetColumnsResp colResp;
        TGetColumnsReq colReq = new TGetColumnsReq();
        colReq.setSessionHandle(this.sessHandle);
        colReq.setCatalogName(catalog);
        colReq.setSchemaName(schemaPattern);
        colReq.setTableName(tableNamePattern);
        colReq.setColumnName(columnNamePattern);
        try {
            colResp = this.client.GetColumns(colReq);
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(colResp.getStatus());
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(colResp.getOperationHandle()).build();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Utils.getVersionPart(this.getDatabaseProductVersion(), 0);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Utils.getVersionPart(this.getDatabaseProductVersion(), 1);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        TGetInfoResp resp = this.getServerInfo(GetInfoType.CLI_DBMS_NAME.toTGetInfoType());
        return resp.getInfoValue().getStringValue();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.dbVersion != null) {
            return this.dbVersion;
        }
        TGetInfoResp resp = this.getServerInfo(GetInfoType.CLI_DBMS_VER.toTGetInfoType());
        this.dbVersion = resp.getInfoValue().getStringValue();
        return this.dbVersion;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return HiveDriver.getMajorDriverVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return HiveDriver.getMinorDriverVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return HiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return HiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getFunctions(String catalogName, String schemaPattern, String functionNamePattern) throws SQLException {
        TGetFunctionsResp funcResp;
        TGetFunctionsReq getFunctionsReq = new TGetFunctionsReq();
        getFunctionsReq.setSessionHandle(this.sessHandle);
        getFunctionsReq.setCatalogName(catalogName);
        getFunctionsReq.setSchemaName(schemaPattern);
        getFunctionsReq.setFunctionName(functionNamePattern);
        try {
            funcResp = this.client.GetFunctions(getFunctionsReq);
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(funcResp.getStatus());
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(funcResp.getOperationHandle()).build();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "STRING", "STRING", "STRING", "STRING", "SMALLINT", "SMALLINT", "SMALLINT", "STRING", "STRING", "STRING")).build();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"), Arrays.asList("STRING", "STRING", "STRING", "BOOLEAN", "STRING", "STRING", "SHORT", "SHORT", "STRING", "STRING", "INT", "INT", "STRING")).build();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "INT", "STRING")).build();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "SMALLINT", "INT", "STRING", "INT", "INT", "SMALLINT", "SMALLINT", "SMALLINT", "STRING", "STRING", "INT", "INT", "INT", "INT", "STRING", "STRING")).build();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return new String("UDF");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVERD", "RESERVERD", "RESERVERD", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "STRING", "STRING", "STRING", "SMALLINT", "STRING")).build();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        TGetSchemasResp schemaResp;
        TGetSchemasReq schemaReq = new TGetSchemasReq();
        schemaReq.setSessionHandle(this.sessHandle);
        if (catalog != null) {
            schemaReq.setCatalogName(catalog);
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        schemaReq.setSchemaName(schemaPattern);
        try {
            schemaResp = this.client.GetSchemas(schemaReq);
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(schemaResp.getStatus());
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(schemaResp.getOperationHandle()).build();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return String.valueOf('\\');
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        TGetTableTypesResp tableTypeResp;
        try {
            tableTypeResp = this.client.GetTableTypes(new TGetTableTypesReq(this.sessHandle));
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(tableTypeResp.getStatus());
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(tableTypeResp.getOperationHandle()).build();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        TGetTablesResp getTableResp;
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        TGetTablesReq getTableReq = new TGetTablesReq(this.sessHandle);
        getTableReq.setTableName(tableNamePattern);
        if (types != null) {
            getTableReq.setTableTypes(Arrays.asList(types));
        }
        if (schemaPattern != null) {
            getTableReq.setSchemaName(schemaPattern);
        }
        try {
            getTableResp = this.client.GetTables(getTableReq);
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(getTableResp.getStatus());
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(getTableResp.getOperationHandle()).build();
    }

    public static String toJdbcTableType(String hivetabletype) {
        if (hivetabletype == null) {
            return null;
        }
        if (hivetabletype.equals(TableType.MANAGED_TABLE.toString())) {
            return "TABLE";
        }
        if (hivetabletype.equals(TableType.VIRTUAL_VIEW.toString())) {
            return "VIEW";
        }
        if (hivetabletype.equals(TableType.EXTERNAL_TABLE.toString())) {
            return "EXTERNAL TABLE";
        }
        return hivetabletype;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        TGetTypeInfoResp getTypeInfoResp;
        TGetTypeInfoReq getTypeInfoReq = new TGetTypeInfoReq();
        getTypeInfoReq.setSessionHandle(this.sessHandle);
        try {
            getTypeInfoResp = this.client.GetTypeInfo(getTypeInfoReq);
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(getTypeInfoResp.getStatus());
        return new HiveQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(getTypeInfoResp.getOperationHandle()).build();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new HiveMetaDataResultSet(Arrays.asList("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "INT", "STRING", "INT"), null){

            @Override
            public boolean next() throws SQLException {
                return false;
            }

            @Override
            public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
                throw new SQLException("Method not supported");
            }

            @Override
            public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
                throw new SQLException("Method not supported");
            }
        };
    }

    @Override
    public String getURL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getUserName() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public static void main(String[] args) throws SQLException {
        HiveDatabaseMetaData meta = new HiveDatabaseMetaData(null, null, null);
        System.out.println("DriverName: " + meta.getDriverName());
        System.out.println("DriverVersion: " + meta.getDriverVersion());
    }

    private TGetInfoResp getServerInfo(TGetInfoType type) throws SQLException {
        TGetInfoResp resp;
        TGetInfoReq req = new TGetInfoReq(this.sessHandle, type);
        try {
            resp = this.client.GetInfo(req);
        }
        catch (TException e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(resp.getStatus());
        return resp;
    }

    private class GetTablesComparator
    implements Comparator<JdbcTable> {
        private GetTablesComparator() {
        }

        @Override
        public int compare(JdbcTable o1, JdbcTable o2) {
            int compareType = o1.getType().compareTo(o2.getType());
            if (compareType == 0) {
                return o1.getTableName().compareTo(o2.getTableName());
            }
            return compareType;
        }
    }

    private class GetColumnsComparator
    implements Comparator<JdbcColumn> {
        private GetColumnsComparator() {
        }

        @Override
        public int compare(JdbcColumn o1, JdbcColumn o2) {
            int compareName = o1.getTableName().compareTo(o2.getTableName());
            if (compareName == 0) {
                if (o1.getOrdinalPos() > o2.getOrdinalPos()) {
                    return 1;
                }
                if (o1.getOrdinalPos() < o2.getOrdinalPos()) {
                    return -1;
                }
                return 0;
            }
            return compareName;
        }
    }
}

