/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.avro.specific;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark-project.org.apache.avro.AvroRuntimeException;
import org.apache.spark-project.org.apache.avro.AvroTypeException;
import org.apache.spark-project.org.apache.avro.Protocol;
import org.apache.spark-project.org.apache.avro.Schema;
import org.apache.spark-project.org.apache.avro.generic.GenericData;
import org.apache.spark-project.org.apache.avro.io.DatumReader;
import org.apache.spark-project.org.apache.avro.io.DatumWriter;
import org.apache.spark-project.org.apache.avro.specific.SpecificDatumReader;
import org.apache.spark-project.org.apache.avro.specific.SpecificDatumWriter;

public class SpecificData
extends GenericData {
    private static final SpecificData INSTANCE = new SpecificData();
    private static final Class<?>[] NO_ARG = new Class[0];
    private static final Class<?>[] SCHEMA_ARG = new Class[]{Schema.class};
    private static final Map<Class, Constructor> CTOR_CACHE = new ConcurrentHashMap<Class, Constructor>();
    public static final String CLASS_PROP = "java-class";
    public static final String KEY_CLASS_PROP = "java-key-class";
    public static final String ELEMENT_PROP = "java-element-class";
    protected Set<Class> stringableClasses = new HashSet<Class>();
    private Map<String, Class> classCache;
    private static final Class NO_CLASS = new Object(){}.getClass();
    private static final Schema NULL_SCHEMA = Schema.create(Schema.Type.NULL);
    private final WeakHashMap<Type, Schema> schemaCache;

    public SpecificData() {
        this.stringableClasses.add(BigDecimal.class);
        this.stringableClasses.add(BigInteger.class);
        this.stringableClasses.add(URI.class);
        this.stringableClasses.add(URL.class);
        this.stringableClasses.add(File.class);
        this.classCache = new ConcurrentHashMap<String, Class>();
        this.schemaCache = new WeakHashMap();
    }

    public SpecificData(ClassLoader classLoader) {
        super(classLoader);
        this.stringableClasses.add(BigDecimal.class);
        this.stringableClasses.add(BigInteger.class);
        this.stringableClasses.add(URI.class);
        this.stringableClasses.add(URL.class);
        this.stringableClasses.add(File.class);
        this.classCache = new ConcurrentHashMap<String, Class>();
        this.schemaCache = new WeakHashMap();
    }

    @Override
    public DatumReader createDatumReader(Schema schema) {
        return new SpecificDatumReader(schema, schema, this);
    }

    @Override
    public DatumReader createDatumReader(Schema writer, Schema reader) {
        return new SpecificDatumReader(writer, reader, this);
    }

    @Override
    public DatumWriter createDatumWriter(Schema schema) {
        return new SpecificDatumWriter(schema, this);
    }

    public static SpecificData get() {
        return INSTANCE;
    }

    @Override
    protected boolean isEnum(Object datum) {
        return datum instanceof Enum || super.isEnum(datum);
    }

    @Override
    public Object createEnum(String symbol, Schema schema) {
        Class c = this.getClass(schema);
        if (c == null) {
            return super.createEnum(symbol, schema);
        }
        return Enum.valueOf(c, symbol);
    }

    @Override
    protected Schema getEnumSchema(Object datum) {
        return datum instanceof Enum ? this.getSchema(datum.getClass()) : super.getEnumSchema(datum);
    }

    public Class getClass(Schema schema) {
        switch (schema.getType()) {
            case FIXED: 
            case RECORD: 
            case ENUM: {
                String name = schema.getFullName();
                if (name == null) {
                    return null;
                }
                Class<?> c = this.classCache.get(name);
                if (c == null) {
                    try {
                        c = this.getClassLoader().loadClass(SpecificData.getClassName(schema));
                    }
                    catch (ClassNotFoundException e) {
                        c = NO_CLASS;
                    }
                    this.classCache.put(name, c);
                }
                return c == NO_CLASS ? null : c;
            }
            case ARRAY: {
                return List.class;
            }
            case MAP: {
                return Map.class;
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return this.getWrapper(types.get(types.get(0).equals(NULL_SCHEMA) ? 1 : 0));
                }
                return Object.class;
            }
            case STRING: {
                if ("String".equals(schema.getProp("avro.java.string"))) {
                    return String.class;
                }
                return CharSequence.class;
            }
            case BYTES: {
                return ByteBuffer.class;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case NULL: {
                return Void.TYPE;
            }
        }
        throw new AvroRuntimeException("Unknown type: " + schema);
    }

    private Class getWrapper(Schema schema) {
        switch (schema.getType()) {
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
        }
        return this.getClass(schema);
    }

    public static String getClassName(Schema schema) {
        String namespace = schema.getNamespace();
        String name = schema.getName();
        if (namespace == null || "".equals(namespace)) {
            return name;
        }
        String dot = namespace.endsWith("$") ? "" : ".";
        return namespace + dot + name;
    }

    public Schema getSchema(Type type) {
        Schema schema = this.schemaCache.get(type);
        if (schema == null) {
            schema = this.createSchema(type, new LinkedHashMap<String, Schema>());
            this.schemaCache.put(type, schema);
        }
        return schema;
    }

    protected Schema createSchema(Type type, Map<String, Schema> names) {
        if (type instanceof Class && CharSequence.class.isAssignableFrom((Class)type)) {
            return Schema.create(Schema.Type.STRING);
        }
        if (type == ByteBuffer.class) {
            return Schema.create(Schema.Type.BYTES);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Schema.create(Schema.Type.INT);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Schema.create(Schema.Type.LONG);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Schema.create(Schema.Type.FLOAT);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Schema.create(Schema.Type.DOUBLE);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Schema.create(Schema.Type.BOOLEAN);
        }
        if (type == Void.class || type == Void.TYPE) {
            return Schema.create(Schema.Type.NULL);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (Collection.class.isAssignableFrom(raw)) {
                if (params.length != 1) {
                    throw new AvroTypeException("No array type specified.");
                }
                return Schema.createArray(this.createSchema(params[0], names));
            }
            if (Map.class.isAssignableFrom(raw)) {
                Type key = params[0];
                Type value = params[1];
                if (!(key instanceof Class) || !CharSequence.class.isAssignableFrom((Class)key)) {
                    throw new AvroTypeException("Map key class not CharSequence: " + key);
                }
                return Schema.createMap(this.createSchema(value, names));
            }
            return this.createSchema(raw, names);
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            String fullName = c.getName();
            Schema schema = names.get(fullName);
            if (schema == null) {
                try {
                    schema = (Schema)c.getDeclaredField("SCHEMA$").get(null);
                    if (!fullName.equals(SpecificData.getClassName(schema))) {
                        schema = Schema.parse(schema.toString().replace(schema.getNamespace(), c.getPackage().getName()));
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new AvroRuntimeException("Not a Specific class: " + c);
                }
                catch (IllegalAccessException e) {
                    throw new AvroRuntimeException(e);
                }
            }
            names.put(fullName, schema);
            return schema;
        }
        throw new AvroTypeException("Unknown type: " + type);
    }

    @Override
    protected String getSchemaName(Object datum) {
        Class<?> c;
        if (datum != null && this.isStringable(c = datum.getClass())) {
            return Schema.Type.STRING.getName();
        }
        return super.getSchemaName(datum);
    }

    protected boolean isStringable(Class<?> c) {
        return this.stringableClasses.contains(c);
    }

    public Protocol getProtocol(Class iface) {
        try {
            Protocol p = (Protocol)iface.getDeclaredField("PROTOCOL").get(null);
            if (!p.getNamespace().equals(iface.getPackage().getName())) {
                p = Protocol.parse(p.toString().replace(p.getNamespace(), iface.getPackage().getName()));
            }
            return p;
        }
        catch (NoSuchFieldException e) {
            throw new AvroRuntimeException("Not a Specific protocol: " + iface);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    protected int compare(Object o1, Object o2, Schema s, boolean eq) {
        switch (s.getType()) {
            case ENUM: {
                if (!(o1 instanceof Enum)) break;
                return ((Enum)o1).ordinal() - ((Enum)o2).ordinal();
            }
        }
        return super.compare(o1, o2, s, eq);
    }

    public static Object newInstance(Class c, Schema s) {
        Object result;
        boolean useSchema = SchemaConstructable.class.isAssignableFrom(c);
        try {
            Object[] objectArray;
            Constructor meth = CTOR_CACHE.get(c);
            if (meth == null) {
                meth = c.getDeclaredConstructor(useSchema ? SCHEMA_ARG : NO_ARG);
                meth.setAccessible(true);
                CTOR_CACHE.put(c, meth);
            }
            if (useSchema) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = s;
            } else {
                objectArray = null;
            }
            result = meth.newInstance(objectArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public Object createFixed(Object old, Schema schema) {
        Class c = this.getClass(schema);
        if (c == null) {
            return super.createFixed(old, schema);
        }
        return c.isInstance(old) ? old : SpecificData.newInstance(c, schema);
    }

    @Override
    public Object newRecord(Object old, Schema schema) {
        Class c = this.getClass(schema);
        if (c == null) {
            return super.newRecord(old, schema);
        }
        return c.isInstance(old) ? old : SpecificData.newInstance(c, schema);
    }

    public static interface SchemaConstructable {
    }
}

