/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.krbSafe.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.krbSafe.KrbSafeContainer;
import org.apache.directory.shared.kerberos.messages.KrbSafe;
import org.apache.spark-project.org.slf4j.Logger;
import org.apache.spark-project.org.slf4j.LoggerFactory;

public class KrbSafeInit
extends GrammarAction<KrbSafeContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(KrbSafeInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public KrbSafeInit() {
        super("Creates a KrbSafe instance");
    }

    public void action(KrbSafeContainer krbSafeContainer) throws DecoderException {
        TLV tlv = krbSafeContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        KrbSafe krbSafe = new KrbSafe();
        krbSafeContainer.setKrbSafe(krbSafe);
        if (IS_DEBUG) {
            LOG.debug("KrbSafe created");
        }
    }
}

