/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.security.Principal;

public class KafkaPrincipal
implements Principal {
    public static final String SEPARATOR = ":";
    public static final String USER_TYPE = "User";
    public static final KafkaPrincipal ANONYMOUS = new KafkaPrincipal("User", "ANONYMOUS");
    private String principalType;
    private String name;

    public KafkaPrincipal(String principalType, String name) {
        if (principalType == null || name == null) {
            throw new IllegalArgumentException("principalType and name can not be null");
        }
        this.principalType = principalType;
        this.name = name;
    }

    public static KafkaPrincipal fromString(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        String[] split2 = str.split(SEPARATOR, 2);
        if (split2 == null || split2.length != 2) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        return new KafkaPrincipal(split2[0], split2[1]);
    }

    @Override
    public String toString() {
        return this.principalType + SEPARATOR + this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaPrincipal)) {
            return false;
        }
        KafkaPrincipal that = (KafkaPrincipal)o;
        if (!this.principalType.equalsIgnoreCase(that.principalType)) {
            return false;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    @Override
    public int hashCode() {
        int result2 = this.principalType.hashCode();
        result2 = 31 * result2 + this.name.hashCode();
        return result2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPrincipalType() {
        return this.principalType;
    }
}

