/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;

public class Struct {
    private final Schema schema;
    private final Object[] values;

    Struct(Schema schema, Object[] values) {
        this.schema = schema;
        this.values = values;
    }

    public Struct(Schema schema) {
        this.schema = schema;
        this.values = new Object[this.schema.numFields()];
    }

    public Schema schema() {
        return this.schema;
    }

    private Object getFieldOrDefault(Field field2) {
        Object value2 = this.values[field2.index];
        if (value2 != null) {
            return value2;
        }
        if (field2.defaultValue != Field.NO_DEFAULT) {
            return field2.defaultValue;
        }
        if (field2.type.isNullable()) {
            return null;
        }
        throw new SchemaException("Missing value for field '" + field2.name + "' which has no default value.");
    }

    public Object get(Field field2) {
        this.validateField(field2);
        return this.getFieldOrDefault(field2);
    }

    public Object get(String name) {
        Field field2 = this.schema.get(name);
        if (field2 == null) {
            throw new SchemaException("No such field: " + name);
        }
        return this.getFieldOrDefault(field2);
    }

    public boolean hasField(String name) {
        return this.schema.get(name) != null;
    }

    public Struct getStruct(Field field2) {
        return (Struct)this.get(field2);
    }

    public Struct getStruct(String name) {
        return (Struct)this.get(name);
    }

    public Byte getByte(Field field2) {
        return (Byte)this.get(field2);
    }

    public byte getByte(String name) {
        return (Byte)this.get(name);
    }

    public Short getShort(Field field2) {
        return (Short)this.get(field2);
    }

    public Short getShort(String name) {
        return (Short)this.get(name);
    }

    public Integer getInt(Field field2) {
        return (Integer)this.get(field2);
    }

    public Integer getInt(String name) {
        return (Integer)this.get(name);
    }

    public Long getLong(Field field2) {
        return (Long)this.get(field2);
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public Object[] getArray(Field field2) {
        return (Object[])this.get(field2);
    }

    public Object[] getArray(String name) {
        return (Object[])this.get(name);
    }

    public String getString(Field field2) {
        return (String)this.get(field2);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public Boolean getBoolean(Field field2) {
        return (Boolean)this.get(field2);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public ByteBuffer getBytes(Field field2) {
        Object result2 = this.get(field2);
        if (result2 instanceof byte[]) {
            return ByteBuffer.wrap((byte[])result2);
        }
        return (ByteBuffer)result2;
    }

    public ByteBuffer getBytes(String name) {
        Object result2 = this.get(name);
        if (result2 instanceof byte[]) {
            return ByteBuffer.wrap((byte[])result2);
        }
        return (ByteBuffer)result2;
    }

    public Struct set(Field field2, Object value2) {
        this.validateField(field2);
        this.values[field2.index] = value2;
        return this;
    }

    public Struct set(String name, Object value2) {
        Field field2 = this.schema.get(name);
        if (field2 == null) {
            throw new SchemaException("Unknown field: " + name);
        }
        this.values[field2.index] = value2;
        return this;
    }

    public Struct instance(Field field2) {
        this.validateField(field2);
        if (field2.type() instanceof Schema) {
            return new Struct((Schema)field2.type());
        }
        if (field2.type() instanceof ArrayOf) {
            ArrayOf array = (ArrayOf)field2.type();
            return new Struct((Schema)array.type());
        }
        throw new SchemaException("Field '" + field2.name + "' is not a container type, it is of type " + field2.type());
    }

    public Struct instance(String field2) {
        return this.instance(this.schema.get(field2));
    }

    public void clear() {
        Arrays.fill(this.values, null);
    }

    public int sizeOf() {
        return this.schema.sizeOf(this);
    }

    public void writeTo(ByteBuffer buffer) {
        this.schema.write(buffer, this);
    }

    private void validateField(Field field2) {
        if (this.schema != field2.schema) {
            throw new SchemaException("Attempt to access field '" + field2.name + "' from a different schema instance.");
        }
        if (field2.index > this.values.length) {
            throw new SchemaException("Invalid field index: " + field2.index);
        }
    }

    public void validate() {
        this.schema.validate(this);
    }

    public ByteBuffer[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.sizeOf());
        this.writeTo(buffer);
        return new ByteBuffer[]{buffer};
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            Field f = this.schema.get(i);
            b.append(f.name);
            b.append('=');
            if (f.type() instanceof ArrayOf && this.values[i] != null) {
                Object[] arrayValue = (Object[])this.values[i];
                b.append('[');
                for (int j = 0; j < arrayValue.length; ++j) {
                    b.append(arrayValue[j]);
                    if (j >= arrayValue.length - 1) continue;
                    b.append(',');
                }
                b.append(']');
            } else {
                b.append(this.values[i]);
            }
            if (i >= this.values.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        for (int i = 0; i < this.values.length; ++i) {
            Field f = this.schema.get(i);
            if (f.type() instanceof ArrayOf) {
                Object[] arrayObject;
                if (this.get(f) == null) continue;
                for (Object arrayItem : arrayObject = (Object[])this.get(f)) {
                    result2 = 31 * result2 + arrayItem.hashCode();
                }
                continue;
            }
            Object field2 = this.get(f);
            if (field2 == null) continue;
            result2 = 31 * result2 + field2.hashCode();
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Struct other = (Struct)obj;
        if (this.schema != other.schema) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            boolean result2;
            Field f = this.schema.get(i);
            if (f.type() instanceof ArrayOf) {
                result2 = Arrays.equals((Object[])this.get(f), (Object[])other.get(f));
            } else {
                Object thisField = this.get(f);
                Object otherField = other.get(f);
                boolean bl = result2 = thisField == null && otherField == null || thisField.equals(otherField);
            }
            if (result2) continue;
            return false;
        }
        return true;
    }
}

