/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> used;
    private final Map<String, ?> originals;
    private final Map<String, Object> values;

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        for (Object key : originals.keySet()) {
            if (key instanceof String) continue;
            throw new ConfigException(key.toString(), originals.get(key), "Key must be a string.");
        }
        this.originals = originals;
        this.values = definition.parse(this.originals);
        this.used = Collections.synchronizedSet(new HashSet());
        if (doLog) {
            this.logAll();
        }
    }

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals) {
        this(definition, originals, true);
    }

    public AbstractConfig(Map<String, Object> parsedConfig) {
        this.values = parsedConfig;
        this.originals = new HashMap();
        this.used = Collections.synchronizedSet(new HashSet());
    }

    protected Object get(String key) {
        if (!this.values.containsKey(key)) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        this.used.add(key);
        return this.values.get(key);
    }

    public void ignore(String key) {
        this.used.add(key);
    }

    public Short getShort(String key) {
        return (Short)this.get(key);
    }

    public Integer getInt(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public List<String> getList(String key) {
        return (List)this.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Password getPassword(String key) {
        return (Password)this.get(key);
    }

    public Class<?> getClass(String key) {
        return (Class)this.get(key);
    }

    public Set<String> unused() {
        HashSet<String> keys = new HashSet<String>(this.originals.keySet());
        keys.removeAll(this.used);
        return keys;
    }

    public Map<String, Object> originals() {
        RecordingMap<Object> copy = new RecordingMap<Object>();
        copy.putAll(this.originals);
        return copy;
    }

    public Map<String, String> originalsStrings() {
        RecordingMap<String> copy = new RecordingMap<String>();
        for (Map.Entry<String, ?> entry2 : this.originals.entrySet()) {
            if (!(entry2.getValue() instanceof String)) {
                throw new ClassCastException("Non-string value found in original settings for key " + entry2.getKey() + ": " + (entry2.getValue() == null ? null : entry2.getValue().getClass().getName()));
            }
            copy.put(entry2.getKey(), (String)entry2.getValue());
        }
        return copy;
    }

    public Map<String, Object> originalsWithPrefix(String prefix) {
        RecordingMap<Object> result2 = new RecordingMap<Object>();
        for (Map.Entry<String, ?> entry2 : this.originals.entrySet()) {
            if (!entry2.getKey().startsWith(prefix) || entry2.getKey().length() <= prefix.length()) continue;
            result2.put(entry2.getKey().substring(prefix.length()), entry2.getValue());
        }
        return result2;
    }

    public Map<String, ?> values() {
        return new RecordingMap<Object>(this.values);
    }

    private void logAll() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append(" values: ");
        b.append(Utils.NL);
        for (Map.Entry<String, Object> entry2 : this.values.entrySet()) {
            b.append('\t');
            b.append(entry2.getKey());
            b.append(" = ");
            b.append(entry2.getValue());
            b.append(Utils.NL);
        }
        this.log.info(b.toString());
    }

    public void logUnused() {
        for (String key : this.unused()) {
            this.log.warn("The configuration {} = {} was supplied but isn't a known config.", (Object)key, this.originals.get(key));
        }
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) {
        Class<?> c = this.getClass(key);
        if (c == null) {
            return null;
        }
        Object o = Utils.newInstance(c);
        if (!t.isInstance(o)) {
            throw new KafkaException(c.getName() + " is not an instance of " + t.getName());
        }
        if (o instanceof Configurable) {
            ((Configurable)o).configure(this.originals);
        }
        return t.cast(o);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) {
        List<String> klasses = this.getList(key);
        ArrayList<T> objects = new ArrayList<T>();
        if (klasses == null) {
            return objects;
        }
        for (String klass : klasses) {
            T o;
            try {
                o = Utils.newInstance(klass, t);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(klass + " ClassNotFoundException exception occured", e);
            }
            if (!t.isInstance(o)) {
                throw new KafkaException(klass + " is not an instance of " + t.getName());
            }
            if (o instanceof Configurable) {
                ((Configurable)o).configure(this.originals);
            }
            objects.add(t.cast(o));
        }
        return objects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConfig that = (AbstractConfig)o;
        return this.originals.equals(that.originals);
    }

    public int hashCode() {
        return this.originals.hashCode();
    }

    private class RecordingMap<V>
    extends HashMap<String, V> {
        RecordingMap() {
        }

        RecordingMap(Map<String, ? extends V> m) {
            super(m);
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                AbstractConfig.this.ignore((String)key);
            }
            return super.get(key);
        }
    }
}

