/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.common.TopicPartition;

public final class RecordMetadata {
    public static final int UNKNOWN_PARTITION = -1;
    private final long offset;
    private final long timestamp;
    private final long checksum;
    private final int serializedKeySize;
    private final int serializedValueSize;
    private final TopicPartition topicPartition;

    private RecordMetadata(TopicPartition topicPartition, long offset, long timestamp2, long checksum, int serializedKeySize, int serializedValueSize) {
        this.offset = offset;
        this.timestamp = timestamp2;
        this.checksum = checksum;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
        this.topicPartition = topicPartition;
    }

    @Deprecated
    public RecordMetadata(TopicPartition topicPartition, long baseOffset, long relativeOffset) {
        this(topicPartition, baseOffset, relativeOffset, -1L, -1L, -1, -1);
    }

    public RecordMetadata(TopicPartition topicPartition, long baseOffset, long relativeOffset, long timestamp2, long checksum, int serializedKeySize, int serializedValueSize) {
        this(topicPartition, baseOffset == -1L ? baseOffset : baseOffset + relativeOffset, timestamp2, checksum, serializedKeySize, serializedValueSize);
    }

    public long offset() {
        return this.offset;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long checksum() {
        return this.checksum;
    }

    public int serializedKeySize() {
        return this.serializedKeySize;
    }

    public int serializedValueSize() {
        return this.serializedValueSize;
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public String toString() {
        return this.topicPartition.toString() + "@" + this.offset;
    }
}

