/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MagicAndTimestamp;
import kafka.message.Message;
import kafka.message.Message$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class MessageSet$ {
    public static final MessageSet$ MODULE$;
    private final int MessageSizeLength;
    private final int OffsetLength;
    private final int LogOverhead;
    private final ByteBufferMessageSet Empty;

    static {
        new MessageSet$();
    }

    public int MessageSizeLength() {
        return this.MessageSizeLength;
    }

    public int OffsetLength() {
        return this.OffsetLength;
    }

    public int LogOverhead() {
        return this.LogOverhead;
    }

    public ByteBufferMessageSet Empty() {
        return this.Empty;
    }

    public int messageSetSize(Iterable<Message> messages) {
        return BoxesRunTime.unboxToInt(messages.foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, Message x$2) {
                return x$1 + MessageSet$.MODULE$.entrySize(x$2);
            }
        }));
    }

    public int entrySize(Message message) {
        return this.LogOverhead() + message.size();
    }

    public MagicAndTimestamp magicAndLargestTimestamp(Seq<Message> messages) {
        byte firstMagicValue = ((Message)messages.head()).magic();
        LongRef largestTimestamp = new LongRef(Message$.MODULE$.NoTimestamp());
        messages.foreach(new Serializable(firstMagicValue, largestTimestamp){
            public static final long serialVersionUID = 0L;
            private final byte firstMagicValue$1;
            private final LongRef largestTimestamp$1;

            public final void apply(Message message) {
                if (message.magic() != this.firstMagicValue$1) {
                    throw new IllegalStateException("Messages in the same message set must have same magic value");
                }
                if (this.firstMagicValue$1 > Message$.MODULE$.MagicValue_V0()) {
                    this.largestTimestamp$1.elem = package$.MODULE$.max(this.largestTimestamp$1.elem, message.timestamp());
                }
            }
            {
                this.firstMagicValue$1 = firstMagicValue$1;
                this.largestTimestamp$1 = largestTimestamp$1;
            }
        });
        return new MagicAndTimestamp(firstMagicValue, largestTimestamp.elem);
    }

    private MessageSet$() {
        MODULE$ = this;
        this.MessageSizeLength = 4;
        this.OffsetLength = 8;
        this.LogOverhead = this.MessageSizeLength() + this.OffsetLength();
        this.Empty = new ByteBufferMessageSet(ByteBuffer.allocate(0));
    }
}

