/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.nio.ch.DirectBuffer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0015\u0002\f\u0002\u000b}3\u0017\u000e\\3\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012AA5p\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\t\u0019KG.\u001a\u0015\u0003)}\u0001\"!\u0003\u0011\n\u0005\u0005R!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n!BY1tK>3gm]3u+\u0005)\u0003CA\u0005'\u0013\t9#B\u0001\u0003M_:<\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0017\t\f7/Z(gMN,G\u000f\t\u0005\tW\u0001\u0011)\u0019!C\u0001Y\u0005aQ.\u0019=J]\u0012,\u0007pU5{KV\tQ\u0006\u0005\u0002\n]%\u0011qF\u0003\u0002\u0004\u0013:$\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001b5\f\u00070\u00138eKb\u001c\u0016N_3!\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q!Qg\u000e\u001d:!\t1\u0004!D\u0001\u0003\u0011\u0015)\"\u00071\u0001\u0017\u0011\u0015\u0019#\u00071\u0001&\u0011\u001dY#\u0007%AA\u00025Bqa\u000f\u0001C\u0002\u0013%A(\u0001\u0003m_\u000e\\W#A\u001f\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015!\u00027pG.\u001c(B\u0001\"D\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\tj\tA!\u001e;jY&\u0011ai\u0010\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\r!\u0003\u0001\u0015!\u0003>\u0003\u0015awnY6!\u0011\u0019Q\u0005\u0001)Q\u0005\u0017\u0006!Q.\\1q!\tau*D\u0001N\u0015\tq%$A\u0002oS>L!\u0001U'\u0003!5\u000b\u0007\u000f]3e\u0005f$XMQ;gM\u0016\u0014\bFA% \u0011\u0019\u0019\u0006\u0001)Q\u0005[\u0005Aq,\u001a8ue&,7\u000f\u000b\u0002S?!1a\u000b\u0001Q!\n5\n1bX7bq\u0016sGO]5fg\"\u0012Qk\b\u0005\u00073\u0002\u0001\u000b\u0015B\u0013\u0002\u0017}c\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0015\u00031~AQ\u0001\u0018\u0001\u0005\u00021\n!\"\\1y\u000b:$(/[3t\u0011\u0015q\u0006\u0001\"\u0001%\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\u0006A\u0002!\t!Y\u0001\u0005M&dW-F\u0001\u0017\u0011\u0015\u0019\u0007\u0001\"\u0001e\u00035\u0011X-\u00193MCN$XI\u001c;ssR\tQ\r\u0005\u00027M&\u0011qM\u0001\u0002\u000f\u001f\u001a47/\u001a;Q_NLG/[8o\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u0019awn\\6vaR\u0011Qm\u001b\u0005\u0006Y\"\u0004\r!J\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\u0005\u0006]\u0002!Ia\\\u0001\rS:$W\r_*m_R4uN\u001d\u000b\u0004[A,\b\"B9n\u0001\u0004\u0011\u0018aA5eqB\u0011Aj]\u0005\u0003i6\u0013!BQ=uK\n+hMZ3s\u0011\u0015aW\u000e1\u0001&\u0011\u00159\b\u0001\"\u0003y\u00039\u0011X\r\\1uSZ,wJ\u001a4tKR$2!L=|\u0011\u0015Qh\u000f1\u0001s\u0003\u0019\u0011WO\u001a4fe\")AP\u001ea\u0001[\u0005\ta\u000eC\u0003\u007f\u0001\u0011%q0\u0001\u0005qQf\u001c\u0018nY1m)\u0015i\u0013\u0011AA\u0002\u0011\u0015QX\u00101\u0001s\u0011\u0015aX\u00101\u0001.\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tQ!\u001a8uef$2!ZA\u0006\u0011\u0019a\u0018Q\u0001a\u0001[!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011AB1qa\u0016tG\r\u0006\u0004\u0002\u0014\u0005e\u0011Q\u0004\t\u0004\u0013\u0005U\u0011bAA\f\u0015\t!QK\\5u\u0011\u001d\tY\"!\u0004A\u0002\u0015\naa\u001c4gg\u0016$\bbBA\u0010\u0003\u001b\u0001\r!L\u0001\ta>\u001c\u0018\u000e^5p]\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012AB5t\rVdG.\u0006\u0002\u0002(A\u0019\u0011\"!\u000b\n\u0007\u0005-\"BA\u0004C_>dW-\u00198\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005AAO];oG\u0006$X\r\u0006\u0002\u0002\u0014!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012A\u0003;sk:\u001c\u0017\r^3U_R!\u00111CA\u001d\u0011\u001d\tY\"a\rA\u0002\u0015Bq!!\u0010\u0001\t\u0013\ty$A\tueVt7-\u0019;f)>,e\u000e\u001e:jKN$B!a\u0005\u0002B!9\u00111IA\u001e\u0001\u0004i\u0013aB3oiJLWm\u001d\u0005\b\u0003\u000f\u0002A\u0011AA\u0019\u0003=!(/[7U_Z\u000bG.\u001b3TSj,\u0007bBA&\u0001\u0011\u0005\u0011QJ\u0001\u0007e\u0016\u001c\u0018N_3\u0015\t\u0005M\u0011q\n\u0005\b\u0003#\nI\u00051\u0001.\u0003\u001dqWm^*ju\u0016Dq!!\u0016\u0001\t\u0013\t9&\u0001\u0006g_J\u001cW-\u00168nCB$B!a\u0005\u0002Z!9\u00111LA*\u0001\u0004Y\u0015!A7\t\u000f\u0005}\u0003\u0001\"\u0001\u00022\u0005)a\r\\;tQ\"9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0014A\u00023fY\u0016$X\r\u0006\u0002\u0002(!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005\u0015\u0014a\u00034pe\u000e,G)\u001a7fi\u0016Da!a\u0011\u0001\t\u0003a\u0003bBA8\u0001\u0011\u0005\u0011\u0011O\u0001\fg&TX-\u00138CsR,7\u000fF\u0001.\u0011\u001d\t)\b\u0001C\u0001\u0003c\tQa\u00197pg\u0016Dq!!\u001f\u0001\t\u0003\tY(\u0001\u0005sK:\fW.\u001a+p)\u0011\t\u0019\"! \t\u000f\u0005}\u0014q\u000fa\u0001-\u0005\ta\rC\u0004\u0002\u0004\u0002!\t!!\r\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u0005\b\u0003\u000f\u0003A\u0011BAE\u0003Q\u0011x.\u001e8e)>,\u00050Y2u\u001bVdG/\u001b9mKR)Q&a#\u0002\u0010\"9\u0011QRAC\u0001\u0004i\u0013A\u00028v[\n,'\u000fC\u0004\u0002\u0012\u0006\u0015\u0005\u0019A\u0017\u0002\r\u0019\f7\r^8s\u0011\u001d\t)\n\u0001C\u0005\u0003/\u000b\u0011\"\\1zE\u0016dunY6\u0016\t\u0005e\u0015\u0011\u0015\u000b\u0005\u00037\u000bi\f\u0006\u0003\u0002\u001e\u0006M\u0006\u0003BAP\u0003Cc\u0001\u0001\u0002\u0005\u0002$\u0006M%\u0019AAS\u0005\u0005!\u0016\u0003BAT\u0003[\u00032!CAU\u0013\r\tYK\u0003\u0002\b\u001d>$\b.\u001b8h!\rI\u0011qV\u0005\u0004\u0003cS!aA!os\"I\u0011QWAJ\t\u0003\u0007\u0011qW\u0001\u0004MVt\u0007#B\u0005\u0002:\u0006u\u0015bAA^\u0015\tAAHY=oC6,g\bC\u0004<\u0003'\u0003\r!a0\u0011\u0007y\n\t-C\u0002\u0002D~\u0012A\u0001T8dW\u001eI\u0011q\u0019\u0002\u0002\u0002#\u0005\u0011\u0011Z\u0001\f\u001f\u001a47/\u001a;J]\u0012,\u0007\u0010E\u00027\u0003\u00174\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QZ\n\u0004\u0003\u0017D\u0001bB\u001a\u0002L\u0012\u0005\u0011\u0011\u001b\u000b\u0003\u0003\u0013D!\"!6\u0002LF\u0005I\u0011AAl\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001c\u0016\u0004[\u0005m7FAAo!\u0011\ty.!;\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d(\"\u0001\u0006b]:|G/\u0019;j_:LA!a;\u0002b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class OffsetIndex
implements Logging {
    public volatile File kafka$log$OffsetIndex$$_file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    public volatile MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    public volatile int kafka$log$OffsetIndex$$_entries;
    public volatile int kafka$log$OffsetIndex$$_maxEntries;
    public volatile long kafka$log$OffsetIndex$$_lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public int maxEntries() {
        return this.kafka$log$OffsetIndex$$_maxEntries;
    }

    public long lastOffset() {
        return this.kafka$log$OffsetIndex$$_lastOffset;
    }

    public File file() {
        return this.kafka$log$OffsetIndex$$_file;
    }

    public OffsetPosition readLastEntry() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer.kafka$log$OffsetIndex$$_entries;
                switch (n) {
                    default: {
                        offsetPosition = new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(this.$outer.kafka$log$OffsetIndex$$mmap, n - 1), this.$outer.kafka$log$OffsetIndex$$physical(this.$outer.kafka$log$OffsetIndex$$mmap, n - 1));
                        break;
                    }
                    case 0: {
                        offsetPosition = new OffsetPosition(this.$outer.baseOffset(), 0);
                    }
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public OffsetPosition lookup(long targetOffset) {
        return this.maybeLock(this.lock(), (Function0)((Object)new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap.duplicate();
                int slot = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(idx, this.targetOffset$1);
                return slot == -1 ? new OffsetPosition(this.$outer.baseOffset(), 0) : new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot), this.$outer.kafka$log$OffsetIndex$$physical(idx, slot));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        }));
    }

    public int kafka$log$OffsetIndex$$indexSlotFor(ByteBuffer idx, long targetOffset) {
        long relOffset = targetOffset - this.baseOffset();
        if (this.kafka$log$OffsetIndex$$_entries == 0) {
            return -1;
        }
        if ((long)this.kafka$log$OffsetIndex$$relativeOffset(idx, 0) > relOffset) {
            return -1;
        }
        int lo = 0;
        int hi = this.kafka$log$OffsetIndex$$_entries - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            int found = this.kafka$log$OffsetIndex$$relativeOffset(idx, mid);
            if ((long)found == relOffset) {
                return mid;
            }
            if ((long)found < relOffset) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        return lo;
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8);
    }

    public int kafka$log$OffsetIndex$$physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n) {
        return this.maybeLock(this.lock(), (Function0)((Object)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer.kafka$log$OffsetIndex$$_entries) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.n$1), BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$_entries)})));
                }
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap.duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        }));
    }

    public void append(long offset, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset, position){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0<Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$_entries)).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                if (this.$outer.kafka$log$OffsetIndex$$_entries == 0 || this.offset$1 > this.$outer.kafka$log$OffsetIndex$$_lastOffset) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.offset$1), BoxesRunTime.boxToInteger(this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$_file.getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.$outer.kafka$log$OffsetIndex$$mmap.putInt((int)(this.offset$1 - this.$outer.baseOffset()));
                    this.$outer.kafka$log$OffsetIndex$$mmap.putInt(this.position$1);
                    ++this.$outer.kafka$log$OffsetIndex$$_entries;
                    this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.offset$1;
                    Predef$.MODULE$.require(this.$outer.kafka$log$OffsetIndex$$_entries * 8 == this.$outer.kafka$log$OffsetIndex$$mmap.position(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$_entries).append((Object)" entries but file position in index is ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$mmap.position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    return;
                }
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.offset$1), BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$_entries), BoxesRunTime.boxToLong(this.$outer.kafka$log$OffsetIndex$$_lastOffset), this.$outer.kafka$log$OffsetIndex$$_file.getAbsolutePath()})));
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.position$1 = position$1;
            }
        });
    }

    public boolean isFull() {
        return this.kafka$log$OffsetIndex$$_entries >= this.kafka$log$OffsetIndex$$_maxEntries;
    }

    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap.duplicate();
                int slot = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(idx, this.offset$2);
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$OffsetIndex$$_entries = this.entries$1;
                this.$outer.kafka$log$OffsetIndex$$mmap.position(this.$outer.kafka$log$OffsetIndex$$_entries * 8);
                this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.$outer.readLastEntry().offset();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.kafka$log$OffsetIndex$$_entries * 8);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void resize(int newSize) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int newSize$1;

            public final Buffer apply() {
                Buffer buffer;
                RandomAccessFile raf = new RandomAccessFile(this.$outer.kafka$log$OffsetIndex$$_file, "rw");
                int roundedNewSize = this.$outer.kafka$log$OffsetIndex$$roundToExactMultiple(this.newSize$1, 8);
                int position = this.$outer.kafka$log$OffsetIndex$$mmap.position();
                if (Os$.MODULE$.isWindows()) {
                    this.$outer.kafka$log$OffsetIndex$$forceUnmap(this.$outer.kafka$log$OffsetIndex$$mmap);
                }
                try {
                    raf.setLength(roundedNewSize);
                    this.$outer.kafka$log$OffsetIndex$$mmap = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize);
                    this.$outer.kafka$log$OffsetIndex$$_maxEntries = this.$outer.kafka$log$OffsetIndex$$mmap.limit() / 8;
                    buffer = this.$outer.kafka$log$OffsetIndex$$mmap.position(position);
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new /* invalid duplicate definition of identical inner class */));
                    throw throwable;
                }
                return buffer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
    }

    public void kafka$log$OffsetIndex$$forceUnmap(MappedByteBuffer m) {
        try {
            if (m instanceof DirectBuffer) {
                ((DirectBuffer)((Object)m)).cleaner().clean();
            }
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error when freeing index buffer";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            }));
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.kafka$log$OffsetIndex$$mmap.force();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deleting index ").append((Object)this.$outer.file().getAbsolutePath()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        if (Os$.MODULE$.isWindows()) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OffsetIndex $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$OffsetIndex$$forceUnmap(this.$outer.kafka$log$OffsetIndex$$mmap);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
        }
        return this.file().delete();
    }

    public boolean forceDelete() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deleting index ").append((Object)this.$outer.file().getAbsolutePath()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$OffsetIndex$$forceUnmap(this.$outer.kafka$log$OffsetIndex$$mmap);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$_entries;
    }

    public int sizeInBytes() {
        return 8 * this.kafka$log$OffsetIndex$$_entries;
    }

    public void close() {
        this.trimToValidSize();
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback(this.kafka$log$OffsetIndex$$_file.toPath(), f.toPath());
            return;
        }
        finally {
            this.kafka$log$OffsetIndex$$_file = f;
        }
    }

    public void sanityCheck() {
        Predef$.MODULE$.require(this.kafka$log$OffsetIndex$$_entries == 0 || this.lastOffset() > this.baseOffset(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Corrupt index found, index file (%s) has non-zero size but the last offset is %d and the base offset is %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$log$OffsetIndex$$_file.getAbsolutePath(), BoxesRunTime.boxToLong(this.$outer.lastOffset()), BoxesRunTime.boxToLong(this.$outer.baseOffset())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        long len = this.kafka$log$OffsetIndex$$_file.length();
        Predef$.MODULE$.require(len % 8L == 0L, (Function0<Object>)((Object)new Serializable(this, len){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long len$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Index file ").append((Object)this.$outer.kafka$log$OffsetIndex$$_file.getName()).append((Object)" is corrupt, found ").append(BoxesRunTime.boxToLong(this.len$1)).append((Object)" bytes which is not positive or not a multiple of 8.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.len$1 = len$1;
            }
        }));
    }

    public int kafka$log$OffsetIndex$$roundToExactMultiple(int number2, int factor) {
        return factor * (number2 / factor);
    }

    private <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        try {
            return fun.apply();
        }
        finally {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize) {
        this.kafka$log$OffsetIndex$$_file = _file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = _file.createNewFile();
        RandomAccessFile raf = new RandomAccessFile(_file, "rw");
        if (newlyCreated) {
            if (maxIndexSize < 8) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append(BoxesRunTime.boxToInteger(maxIndexSize)).toString());
            }
            raf.setLength(this.kafka$log$OffsetIndex$$roundToExactMultiple(maxIndexSize, 8));
        }
        long len = raf.length();
        MappedByteBuffer idx = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len);
        Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$OffsetIndex$$roundToExactMultiple(idx.limit(), 8));
        this.kafka$log$OffsetIndex$$mmap = idx;
        this.kafka$log$OffsetIndex$$_entries = this.kafka$log$OffsetIndex$$mmap.position() / 8;
        this.kafka$log$OffsetIndex$$_maxEntries = this.kafka$log$OffsetIndex$$mmap.limit() / 8;
        this.kafka$log$OffsetIndex$$_lastOffset = this.readLastEntry().offset();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$log$OffsetIndex$$_file.getAbsolutePath(), BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$_maxEntries), BoxesRunTime.boxToInteger(this.$outer.maxIndexSize()), BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$_entries), BoxesRunTime.boxToLong(this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$mmap.position())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        return;
        finally {
            CoreUtils$.MODULE$.swallow(new $anonfun$1(this, raf));
        }
    }
}

