/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.OffsetCheckpoint;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-g!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007!q\u0002%\u0003\u0002 \u0013\t)\u0011I\u001d:bsB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0011!I\u0003A!A!\u0002\u0013i\u0012\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001\\8hgV\tQ\u0006\u0005\u0003\u000f]A2\u0014BA\u0018\u0010\u0005\u0011\u0001vn\u001c7\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\"\u0011AB2p[6|g.\u0003\u00026e\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005]BT\"\u0001\u0002\n\u0005e\u0012!a\u0001'pO\"A1\b\u0001B\u0001B\u0003%Q&A\u0003m_\u001e\u001c\b\u0005C\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0001\u000b\u0005CA\u001c\u0001\u0011\u0015QB\b1\u0001\u001e\u0011\u0015YC\b1\u0001.\u0011\u001d\u0019\u0005A1A\u0005B\u0011\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%%\u0003\u0011a\u0017M\\4\n\u0005);%AB*ue&tw\r\u0003\u0004M\u0001\u0001\u0006I!R\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0005O\u0001\t\u0007I\u0011\u0001\u0002E\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\"1\u0001\u000b\u0001Q\u0001\n\u0015\u000bQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002\u0017\rDWmY6q_&tGo]\u000b\u0002)B!QK\u0017\u0011]\u001b\u00051&BA,Y\u0003%IW.\\;uC\ndWM\u0003\u0002Z\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m3&aA'baB\u0011Q\fY\u0007\u0002=*\u0011q\fB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0005t&\u0001E(gMN,Go\u00115fG.\u0004x.\u001b8u\u0011\u0019\u0019\u0007\u0001)A\u0005)\u0006a1\r[3dWB|\u0017N\u001c;tA!9Q\r\u0001b\u0001\n\u00131\u0017AC5o!J|wM]3tgV\tq\r\u0005\u0003iWBjW\"A5\u000b\u0005)D\u0016aB7vi\u0006\u0014G.Z\u0005\u0003Y&\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u00028]&\u0011qN\u0001\u0002\u0011\u0019><7\t\\3b]&twm\u0015;bi\u0016Da!\u001d\u0001!\u0002\u00139\u0017aC5o!J|wM]3tg\u0002Bqa\u001d\u0001C\u0002\u0013%A/\u0001\u0003m_\u000e\\W#A;\u0011\u0005YlX\"A<\u000b\u0005aL\u0018!\u00027pG.\u001c(B\u0001>|\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003y\u0012\nA!\u001e;jY&\u0011ap\u001e\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\u000f\u0005\u0005\u0001\u0001)A\u0005k\u0006)An\\2lA!I\u0011Q\u0001\u0001C\u0002\u0013%\u0011qA\u0001\u0013a\u0006,8/\u001a3DY\u0016\fg.\u001b8h\u0007>tG-\u0006\u0002\u0002\nA\u0019a/a\u0003\n\u0007\u00055qOA\u0005D_:$\u0017\u000e^5p]\"A\u0011\u0011\u0003\u0001!\u0002\u0013\tI!A\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$\u0007\u0005C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005IB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p+\t\tI\u0002E\u0002\t\u00037I1!!\b\n\u0005\u0019!u.\u001e2mK\"I\u0011\u0011\u0005\u0001A\u0002\u0013%\u00111E\u0001\u001eI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLwn\u0018\u0013fcR!\u0011QEA\u0016!\rA\u0011qE\u0005\u0004\u0003SI!\u0001B+oSRD!\"!\f\u0002 \u0005\u0005\t\u0019AA\r\u0003\rAH%\r\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u0002\u001a\u0005QB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5pA!\"\u0011qFA\u001b!\rA\u0011qG\u0005\u0004\u0003sI!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005)\u0012\r\u001c7DY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cHCAA!!\u001d\t\u0019%!\u00131\u0003\u001br1\u0001CA#\u0013\r\t9%C\u0001\u0007!J,G-\u001a4\n\u0007m\u000bYEC\u0002\u0002H%\u00012\u0001CA(\u0013\r\t\t&\u0003\u0002\u0005\u0019>tw\rC\u0004\u0002V\u0001!\t!a\u0016\u0002!\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0019><GCAA-!\u0015A\u00111LA0\u0013\r\ti&\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007]\n\t'C\u0002\u0002d\t\u0011!\u0002T8h)>\u001cE.Z1o\u0011\u001d\t9\u0007\u0001C\u0001\u0003S\nQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA\u0013\u0003WBq!!\u001c\u0002f\u0001\u0007\u0001'A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!!\u001d\u0001\t\u0003\t\u0019(A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005\u0015\u0012Q\u000f\u0005\b\u0003[\ny\u00071\u00011\u0011\u001d\tI\b\u0001C\u0001\u0003w\naB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u0002&\u0005u\u0004bBA7\u0003o\u0002\r\u0001\r\u0005\b\u0003\u0003\u0003A\u0011BAB\u0003EI7o\u00117fC:LgnZ%o'R\fG/\u001a\u000b\u0007\u0003\u000b\u000bY)!$\u0011\u0007!\t9)C\u0002\u0002\n&\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002n\u0005}\u0004\u0019\u0001\u0019\t\u000f\u0005=\u0015q\u0010a\u0001[\u0006iQ\r\u001f9fGR,Gm\u0015;bi\u0016Dq!a%\u0001\t\u0003\t)*\u0001\u000bdQ\u0016\u001c7n\u00117fC:LgnZ!c_J$X\r\u001a\u000b\u0005\u0003K\t9\nC\u0004\u0002n\u0005E\u0005\u0019\u0001\u0019\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\u0006\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\r\u0005\u0015\u0012qTAR\u0011\u001d\t\t+!'A\u0002\u0001\nq\u0001Z1uC\u0012K'\u000f\u0003\u0005\u0002&\u0006e\u0005\u0019AAT\u0003\u0019)\b\u000fZ1uKB)\u0001\"a\u0017\u0002*B1\u0001\"a+1\u0003\u001bJ1!!,\n\u0005\u0019!V\u000f\u001d7fe!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t)#!.\u00028\u0006e\u0006bBAQ\u0003_\u0003\r\u0001\t\u0005\b\u0003[\ny\u000b1\u00011\u0011!\tY,a,A\u0002\u00055\u0013AB8gMN,G\u000fC\u0004\u0002@\u0002!\t!!1\u0002\u0019\u0011|g.Z\"mK\u0006t\u0017N\\4\u0015\u0011\u0005\u0015\u00121YAc\u0003\u000fDq!!\u001c\u0002>\u0002\u0007\u0001\u0007C\u0004\u0002\"\u0006u\u0006\u0019\u0001\u0011\t\u0011\u0005%\u0017Q\u0018a\u0001\u0003\u001b\n\u0011\"\u001a8e\u001f\u001a47/\u001a;")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogCleanerManager$$checkpoints;
    private final HashMap<TopicAndPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress;
    private final ReentrantLock lock;
    private final Condition kafka$log$LogCleanerManager$$pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogCleanerManager$$checkpoints() {
        return this.kafka$log$LogCleanerManager$$checkpoints;
    }

    public HashMap<TopicAndPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress() {
        return this.kafka$log$LogCleanerManager$$inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Condition kafka$log$LogCleanerManager$$pausedCleaningCond() {
        return this.kafka$log$LogCleanerManager$$pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    public void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public scala.collection.immutable.Map<TopicAndPartition, Object> allCleanerCheckpoints() {
        return ((TraversableOnce)this.kafka$log$LogCleanerManager$$checkpoints().values().flatMap(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<TopicAndPartition, Object> apply(OffsetCheckpoint x$1) {
                return x$1.read();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Option<LogToClean> grabFilthiestLog() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final Option<LogToClean> apply() {
                Option option;
                scala.collection.immutable.Map<TopicAndPartition, Object> lastClean = this.$outer.allCleanerCheckpoints();
                Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.$outer.logs().filter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicAndPartition, Log> x0$1) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Log log2 = tuple2._2();
                            boolean bl = log2.config().compact();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).filterNot(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$grabFilthiestLog$1 $outer;

                    public final boolean apply(Tuple2<TopicAndPartition, Log> x0$2) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$2;
                        if (tuple2 != null) {
                            TopicAndPartition topicAndPartition = tuple2._1();
                            boolean bl = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains(topicAndPartition);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).map(new scala.Serializable(this, lastClean){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$grabFilthiestLog$1 $outer;
                    private final scala.collection.immutable.Map lastClean$1;

                    public final LogToClean apply(Tuple2<TopicAndPartition, Log> x0$3) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$3;
                        if (tuple2 != null) {
                            long l;
                            Log log2;
                            long logStartOffset;
                            TopicAndPartition topicAndPartition = tuple2._1();
                            long offset = BoxesRunTime.unboxToLong(this.lastClean$1.getOrElse(topicAndPartition, new scala.Serializable(this, logStartOffset = ((LogSegment)(log2 = tuple2._2()).logSegments().head()).baseOffset()){
                                public static final long serialVersionUID = 0L;
                                private final long logStartOffset$1;

                                public final long apply() {
                                    return this.apply$mcJ$sp();
                                }

                                public long apply$mcJ$sp() {
                                    return this.logStartOffset$1;
                                }
                                {
                                    this.logStartOffset$1 = logStartOffset$1;
                                }
                            }));
                            if (offset < logStartOffset) {
                                this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().error((Function0<String>)((Object)new scala.Serializable(this, logStartOffset, offset){
                                    public static final long serialVersionUID = 0L;
                                    private final long logStartOffset$1;
                                    private final long offset$2;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Resetting first dirty offset to log start offset %d since the checkpointed offset %d is invalid.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.logStartOffset$1), BoxesRunTime.boxToLong(this.offset$2)}));
                                    }
                                    {
                                        this.logStartOffset$1 = logStartOffset$1;
                                        this.offset$2 = offset$2;
                                    }
                                }));
                                l = logStartOffset;
                            } else {
                                l = offset;
                            }
                            long firstDirtyOffset = l;
                            LogToClean logToClean = new LogToClean(topicAndPartition, log2, firstDirtyOffset);
                            return logToClean;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.lastClean$1 = lastClean$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.totalBytes() > 0L;
                    }
                });
                this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.isEmpty() ? 0.0 : ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.conforms()))).cleanableRatio());
                Iterable cleanableLogs = (Iterable)dirtyLogs.filter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
                    }
                });
                if (cleanableLogs.isEmpty()) {
                    option = None$.MODULE$;
                } else {
                    LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.conforms()));
                    this.$outer.kafka$log$LogCleanerManager$$inProgress().put(filthiest.topicPartition(), LogCleaningInProgress$.MODULE$);
                    option = new Some<LogToClean>(filthiest);
                }
                return option;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.abortAndPauseCleaning(this.topicAndPartition$1);
                this.$outer.resumeCleaning(this.topicAndPartition$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("The cleaning for partition %s is aborted")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1}));
            }
            {
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        }));
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option<LogCleaningState> option;
                block7: {
                    LogCleaningState logCleaningState;
                    block8: {
                        block6: {
                            LogCleaningState state;
                            Option<LogCleaningState> option2;
                            block5: {
                                option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get(this.topicAndPartition$3);
                                None$ none$ = None$.MODULE$;
                                Option<LogCleaningState> option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                                option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicAndPartition$3, LogCleaningPaused$.MODULE$);
                                break block6;
                            }
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            logCleaningState = state = (LogCleaningState)some.x();
                            LogCleaningInProgress$ logCleaningInProgress$ = LogCleaningInProgress$.MODULE$;
                            LogCleaningState logCleaningState2 = logCleaningState;
                            if (logCleaningInProgress$ != null ? !logCleaningInProgress$.equals(logCleaningState2) : logCleaningState2 != null) break block8;
                            Option<LogCleaningState> option4 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicAndPartition$3, LogCleaningAborted$.MODULE$);
                            option2 = option4;
                        }
                        while (true) {
                            if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicAndPartition$3, LogCleaningPaused$.MODULE$)) {
                                return;
                            }
                            this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
                        }
                    }
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Compaction for partition %s cannot be aborted and paused since it is in %s state.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$3, logCleaningState})));
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("The cleaning for partition %s is aborted and paused")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$3}));
            }
            {
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        }));
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$4;

            public final Option<LogCleaningState> apply() {
                Option<LogCleaningState> option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get(this.topicAndPartition$4);
                None$ none$ = None$.MODULE$;
                Option<LogCleaningState> option2 = option;
                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Compaction for partition %s cannot be resumed since it is not paused.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$4})));
                }
                if (option instanceof Some) {
                    LogCleaningState state;
                    Some some = (Some)option;
                    LogCleaningState logCleaningState = state = (LogCleaningState)some.x();
                    LogCleaningPaused$ logCleaningPaused$ = LogCleaningPaused$.MODULE$;
                    LogCleaningState logCleaningState2 = logCleaningState;
                    if (!(logCleaningPaused$ != null ? !logCleaningPaused$.equals(logCleaningState2) : logCleaningState2 != null)) {
                        Option<LogCleaningState> option3;
                        Option<LogCleaningState> option4 = option3 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicAndPartition$4);
                        return option4;
                    }
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Compaction for partition %s cannot be resumed since it is in %s state.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$4, logCleaningState})));
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$4 = topicAndPartition$4;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$4;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Compaction for partition %s is resumed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$4}));
            }
            {
                this.topicAndPartition$4 = topicAndPartition$4;
            }
        }));
    }

    public boolean kafka$log$LogCleanerManager$$isCleaningInState(TopicAndPartition topicAndPartition, LogCleaningState expectedState) {
        Option<LogCleaningState> option;
        block4: {
            boolean bl;
            block3: {
                LogCleaningState state;
                block2: {
                    option = this.kafka$log$LogCleanerManager$$inProgress().get(topicAndPartition);
                    None$ none$ = None$.MODULE$;
                    Option<LogCleaningState> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    bl = false;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogCleaningState logCleaningState = state = (LogCleaningState)some.x();
                LogCleaningState logCleaningState2 = expectedState;
                bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public void checkCleaningAborted(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicAndPartition$5, LogCleaningAborted$.MODULE$)) {
                    throw new LogCleaningAbortedException();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$5 = topicAndPartition$5;
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicAndPartition, Object>> update2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, dataDir, update2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$1;
            private final Option update$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply(this.dataDir$1);
                Map<TopicAndPartition, Object> existing = checkpoint.read().filterKeys(this.$outer.logs().keys()).$plus$plus(Option$.MODULE$.option2Iterable(this.update$1));
                checkpoint.write(existing);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataDir$1 = dataDir$1;
                this.update$1 = update$1;
            }
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicAndPartition topicAndPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, dataDir, topicAndPartition, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$2;
            private final TopicAndPartition topicAndPartition$2;
            private final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpoint checkpoint;
                Map<TopicAndPartition, Object> existing;
                if (this.$outer.logs().get(this.topicAndPartition$2).config().compact() && BoxesRunTime.unboxToLong((existing = (checkpoint = (OffsetCheckpoint)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply(this.dataDir$2)).read()).getOrElse(this.topicAndPartition$2, new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) > this.offset$1) {
                    checkpoint.write(existing.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(this.topicAndPartition$2), BoxesRunTime.boxToLong(this.offset$1))));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataDir$2 = dataDir$2;
                this.topicAndPartition$2 = topicAndPartition$2;
                this.offset$1 = offset$1;
            }
        });
    }

    public void doneCleaning(TopicAndPartition topicAndPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicAndPartition, dataDir, endOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$6;
            private final File dataDir$3;
            private final long endOffset$1;

            public final Object apply() {
                LogCleaningState logCleaningState;
                block4: {
                    Serializable serializable2;
                    block3: {
                        block2: {
                            logCleaningState = this.$outer.kafka$log$LogCleanerManager$$inProgress().apply(this.topicAndPartition$6);
                            LogCleaningInProgress$ logCleaningInProgress$ = LogCleaningInProgress$.MODULE$;
                            LogCleaningState logCleaningState2 = logCleaningState;
                            if (logCleaningInProgress$ != null ? !logCleaningInProgress$.equals(logCleaningState2) : logCleaningState2 != null) break block2;
                            this.$outer.updateCheckpoints(this.dataDir$3, Option$.MODULE$.apply(new Tuple2<TopicAndPartition, Long>(this.topicAndPartition$6, BoxesRunTime.boxToLong(this.endOffset$1))));
                            serializable2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicAndPartition$6);
                            break block3;
                        }
                        LogCleaningAborted$ logCleaningAborted$ = LogCleaningAborted$.MODULE$;
                        LogCleaningState logCleaningState3 = logCleaningState;
                        if (logCleaningAborted$ != null ? !logCleaningAborted$.equals(logCleaningState3) : logCleaningState3 != null) break block4;
                        this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicAndPartition$6, LogCleaningPaused$.MODULE$);
                        this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().signalAll();
                        serializable2 = BoxedUnit.UNIT;
                    }
                    return serializable2;
                }
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("In-progress partition %s cannot be in %s state.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$6, logCleaningState})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$6 = topicAndPartition$6;
                this.dataDir$3 = dataDir$3;
                this.endOffset$1 = endOffset$1;
            }
        });
    }

    public LogCleanerManager(File[] logDirs, Pool<TopicAndPartition, Log> logs) {
        this.logDirs = logDirs;
        this.logs = logs;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.kafka$log$LogCleanerManager$$checkpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map(new $anonfun$2(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        this.kafka$log$LogCleanerManager$$inProgress = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.kafka$log$LogCleanerManager$$pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

