/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.MagicAndTimestamp;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.kafka.common.record.TimestampType;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcJ$sp;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015a!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011aBN\u0005\u0003o=\u0011A\u0001V5nK\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001bO\u001fD\u0013\ta\u0014BA\u0005Gk:\u001cG/[8ocA\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u0007G>lWn\u001c8\n\u0005\t{$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011\u0001\u0002R\u0005\u0003\u000b&\u0011A!\u00168ji\")q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"\u0012\"\u0013&L\u00196su\nU)\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bG\u0001\u00049\u0002\"B\u000fG\u0001\u0004y\u0002\"\u0002\u0014G\u0001\u00049\u0002\"\u0002\u0015G\u0001\u00049\u0002\"\u0002\u0016G\u0001\u0004Y\u0003\"B\u0018G\u0001\u0004\u0001\u0004\"\u0002\u001bG\u0001\u0004)\u0004\"B\u001dG\u0001\u0004Q\u0004bB*\u0001\u0005\u0004%\t\u0005V\u0001\u000bY><w-\u001a:OC6,W#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n11\u000b\u001e:j]\u001eDaA\u0018\u0001!\u0002\u0013)\u0016a\u00037pO\u001e,'OT1nK\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-A\bti\u0006$8/\u00168eKJd\u00170\u001b8h+\u0005\u0011\u0007\u0003\u0002\u0005dK\u0016L!\u0001Z\u0005\u0003\rQ+\b\u000f\\33!\t\u0001c-\u0003\u0002h\u0005\ta1\t\\3b]\u0016\u00148\u000b^1ug\"1\u0011\u000e\u0001Q\u0001\n\t\f\u0001c\u001d;biN,f\u000eZ3sYfLgn\u001a\u0011\t\u000b-\u0004A\u0011\u00017\u0002\u000bM$\u0018\r^:\u0016\u0003\u0015DqA\u001c\u0001A\u0002\u0013%q.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gf\u000b1A\\5p\u0013\t)(O\u0001\u0006CsR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005\rK\bb\u0002>w\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\n\u0004B\u0002?\u0001A\u0003&\u0001/A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003b\u0002@\u0001\u0001\u0004%Ia\\\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004\u0005yqO]5uK\n+hMZ3s?\u0012*\u0017\u000fF\u0002D\u0003\u000bAqA_@\u0002\u0002\u0003\u0007\u0001\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0015\u00029\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\t\u0011\u00055\u0001\u0001\"\u0001\u0003\u0003\u001f\tQa\u00197fC:$B!!\u0005\u0002\u0018A\u0019\u0001\"a\u0005\n\u0007\u0005U\u0011B\u0001\u0003M_:<\u0007\u0002CA\r\u0003\u0017\u0001\r!a\u0007\u0002\u0013\rdW-\u00198bE2,\u0007c\u0001\u0011\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002$\u0001!\tAAA\u0013\u00035\u0019G.Z1o'\u0016<W.\u001a8ugRI1)a\n\u00020\u0005\u0015\u0013\u0011\n\u0005\b\u0007\u0005\u0005\u0002\u0019AA\u0015!\r\u0001\u00131F\u0005\u0004\u0003[\u0011!a\u0001'pO\"A\u0011\u0011GA\u0011\u0001\u0004\t\u0019$\u0001\u0005tK\u001elWM\u001c;t!\u0019\t)$a\u000f\u0002@5\u0011\u0011q\u0007\u0006\u0004\u0003sI\u0011AC2pY2,7\r^5p]&!\u0011QHA\u001c\u0005\r\u0019V-\u001d\t\u0004A\u0005\u0005\u0013bAA\"\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005\u001d\u0013\u0011\u0005a\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005-\u0013\u0011\u0005a\u0001\u0003#\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u001f\u0002A\u0011\u0001\u0002\u0002R\u0005I1\r\\3b]&sGo\u001c\u000b\u000e\u0007\u0006M\u0013qKA.\u0003?\n\t'a\u001b\t\u000f\u0005U\u0013Q\na\u0001{\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005e\u0013Q\na\u0001\u0003\u007f\taa]8ve\u000e,\u0007\u0002CA/\u0003\u001b\u0002\r!a\u0010\u0002\t\u0011,7\u000f\u001e\u0005\b\u0003\u000f\ni\u00051\u0001 \u0011!\t\u0019'!\u0014A\u0002\u0005\u0015\u0014!\u0004:fi\u0006Lg\u000eR3mKR,7\u000fE\u0002\t\u0003OJ1!!\u001b\n\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u001c\u0002N\u0001\u0007\u0011qN\u0001\u0015[\u0016\u001c8/Y4f\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0011\u0007!\t\t(C\u0002\u0002t%\u0011AAQ=uK\"9\u0011q\u000f\u0001\u0005\n\u0005e\u0014\u0001E2p[B\u0014Xm]:NKN\u001c\u0018mZ3t)%\u0019\u00151PA@\u0003\u001f\u000b\t\nC\u0004\u0002~\u0005U\u0004\u0019\u00019\u0002\r\t,hMZ3s\u0011!\t\t)!\u001eA\u0002\u0005\r\u0015\u0001E2p[B\u0014Xm]:j_:\u001cu\u000eZ3d!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE\t\u00059Q.Z:tC\u001e,\u0017\u0002BAG\u0003\u000f\u0013\u0001cQ8naJ,7o]5p]\u000e{G-Z2\t\u0011\u00055\u0014Q\u000fa\u0001\u0003_B\u0001\"a%\u0002v\u0001\u0007\u0011QS\u0001\u0012[\u0016\u001c8/Y4f\u0003:$wJ\u001a4tKR\u001c\bCBA\u001b\u0003w\t9\n\u0005\u0003\u0002\u0006\u0006e\u0015\u0002BAN\u0003\u000f\u0013\u0001#T3tg\u0006<W-\u00118e\u001f\u001a47/\u001a;\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\u0006\u00192\u000f[8vY\u0012\u0014V\r^1j]6+7o]1hKRQ\u0011QMAR\u0003K\u000b9+!+\t\u0011\u0005e\u0013Q\u0014a\u0001\u0003\u007fAq!a\u0012\u0002\u001e\u0002\u0007q\u0004\u0003\u0005\u0002d\u0005u\u0005\u0019AA3\u0011!\tY+!(A\u0002\u0005]\u0015!B3oiJL\bbBAX\u0001\u0011\u0005\u0011\u0011W\u0001\fOJ|wOQ;gM\u0016\u00148\u000fF\u0001D\u0011\u001d\t)\f\u0001C\u0001\u0003c\u000baB]3ti>\u0014XMQ;gM\u0016\u00148\u000f\u0003\u0005\u0002:\u0002!\tAAA^\u0003M9'o\\;q'\u0016<W.\u001a8ug\nK8+\u001b>f)!\ti,!6\u0002^\u0006\u0005\bCBA`\u0003\u001f\f\u0019D\u0004\u0003\u0002B\u0006-g\u0002BAb\u0003\u0013l!!!2\u000b\u0007\u0005\u001dW#\u0001\u0004=e>|GOP\u0005\u0002\u0015%\u0019\u0011QZ\u0005\u0002\u000fA\f7m[1hK&!\u0011\u0011[Aj\u0005\u0011a\u0015n\u001d;\u000b\u0007\u00055\u0017\u0002\u0003\u0005\u00022\u0005]\u0006\u0019AAl!\u0019\t)$!7\u0002@%!\u00111\\A\u001c\u0005!IE/\u001a:bE2,\u0007bBAp\u0003o\u0003\raF\u0001\b[\u0006D8+\u001b>f\u0011\u001d\t\u0019/a.A\u0002]\tA\"\\1y\u0013:$W\r_*ju\u0016D\u0001\"a:\u0001\t\u0003\u0011\u0011\u0011^\u0001\u000fEVLG\u000eZ(gMN,G/T1q))\t\t\"a;\u0002n\u0006E\u0018Q\u001f\u0005\b\u0007\u0005\u0015\b\u0019AA\u0015\u0011!\ty/!:A\u0002\u0005E\u0011!B:uCJ$\b\u0002CAz\u0003K\u0004\r!!\u0005\u0002\u0007\u0015tG\rC\u0004\u0002H\u0005\u0015\b\u0019A\u0010\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006A\"-^5mI>3gm]3u\u001b\u0006\u0004hi\u001c:TK\u001elWM\u001c;\u0015\u0011\u0005E\u0011Q`A\u0000\u0005\u0007Aq!!\u0016\u0002x\u0002\u0007Q\b\u0003\u0005\u0003\u0002\u0005]\b\u0019AA \u0003\u001d\u0019XmZ7f]RDq!a\u0012\u0002x\u0002\u0007q\u0004")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final Tuple2<CleanerStats, CleanerStats> statsUnderlying;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public Tuple2<CleanerStats, CleanerStats> statsUnderlying() {
        return this.statsUnderlying;
    }

    public CleanerStats stats() {
        return this.statsUnderlying()._1();
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    public ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$writeBuffer = x$1;
    }

    public long clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log2;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    log2 = cleanable.log();
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    long upperBoundOffset = log2.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log2, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap()) + 1L;
                    this.stats().indexDone();
                    option = log2.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(log2.config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            this.info((Function0<String>)((Object)new Serializable(this, log2, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (discarding tombstones prior to %s)...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            }));
            this.groupSegmentsBySize(log2.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log2.config().segmentSize()), Predef$.MODULE$.Integer2int(log2.config().maxIndexSize())).foreach(new Serializable(this, log2, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            });
            this.stats().bufferUtilization_$eq(this.offsetMap().utilization());
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError(option);
    }

    public void cleanSegments(Log log2, Seq<LogSegment> segments, OffsetMap map2, long deleteHorizonMs) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile, false, log2.initFileSize(), Predef$.MODULE$.Boolean2boolean(log2.config().preallocate()));
        OffsetIndex index2 = new OffsetIndex(indexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).index().maxIndexSize());
        LogSegment cleaned = new LogSegment(messages, index2, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).indexIntervalBytes(), log2.config().randomSegmentJitter(), this.time);
        try {
            segments.foreach(new Serializable(this, log2, map2, deleteHorizonMs, cleaned){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final Log log$3;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                public final LogSegment cleaned$1;

                public final void apply(LogSegment old) {
                    boolean retainDeletes = old.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, old, retainDeletes){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanSegments$1 $outer;
                        private final LogSegment old$1;
                        private final boolean retainDeletes$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (last modified %s) into %s, %s deletes.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.old$1.baseOffset()), this.$outer.log$3.name(), new Date(this.old$1.lastModified()), BoxesRunTime.boxToLong(this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.old$1 = old$1;
                            this.retainDeletes$1 = retainDeletes$1;
                        }
                    }));
                    this.$outer.cleanInto(this.log$3.topicAndPartition(), old, this.cleaned$1, this.map$2, retainDeletes, this.log$3.config().messageFormatVersion().messageFormatVersion());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$3 = log$3;
                    this.map$2 = map$2;
                    this.deleteHorizonMs$2 = deleteHorizonMs$2;
                    this.cleaned$1 = cleaned$1;
                }
            });
            index2.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)((Object)new Serializable(this, log2, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$12) {
                            return x$12.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            }));
            log2.replaceSegments(cleaned, segments, log2.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source, LogSegment dest, OffsetMap map2, boolean retainDeletes, byte messageFormatVersion) {
        int position = 0;
        while (position < source.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead = new IntRef(0);
            messages.shallowIterator().foreach(new Serializable(this, source, map2, retainDeletes, messageFormatVersion, messagesRead){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final LogSegment source$1;
                public final OffsetMap map$3;
                public final boolean retainDeletes$2;
                private final byte messageFormatVersion$1;
                public final IntRef messagesRead$1;

                public final void apply(MessageAndOffset entry2) {
                    int size2 = MessageSet$.MODULE$.entrySize(entry2.message());
                    this.$outer.stats().readMessage(size2);
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                        if (this.$outer.kafka$log$Cleaner$$shouldRetainMessage(this.source$1, this.map$3, this.retainDeletes$2, entry2)) {
                            ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message(), entry2.offset());
                            this.$outer.stats().recopyMessage(size2);
                        }
                        ++this.messagesRead$1.elem;
                    } else {
                        Iterator<MessageAndOffset> messages = ByteBufferMessageSet$.MODULE$.deepIterator(entry2);
                        BooleanRef writeOriginalMessageSet = new BooleanRef(true);
                        ArrayBuffer<MessageAndOffset> retainedMessages = new ArrayBuffer<MessageAndOffset>();
                        messages.foreach(new Serializable(this, writeOriginalMessageSet, retainedMessages){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$cleanInto$1 $outer;
                            private final BooleanRef writeOriginalMessageSet$1;
                            private final ArrayBuffer retainedMessages$1;

                            public final Object apply(MessageAndOffset messageAndOffset) {
                                Object object;
                                ++this.$outer.messagesRead$1.elem;
                                if (this.$outer.kafka$log$Cleaner$$anonfun$$$outer().kafka$log$Cleaner$$shouldRetainMessage(this.$outer.source$1, this.$outer.map$3, this.$outer.retainDeletes$2, messageAndOffset)) {
                                    object = this.retainedMessages$1.$plus$eq(messageAndOffset);
                                } else {
                                    this.writeOriginalMessageSet$1.elem = false;
                                    object = BoxedUnit.UNIT;
                                }
                                return object;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.writeOriginalMessageSet$1 = writeOriginalMessageSet$1;
                                this.retainedMessages$1 = retainedMessages$1;
                            }
                        });
                        if (writeOriginalMessageSet.elem) {
                            ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message(), entry2.offset());
                        } else {
                            this.$outer.kafka$log$Cleaner$$compressMessages(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message().compressionCodec(), this.messageFormatVersion$1, retainedMessages);
                        }
                    }
                }

                public /* synthetic */ Cleaner kafka$log$Cleaner$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.source$1 = source$1;
                    this.map$3 = map$3;
                    this.retainDeletes$2 = retainDeletes$2;
                    this.messageFormatVersion$1 = messageFormatVersion$1;
                    this.messagesRead$1 = messagesRead$1;
                }
            });
            position += messages.validBytes();
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void kafka$log$Cleaner$$compressMessages(ByteBuffer buffer, CompressionCodec compressionCodec, byte messageFormatVersion, Seq<MessageAndOffset> messageAndOffsets) {
        CompressionCodec compressionCodec2 = compressionCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        Predef$.MODULE$.require(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compressionCodec must not be ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{NoCompressionCodec$.MODULE$}));
            }
        }));
        if (messageAndOffsets.nonEmpty()) {
            Seq<Message> messages = messageAndOffsets.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Message apply(MessageAndOffset x$13) {
                    return x$13.message();
                }
            }, Seq$.MODULE$.canBuildFrom());
            MagicAndTimestamp magicAndTimestamp = MessageSet$.MODULE$.magicAndLargestTimestamp(messages);
            MessageAndOffset firstMessageOffset = (MessageAndOffset)messageAndOffsets.head();
            long firstAbsoluteOffset = firstMessageOffset.offset();
            LongRef offset = new LongRef(-1L);
            TimestampType timestampType2 = firstMessageOffset.message().timestampType();
            MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize(messages) / 2, 1024), 65536));
            CompressionCodec x$17 = compressionCodec;
            long x$18 = magicAndTimestamp.timestamp();
            TimestampType x$19 = timestampType2;
            byte x$20 = messageFormatVersion;
            byte[] x$21 = messageWriter.write$default$1();
            Serializable x$22 = new Serializable(this, compressionCodec, messageFormatVersion, messageAndOffsets, firstAbsoluteOffset, offset){
                public static final long serialVersionUID = 0L;
                private final CompressionCodec compressionCodec$1;
                public final byte messageFormatVersion$2;
                private final Seq messageAndOffsets$1;
                public final long firstAbsoluteOffset$1;
                public final LongRef offset$2;

                public final void apply(OutputStream outputStream) {
                    DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(this.compressionCodec$1, this.messageFormatVersion$2, outputStream));
                    try {
                        this.messageAndOffsets$1.foreach(new Serializable(this, output){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8 $outer;
                            private final DataOutputStream output$1;

                            public final void apply(MessageAndOffset messageOffset) {
                                Message message = messageOffset.message();
                                this.$outer.offset$2.elem = messageOffset.offset();
                                if (this.$outer.messageFormatVersion$2 > Message$.MODULE$.MagicValue_V0()) {
                                    long innerOffset = messageOffset.offset() - this.$outer.firstAbsoluteOffset$1;
                                    this.output$1.writeLong(innerOffset);
                                } else {
                                    this.output$1.writeLong(this.$outer.offset$2.elem);
                                }
                                this.output$1.writeInt(message.size());
                                this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.output$1 = output$1;
                            }
                        });
                        return;
                    }
                    finally {
                        output.close();
                    }
                }
                {
                    this.compressionCodec$1 = compressionCodec$1;
                    this.messageFormatVersion$2 = messageFormatVersion$2;
                    this.messageAndOffsets$1 = messageAndOffsets$1;
                    this.firstAbsoluteOffset$1 = firstAbsoluteOffset$1;
                    this.offset$2 = offset$2;
                }
            };
            messageWriter.write(x$21, x$17, x$18, x$19, x$20, (Function1<OutputStream, BoxedUnit>)((Object)x$22));
            ByteBufferMessageSet$.MODULE$.writeMessage(buffer, messageWriter, offset.elem);
            this.stats().recopyMessage(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
        }
    }

    public boolean kafka$log$Cleaner$$shouldRetainMessage(LogSegment source, OffsetMap map2, boolean retainDeletes, MessageAndOffset entry2) {
        boolean bl;
        ByteBuffer key = entry2.message().key();
        if (key == null) {
            this.stats().invalidMessage();
            bl = false;
        } else {
            long foundOffset = map2.get(key);
            boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
            boolean obsoleteDelete = !retainDeletes && entry2.message().isNull();
            bl = !redundant && !obsoleteDelete;
        }
        return bl;
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxIoBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)((Object)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append(BoxesRunTime.boxToInteger(this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped2 = Nil$.MODULE$;
        List segs = segments.toList();
        while (!segs.isEmpty()) {
            List<Object> list2;
            List list3;
            List<LogSegment> group = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)list3.head()}));
            long logSize = ((LogSegment)list3.head()).size();
            int indexSize = ((LogSegment)list3.head()).index().sizeInBytes();
            list3 = (List)list3.tail();
            while (!list3.isEmpty() && logSize + ((LogSegment)list3.head()).size() <= (long)maxSize && indexSize + ((LogSegment)list3.head()).index().sizeInBytes() <= maxIndexSize && ((LogSegment)list3.head()).index().lastOffset() - ((LogSegment)group.last()).index().baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)list3.head();
                group = group.$colon$colon(logSegment);
                logSize += ((LogSegment)list3.head()).size();
                indexSize += ((LogSegment)list3.head()).index().sizeInBytes();
                list3 = (List)list3.tail();
            }
            list2 = list2.$colon$colon(group.reverse());
        }
        return grouped2.reverse();
    }

    public long buildOffsetMap(Log log2, long start, long end, OffsetMap map2) {
        map2.clear();
        Buffer dirty = log2.logSegments(start, end).toBuffer();
        this.info((Function0<String>)((Object)new Serializable(this, log2, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger(this.dirty$1.size()), BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        }));
        LongRef offset = new LongRef(((LogSegment)dirty.head()).baseOffset());
        Predef$.MODULE$.require(offset.elem == start, (Function0<Object>)((Object)new Serializable(this, log2, start, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final LongRef offset$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Last clean offset is %d but segment base offset is %d for log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.offset$3.elem), this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.offset$3 = offset$3;
            }
        }));
        BooleanRef full = new BooleanRef(false);
        dirty.withFilter(new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        }).foreach(new Serializable(this, log2, start, map2, dirty, offset, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            public final Log log$2;
            private final long start$1;
            private final OffsetMap map$1;
            public final Buffer dirty$1;
            private final LongRef offset$3;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply(this.log$2.topicAndPartition());
                long newOffset = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicAndPartition(), segment, this.map$1);
                if (newOffset > -1L) {
                    this.offset$3.elem = newOffset;
                } else {
                    Predef$.MODULE$.require(this.offset$3.elem > this.start$1, (Function0<Object>)((Object)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$4 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Unable to build the offset map for segment %s/%s. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.log$2.name(), this.segment$1.log().file().getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    }));
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$4 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.dirty$1.indexOf(this.segment$1)), BoxesRunTime.boxToLong(this.segment$1.baseOffset())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    }));
                    this.full$1.elem = true;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.dirty$1 = dirty$1;
                this.offset$3 = offset$3;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)((Object)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        }));
        return offset.elem;
    }

    public long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            long l;
            Object object = new Object();
            try {
                int position = 0;
                LongRef offset = new LongRef(segment.baseOffset());
                int maxDesiredMapSize = (int)((double)map2.slots() * this.dupBufferLoadFactor);
                while (position < segment.log().sizeInBytes()) {
                    this.kafka$log$Cleaner$$checkDone.apply(topicAndPartition);
                    this.kafka$log$Cleaner$$readBuffer().clear();
                    ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position));
                    this.throttler.maybeThrottle(messages.sizeInBytes());
                    int startPosition = position;
                    messages.foreach(new Serializable(this, map2, offset, maxDesiredMapSize, object){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cleaner $outer;
                        private final OffsetMap map$4;
                        private final LongRef offset$4;
                        private final int maxDesiredMapSize$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(MessageAndOffset entry2) {
                            Message message = entry2.message();
                            if (message.hasKey()) {
                                if (this.map$4.size() < this.maxDesiredMapSize$1) {
                                    this.map$4.put(message.key(), entry2.offset());
                                } else {
                                    throw new NonLocalReturnControl$mcJ$sp(this.nonLocalReturnKey1$1, -1L);
                                }
                            }
                            this.offset$4.elem = entry2.offset();
                            this.$outer.stats().indexMessagesRead(1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.map$4 = map$4;
                            this.offset$4 = offset$4;
                            this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    this.stats().indexBytesRead(messages.validBytes());
                    if ((position += messages.validBytes()) != startPosition) continue;
                    this.growBuffers();
                }
                this.restoreBuffers();
                l = offset.elem;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                l = nonLocalReturnControl2.value$mcJ$sp();
            }
            return l;
        }
        throw nonLocalReturnControl2;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append(BoxesRunTime.boxToInteger(id)).append((Object)": ").toString());
        this.statsUnderlying = new Tuple2<CleanerStats, CleanerStats>(new CleanerStats(time), new CleanerStats(time));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

