/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.Topic$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicAndPartition;
import kafka.common.TopicExistsException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class AdminUtils$
implements Logging {
    public static final AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private final String EntityConfigChangeZnodePrefix;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public String EntityConfigChangeZnodePrefix() {
        return this.EntityConfigChangeZnodePrefix;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Map<Object, Seq<Object>> map2;
        if (nPartitions <= 0) {
            throw new AdminOperationException("number of partitions must be larger than 0");
        }
        if (replicationFactor <= 0) {
            throw new AdminOperationException("replication factor must be larger than 0");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new AdminOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factor: ", " larger than available brokers: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(replicationFactor), BoxesRunTime.boxToInteger(brokerMetadatas.size())})));
        }
        if (brokerMetadatas.forall((Function1<BrokerMetadata, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BrokerMetadata x$1) {
                return x$1.rack().isEmpty();
            }
        }))) {
            map2 = this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, brokerMetadatas.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(BrokerMetadata x$2) {
                    return x$2.id();
                }
            }, Seq$.MODULE$.canBuildFrom()), fixedStartIndex, startPartitionId);
        } else {
            if (brokerMetadatas.exists((Function1<BrokerMetadata, Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(BrokerMetadata x$3) {
                    return x$3.rack().isEmpty();
                }
            }))) {
                throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment");
            }
            map2 = this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
        }
        return map2;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = new IntRef(package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = fixedStartIndex >= 0 ? new IntRef(fixedStartIndex) : new IntRef(this.rand().nextInt(brokerArray.length));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(replicationFactor, ret, brokerArray, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$1;
            private final scala.collection.mutable.Map ret$1;
            public final int[] brokerArray$1;
            private final int startIndex$1;
            private final IntRef currentPartitionId$1;
            public final IntRef nextReplicaShift$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$1.elem > 0 && this.currentPartitionId$1.elem % this.brokerArray$1.length == 0) {
                    ++this.nextReplicaShift$1.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$1.elem + this.startIndex$1) % this.brokerArray$1.length;
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{this.brokerArray$1[firstReplicaIndex]}));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$1 - 1).foreach(new Serializable(this, firstReplicaIndex, replicaBuffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackUnaware.1 $outer;
                    private final int firstReplicaIndex$1;
                    private final ArrayBuffer replicaBuffer$1;

                    public final ArrayBuffer<Object> apply(int j) {
                        return this.replicaBuffer$1.$plus$eq(BoxesRunTime.boxToInteger(this.$outer.brokerArray$1[AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$1, this.$outer.nextReplicaShift$1.elem, j, this.$outer.brokerArray$1.length)]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$1 = firstReplicaIndex$1;
                        this.replicaBuffer$1 = replicaBuffer$1;
                    }
                });
                this.ret$1.put(BoxesRunTime.boxToInteger(this.currentPartitionId$1.elem), replicaBuffer);
                ++this.currentPartitionId$1.elem;
            }
            {
                this.replicationFactor$1 = replicationFactor$1;
                this.ret$1 = ret$1;
                this.brokerArray$1 = brokerArray$1;
                this.startIndex$1 = startIndex$1;
                this.currentPartitionId$1 = currentPartitionId$1;
                this.nextReplicaShift$1 = nextReplicaShift$1;
            }
        }));
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map<Object, String> brokerRackMap = ((TraversableOnce)brokerMetadatas.collect(new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var8_10;
                A1 A1 = x1;
                if (A1 != null) {
                    int id = A1.id();
                    Option<String> option = A1.rack();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.x();
                        Tuple2<Integer, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(id)), rack);
                        return var8_10;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var8_10;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                Option<String> option;
                BrokerMetadata brokerMetadata = x1;
                boolean bl = brokerMetadata != null && (option = brokerMetadata.rack()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList(brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = new IntRef(package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = fixedStartIndex >= 0 ? new IntRef(fixedStartIndex) : new IntRef(this.rand().nextInt(arrangedBrokerList.size()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(replicationFactor, brokerRackMap, numRacks, arrangedBrokerList, numBrokers, ret, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$2;
            public final scala.collection.immutable.Map brokerRackMap$1;
            public final int numRacks$1;
            public final IndexedSeq arrangedBrokerList$1;
            public final int numBrokers$1;
            private final scala.collection.mutable.Map ret$2;
            private final int startIndex$2;
            private final IntRef currentPartitionId$2;
            public final IntRef nextReplicaShift$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$2.elem > 0 && this.currentPartitionId$2.elem % this.arrangedBrokerList$1.size() == 0) {
                    ++this.nextReplicaShift$2.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$2.elem + this.startIndex$2) % this.arrangedBrokerList$1.size();
                int leader = BoxesRunTime.unboxToInt(this.arrangedBrokerList$1.apply(firstReplicaIndex));
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                scala.collection.mutable.Set racksWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.brokerRackMap$1.apply(BoxesRunTime.boxToInteger(leader))}));
                scala.collection.mutable.Set brokersWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                IntRef k = new IntRef(0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$2 - 1).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, firstReplicaIndex, replicaBuffer, racksWithReplicas, brokersWithReplicas, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackAware.1 $outer;
                    private final int firstReplicaIndex$2;
                    private final ArrayBuffer replicaBuffer$2;
                    private final scala.collection.mutable.Set racksWithReplicas$1;
                    private final scala.collection.mutable.Set brokersWithReplicas$1;
                    private final IntRef k$1;

                    public final void apply(int _) {
                        this.apply$mcVI$sp(_);
                    }

                    public void apply$mcVI$sp(int _) {
                        boolean done = false;
                        while (!done) {
                            int broker = BoxesRunTime.unboxToInt(this.$outer.arrangedBrokerList$1.apply(AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$2, this.$outer.nextReplicaShift$2.elem * this.$outer.numRacks$1, this.k$1.elem, this.$outer.arrangedBrokerList$1.size())));
                            String rack = (String)this.$outer.brokerRackMap$1.apply(BoxesRunTime.boxToInteger(broker));
                            if (!(this.racksWithReplicas$1.contains(rack) && this.racksWithReplicas$1.size() != this.$outer.numRacks$1 || this.brokersWithReplicas$1.contains(BoxesRunTime.boxToInteger(broker)) && this.brokersWithReplicas$1.size() != this.$outer.numBrokers$1)) {
                                this.replicaBuffer$2.$plus$eq(BoxesRunTime.boxToInteger(broker));
                                this.racksWithReplicas$1.$plus$eq(rack);
                                this.brokersWithReplicas$1.$plus$eq(BoxesRunTime.boxToInteger(broker));
                                done = true;
                            }
                            ++this.k$1.elem;
                        }
                        return;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$2 = firstReplicaIndex$2;
                        this.replicaBuffer$2 = replicaBuffer$2;
                        this.racksWithReplicas$1 = racksWithReplicas$1;
                        this.brokersWithReplicas$1 = brokersWithReplicas$1;
                        this.k$1 = k$1;
                    }
                }));
                this.ret$2.put(BoxesRunTime.boxToInteger(this.currentPartitionId$2.elem), replicaBuffer);
                ++this.currentPartitionId$2.elem;
            }
            {
                this.replicationFactor$2 = replicationFactor$2;
                this.brokerRackMap$1 = brokerRackMap$1;
                this.numRacks$1 = numRacks$1;
                this.arrangedBrokerList$1 = arrangedBrokerList$1;
                this.numBrokers$1 = numBrokers$1;
                this.ret$2 = ret$2;
                this.startIndex$2 = startIndex$2;
                this.currentPartitionId$2 = currentPartitionId$2;
                this.nextReplicaShift$2 = nextReplicaShift$2;
            }
        }));
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = this.getInverseMap(brokerRackMap).map((Function1<String, Seq<Object>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterator<Object>> apply(Tuple2<String, Seq<Object>> x0$1) {
                Tuple2<String, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String rack = tuple2._1();
                    Seq<Object> brokers = tuple2._2();
                    Tuple2<String, Iterator<Object>> tuple22 = new Tuple2<String, Iterator<Object>>(rack, brokers.toIterator());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), scala.collection.Map$.MODULE$.canBuildFrom());
        String[] racks = (String[])Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class))).sorted(Ordering$String$.MODULE$);
        ArrayBuffer<Object> result2 = new ArrayBuffer<Object>();
        int rackIndex = 0;
        while (result2.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply(racks[rackIndex]);
            Object object = rackIterator.hasNext() ? result2.$plus$eq(rackIterator.next()) : BoxedUnit.UNIT;
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result2;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return ((TraversableLike)brokerRackMap.toSeq().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    String rack = tuple2._2();
                    Tuple2<String, Object> tuple22 = new Tuple2<String, Object>(rack, BoxesRunTime.boxToInteger(id));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String rack;
                    String string2 = rack = tuple2._1();
                    return string2;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1<String, scala.collection.immutable.Map<?, ?>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Seq<Tuple2<String, Object>>> x0$4) {
                Tuple2<String, Seq<Tuple2<String, Object>>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String rack = tuple2._1();
                    Seq<Tuple2<String, Object>> rackAndIdList = tuple2._2();
                    Tuple2<String, Seq<Object>> tuple22 = new Tuple2<String, Seq<Object>>(rack, (Seq<Object>)((SeqLike)rackAndIdList.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<String, Object> x0$5) {
                            Tuple2<String, Object> tuple2 = x0$5;
                            if (tuple2 != null) {
                                int id;
                                int n = id = tuple2._2$mcI$sp();
                                return n;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sorted(Ordering$Int$.MODULE$));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public void addPartitions(ZkUtils zkUtils, String topic, int numPartitions, String replicaAssignmentStr, boolean checkBrokerAvailable, RackAwareMode rackAwareMode) {
        block6: {
            existingPartitionsReplicaList = zkUtils.getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
            if (existingPartitionsReplicaList.size() == 0) {
                throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("The topic %s does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
            }
            var9_8 = existingPartitionsReplicaList.find(new anonfun.4());
            v0 = None$.MODULE$;
            var10_9 = var9_8;
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                throw new AdminOperationException("the topic does not have partition with id 0, it should never happen");
            }
            if (!(var9_8 instanceof Some)) break block6;
            var12_10 = (Some)var9_8;
            headPartitionReplica = (Tuple2)var12_10.x();
            existingReplicaListForPartitionZero = var11_12 = (Seq)headPartitionReplica._2();
            partitionsToAdd = numPartitions - existingPartitionsReplicaList.size();
            if (partitionsToAdd <= 0) {
                throw new AdminOperationException("The number of partitions for a topic can only be increased");
            }
            brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
            if (replicaAssignmentStr == null) ** GOTO lbl-1000
            v1 = replicaAssignmentStr;
            var17_16 = "";
            if (!(v1 != null ? v1.equals(var17_16) == false : var17_16 != null)) lbl-1000:
            // 2 sources

            {
                startIndex = package$.MODULE$.max(0, brokerMetadatas.indexWhere((Function1<BrokerMetadata, Object>)new Serializable(existingReplicaListForPartitionZero){
                    public static final long serialVersionUID = 0L;
                    private final Seq existingReplicaListForPartitionZero$1;

                    public final boolean apply(BrokerMetadata x$4) {
                        return x$4.id() >= BoxesRunTime.unboxToInt(this.existingReplicaListForPartitionZero$1.head());
                    }
                    {
                        this.existingReplicaListForPartitionZero$1 = existingReplicaListForPartitionZero$1;
                    }
                }));
                v2 = this.assignReplicasToBrokers(brokerMetadatas, partitionsToAdd, existingReplicaListForPartitionZero.size(), startIndex, existingPartitionsReplicaList.size());
            } else {
                v2 = this.getManualReplicaAssignment(replicaAssignmentStr, ((TraversableOnce)brokerMetadatas.map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(BrokerMetadata x$5) {
                        return x$5.id();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet(), existingPartitionsReplicaList.size(), checkBrokerAvailable);
            }
            newPartitionReplicaList = v2;
            unmatchedRepFactorList = (Iterable)newPartitionReplicaList.values().filter(new Serializable(existingReplicaListForPartitionZero){
                public static final long serialVersionUID = 0L;
                private final Seq existingReplicaListForPartitionZero$1;

                public final boolean apply(Seq<Object> p) {
                    return p.size() != this.existingReplicaListForPartitionZero$1.size();
                }
                {
                    this.existingReplicaListForPartitionZero$1 = existingReplicaListForPartitionZero$1;
                }
            });
            if (unmatchedRepFactorList.size() != 0) {
                throw new AdminOperationException(new StringBuilder().append((Object)"The replication factor in manual replication assignment  is not equal to the existing replication factor for the topic ").append(BoxesRunTime.boxToInteger(existingReplicaListForPartitionZero.size())).toString());
            }
            this.info((Function0<String>)new Serializable(topic, newPartitionReplicaList){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final Map newPartitionReplicaList$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Add partition list for %s is %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, this.newPartitionReplicaList$1}));
                }
                {
                    this.topic$1 = topic$1;
                    this.newPartitionReplicaList$1 = newPartitionReplicaList$1;
                }
            });
            partitionReplicaList = existingPartitionsReplicaList.map((Function1<TopicAndPartition, Seq<Object>>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(p._1().partition())), p._2());
                }
            }, Map$.MODULE$.canBuildFrom());
            partitionReplicaList.$plus$plus$eq(newPartitionReplicaList);
            x$17 = zkUtils;
            x$18 = topic;
            x$19 = partitionReplicaList;
            x$20 = true;
            x$21 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
            this.createOrUpdateTopicPartitionAssignmentPathInZK(x$17, x$18, x$19, x$21, x$20);
            return;
        }
        throw new MatchError(var9_8);
    }

    public int addPartitions$default$3() {
        return 1;
    }

    public String addPartitions$default$4() {
        return "";
    }

    public boolean addPartitions$default$5() {
        return true;
    }

    public RackAwareMode addPartitions$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Map<Object, List<Object>> getManualReplicaAssignment(String replicaAssignmentList, Set<Object> availableBrokerList, int startPartitionId, boolean checkBrokerAvailable) {
        ObjectRef<String[]> partitionList = new ObjectRef<String[]>(replicaAssignmentList.split(","));
        HashMap ret = new HashMap();
        IntRef partitionId = new IntRef(startPartitionId);
        partitionList.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).takeRight(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).size() - partitionId.elem);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).size()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(availableBrokerList, startPartitionId, checkBrokerAvailable, partitionList, ret, partitionId){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerList$1;
            private final int startPartitionId$1;
            private final boolean checkBrokerAvailable$1;
            private final ObjectRef partitionList$1;
            private final HashMap ret$3;
            private final IntRef partitionId$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])((String[])this.partitionList$1.elem)[i].split(":")).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String s2) {
                        return new StringOps(Predef$.MODULE$.augmentString(s2.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                if (Predef$.MODULE$.intArrayOps(brokerList).size() <= 0) {
                    throw new AdminOperationException("replication factor must be larger than 0");
                }
                if (Predef$.MODULE$.intArrayOps(brokerList).size() != Predef$.MODULE$.intArrayOps(brokerList).toSet().size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"duplicate brokers in replica assignment: ").append(brokerList).toString());
                }
                if (this.checkBrokerAvailable$1 && !Predef$.MODULE$.intArrayOps(brokerList).toSet().subsetOf(this.availableBrokerList$1)) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"some specified brokers not available. specified brokers: ").append((Object)brokerList.toString()).append((Object)"available broker:").append((Object)this.availableBrokerList$1.toString()).toString());
                }
                this.ret$3.put(BoxesRunTime.boxToInteger(this.partitionId$1.elem), Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$3.apply(BoxesRunTime.boxToInteger(this.partitionId$1.elem))).size() != ((SeqLike)this.ret$3.apply(BoxesRunTime.boxToInteger(this.startPartitionId$1))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"partition ").append(BoxesRunTime.boxToInteger(i)).append((Object)" has different replication factor: ").append(brokerList).toString());
                }
                ++this.partitionId$1.elem;
            }
            {
                this.availableBrokerList$1 = availableBrokerList$1;
                this.startPartitionId$1 = startPartitionId$1;
                this.checkBrokerAvailable$1 = checkBrokerAvailable$1;
                this.partitionList$1 = partitionList$1;
                this.ret$3 = ret$3;
                this.partitionId$1 = partitionId$1;
            }
        }));
        return ret.toMap(Predef$.MODULE$.conforms());
    }

    public boolean getManualReplicaAssignment$default$4() {
        return true;
    }

    public void deleteTopic(ZkUtils zkUtils, String topic) {
        try {
            zkUtils.createPersistentPath(ZkUtils$.MODULE$.getDeleteTopicPath(topic), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    public boolean isConsumerGroupActive(ZkUtils zkUtils, String group) {
        return zkUtils.getConsumersInGroup(group).nonEmpty();
    }

    public boolean deleteConsumerGroupInZK(ZkUtils zkUtils, String group) {
        boolean bl;
        if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupDirs dir = new ZKGroupDirs(group);
            zkUtils.deletePathRecursive(dir.consumerGroupDir());
            bl = true;
        }
        return bl;
    }

    public boolean deleteConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String group, String topic) {
        boolean bl;
        Seq<String> topics;
        Seq<String> seq = topics = zkUtils.getTopicsByConsumerGroup(group);
        Object CC = Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        if (!(seq != null ? !seq.equals(CC) : CC != null)) {
            bl = this.deleteConsumerGroupInZK(zkUtils, group);
        } else if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
            zkUtils.deletePathRecursive(dir.consumerOwnerDir());
            zkUtils.deletePathRecursive(dir.consumerOffsetDir());
            bl = true;
        }
        return bl;
    }

    public void deleteAllConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String topic) {
        Set<String> groups = zkUtils.getAllConsumerGroupsForTopic(topic);
        groups.foreach(new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final String topic$3;

            public final boolean apply(String group) {
                return AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils$1, group, this.topic$3);
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.topic$3 = topic$3;
            }
        });
    }

    public boolean topicExists(ZkUtils zkUtils, String topic) {
        return zkUtils.zkClient().exists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(ZkUtils zkUtils, RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<BrokerMetadata> seq;
        Seq<Broker> allBrokers = zkUtils.getAllBrokersInCluster();
        Seq<Broker> brokers = brokerList.map(new Serializable(allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$1;

            public final Seq<Broker> apply(Seq<Object> brokerIds) {
                return (Seq)this.allBrokers$1.filter(new Serializable(this, brokerIds){
                    public static final long serialVersionUID = 0L;
                    private final Seq brokerIds$1;

                    public final boolean apply(Broker b) {
                        return this.brokerIds$1.contains(BoxesRunTime.boxToInteger(b.id()));
                    }
                    {
                        this.brokerIds$1 = brokerIds$1;
                    }
                });
            }
            {
                this.allBrokers$1 = allBrokers$1;
            }
        }).getOrElse(new Serializable(allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$1;

            public final Seq<Broker> apply() {
                return this.allBrokers$1;
            }
            {
                this.allBrokers$1 = allBrokers$1;
            }
        });
        Seq brokersWithRack = (Seq)brokers.filter((Function1<Broker, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Broker x$6) {
                return x$6.rack().nonEmpty();
            }
        }));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode2 != null ? !rackAwareMode2.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Disabled$ rackAwareMode$Disabled$ = RackAwareMode$Disabled$.MODULE$;
        RackAwareMode rackAwareMode4 = rackAwareMode3;
        if (!(rackAwareMode$Disabled$ != null ? !rackAwareMode$Disabled$.equals(rackAwareMode4) : rackAwareMode4 != null)) {
            seq = brokers.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BrokerMetadata apply(Broker broker) {
                    return new BrokerMetadata(broker.id(), None$.MODULE$);
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            RackAwareMode$Safe$ rackAwareMode$Safe$ = RackAwareMode$Safe$.MODULE$;
            RackAwareMode rackAwareMode5 = rackAwareMode3;
            seq = !(rackAwareMode$Safe$ != null ? !rackAwareMode$Safe$.equals(rackAwareMode5) : rackAwareMode5 != null) && brokersWithRack.size() < brokers.size() ? brokers.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BrokerMetadata apply(Broker broker) {
                    return new BrokerMetadata(broker.id(), None$.MODULE$);
                }
            }, Seq$.MODULE$.canBuildFrom()) : brokers.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BrokerMetadata apply(Broker broker) {
                    return new BrokerMetadata(broker.id(), broker.rack());
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        Seq<BrokerMetadata> brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$7) {
                return x$7.id();
            }
        }, Ordering$Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$2() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$3() {
        return None$.MODULE$;
    }

    public void createTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
        Map<Object, Seq<Object>> replicaAssignment = this.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public Properties createTopic$default$5() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update2) {
        Topic$.MODULE$.validate(topic);
        Predef$.MODULE$.require(((TraversableOnce)partitionReplicaAssignment.values().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() == 1, (Function0<Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "All partitions should have the same number of replicas.";
            }
        }));
        String topicPath = ZkUtils$.MODULE$.getTopicPath(topic);
        if (!update2) {
            Seq<String> allTopics;
            Seq collidingTopics;
            if (zkUtils.zkClient().exists(topicPath)) {
                throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" already exists.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
            }
            if (Topic$.MODULE$.hasCollisionChars(topic) && (collidingTopics = (Seq)(allTopics = zkUtils.getAllTopics()).filter((Function1<String, Object>)((Object)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$2;

                public final boolean apply(String t) {
                    return Topic$.MODULE$.hasCollision(this.topic$2, t);
                }
                {
                    this.topic$2 = topic$2;
                }
            }))).nonEmpty()) {
                throw new InvalidTopicException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" collides with existing topics: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, collidingTopics.mkString(", ")})));
            }
        }
        partitionReplicaAssignment.values().foreach(new Serializable(partitionReplicaAssignment){
            public static final long serialVersionUID = 0L;
            public final Map partitionReplicaAssignment$1;

            public final void apply(Seq<Object> reps) {
                Predef$.MODULE$.require(reps.size() == reps.toSet().size(), (Function0<Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createOrUpdateTopicPartitionAssignmentPathInZK.3 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Duplicate replica assignment found: ").append(this.$outer.partitionReplicaAssignment$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.partitionReplicaAssignment$1 = partitionReplicaAssignment$1;
            }
        });
        if (!update2) {
            LogConfig$.MODULE$.validate(config);
            this.writeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, config);
        }
        this.writeTopicPartitionAssignment(zkUtils, topic, partitionReplicaAssignment, update2);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    private void writeTopicPartitionAssignment(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update2) {
        try {
            String zkPath = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData = zkUtils.replicaAssignmentZkData(replicaAssignment.map((Function1<Object, Seq<Object>>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Seq<Object>> apply(Tuple2<Object, Seq<Object>> e) {
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(((Object)BoxesRunTime.boxToInteger(e._1$mcI$sp())).toString()), e._2());
                }
            }), scala.collection.Map$.MODULE$.canBuildFrom()));
            if (update2) {
                this.info((Function0<String>)((Object)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic update ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                }));
                zkUtils.updatePersistentPath(zkPath, jsonPartitionData, zkUtils.updatePersistentPath$default$3());
            } else {
                this.info((Function0<String>)((Object)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic creation ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                }));
                zkUtils.createPersistentPath(zkPath, jsonPartitionData, zkUtils.createPersistentPath$default$3());
            }
            this.debug((Function0<String>)((Object)new Serializable(zkPath, jsonPartitionData){
                public static final long serialVersionUID = 0L;
                private final String zkPath$1;
                private final String jsonPartitionData$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkPath$1, this.jsonPartitionData$1}));
                }
                {
                    this.zkPath$1 = zkPath$1;
                    this.jsonPartitionData$1 = jsonPartitionData$1;
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("topic %s already exists")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configs) {
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Client(), clientId, configs);
    }

    public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        if (this.topicExists(zkUtils, topic)) {
            LogConfig$.MODULE$.validate(configs);
            this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, configs);
            return;
        }
        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
    }

    private void changeEntityConfig(ZkUtils zkUtils, String entityType, String entityName, Properties configs) {
        this.writeEntityConfig(zkUtils, entityType, entityName, configs);
        String seqNode = new StringBuilder().append((Object)ZkUtils$.MODULE$.EntityConfigChangesPath()).append((Object)"/").append((Object)this.EntityConfigChangeZnodePrefix()).toString();
        String content = Json$.MODULE$.encode(this.getConfigChangeZnodeData(entityType, entityName));
        zkUtils.zkClient().createPersistentSequential(seqNode, content);
    }

    public Map<String, Object> getConfigChangeZnodeData(String entityType, String entityName) {
        return (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("entity_type"), entityType), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("entity_name"), entityName)}));
    }

    private void writeEntityConfig(ZkUtils zkUtils, String entityType, String entityName, Properties config) {
        scala.collection.mutable.Map<String, String> configMap = JavaConversions$.MODULE$.propertiesAsScalaMap(config);
        Map map2 = (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("config"), configMap)}));
        zkUtils.updatePersistentPath(ZkUtils$.MODULE$.getEntityConfigPath(entityType, entityName), Json$.MODULE$.encode(map2), zkUtils.updatePersistentPath$default$3());
    }

    /*
     * WARNING - void declaration
     */
    public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entity) {
        void var4_4;
        block4: {
            block5: {
                Properties props;
                block2: {
                    Some some;
                    Object config;
                    Some some2;
                    Object mapAnon;
                    Option<Object> option;
                    String str;
                    block3: {
                        str = (String)zkUtils.zkClient().readData(ZkUtils$.MODULE$.getEntityConfigPath(entityType, entity), true);
                        props = new Properties();
                        if (str == null) break block2;
                        option = Json$.MODULE$.parseFull(str);
                        None$ none$ = None$.MODULE$;
                        Option<Object> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block3;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block2;
                    }
                    if (!(option instanceof Some) || !((mapAnon = (some2 = (Some)option).x()) instanceof Map)) break block4;
                    Map map2 = (Map)mapAnon;
                    Map map3 = map2.collect(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            void var8_10;
                            A1 A1 = x2;
                            if (A1 != null) {
                                Object k = A1._1();
                                Object v = A1._2();
                                if (k instanceof String) {
                                    String string2 = (String)k;
                                    if (v instanceof Object) {
                                        Object object = v;
                                        Tuple2<String, Object> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(string2), object);
                                        return var8_10;
                                    }
                                }
                            }
                            B1 B1 = function1.apply(x2);
                            return var8_10;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Tuple2<Object, Object> x2) {
                            Tuple2<Object, Object> tuple2 = x2;
                            if (tuple2 == null) return false;
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            if (!(k instanceof String)) return false;
                            if (!(v instanceof Object)) return false;
                            return true;
                        }
                    }, scala.collection.Map$.MODULE$.canBuildFrom());
                    Predef$.MODULE$.require(BoxesRunTime.equals(map3.apply("version"), BoxesRunTime.boxToInteger(1)));
                    Option option3 = map3.get("config");
                    if (!(option3 instanceof Some) || !((config = (some = (Some)option3).x()) instanceof Map)) break block5;
                    Map map4 = (Map)config;
                    map4.foreach(new Serializable(entityType, str, props){
                        public static final long serialVersionUID = 0L;
                        private final String entityType$1;
                        private final String str$1;
                        private final Properties props$1;

                        public final Object apply(Tuple2<Object, Object> configTup) {
                            Tuple2<Object, Object> tuple2 = configTup;
                            if (tuple2 != null) {
                                Object k = tuple2._1();
                                Object v = tuple2._2();
                                if (k instanceof String) {
                                    String string2 = (String)k;
                                    if (v instanceof String) {
                                        String string3 = (String)v;
                                        Object object = this.props$1.setProperty(string2, string3);
                                        return object;
                                    }
                                }
                            }
                            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid ").append((Object)this.entityType$1).append((Object)" config: ").append((Object)this.str$1).toString());
                        }
                        {
                            this.entityType$1 = entityType$1;
                            this.str$1 = str$1;
                            this.props$1 = props$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                }
                return props;
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid ").append((Object)entityType).append((Object)" config: ").append(var4_4).toString());
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Unexpected value in config:(%s), entity_type: (%s), entity: (%s)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{var4_4, entityType, entity})));
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkUtils zkUtils) {
        return ((TraversableOnce)zkUtils.getAllTopics().map(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2<String, Properties>(topic, AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$2, ConfigType$.MODULE$.Topic(), topic));
            }
            {
                this.zkUtils$2 = zkUtils$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(ZkUtils zkUtils, String entityType) {
        return ((TraversableOnce)zkUtils.getAllEntitiesWithConfig(entityType).map(new Serializable(zkUtils, entityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$3;
            private final String entityType$2;

            public final Tuple2<String, Properties> apply(String entity) {
                return new Tuple2<String, Properties>(entity, AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$3, this.entityType$2, entity));
            }
            {
                this.zkUtils$3 = zkUtils$3;
                this.entityType$2 = entityType$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public MetadataResponse.TopicMetadata fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils) {
        return this.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, zkUtils, new HashMap<Object, Broker>(), this.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk$default$4());
    }

    public Set<MetadataResponse.TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkUtils zkUtils) {
        HashMap cachedBrokerInfo = new HashMap();
        return topics.map(new Serializable(zkUtils, cachedBrokerInfo){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final HashMap cachedBrokerInfo$2;

            public final MetadataResponse.TopicMetadata apply(String topic) {
                return AdminUtils$.MODULE$.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, this.zkUtils$5, this.cachedBrokerInfo$2, AdminUtils$.MODULE$.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk$default$4());
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.cachedBrokerInfo$2 = cachedBrokerInfo$2;
            }
        }, scala.collection.Set$.MODULE$.canBuildFrom());
    }

    public MetadataResponse.TopicMetadata kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils, HashMap<Object, Broker> cachedBrokerInfo, SecurityProtocol protocol) {
        MetadataResponse.TopicMetadata topicMetadata;
        if (zkUtils.pathExists(ZkUtils$.MODULE$.getTopicPath(topic))) {
            Map topicPartitionAssignment = (Map)zkUtils.getPartitionAssignmentForTopics((Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get(topic).get();
            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2<Tuple2<Object, Seq<Object>>, Tuple2<Object, Seq<Object>>, Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                }
            }));
            List partitionMetadata = sortedPartitions.map(new Serializable(topic, zkUtils, cachedBrokerInfo, protocol){
                public static final long serialVersionUID = 0L;
                public final String topic$4;
                private final ZkUtils zkUtils$4;
                private final HashMap cachedBrokerInfo$1;
                public final SecurityProtocol protocol$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final MetadataResponse.PartitionMetadata apply(Tuple2<Object, Seq<Object>> partitionMap) {
                    MetadataResponse.PartitionMetadata partitionMetadata;
                    int partition2 = partitionMap._1$mcI$sp();
                    Seq<Object> replicas = partitionMap._2();
                    Seq<Object> inSyncReplicas = this.zkUtils$4.getInSyncReplicasForPartition(this.topic$4, partition2);
                    Option<Object> leader = this.zkUtils$4.getLeaderForPartition(this.topic$4, partition2);
                    AdminUtils$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, replicas, inSyncReplicas, leader){
                        public static final long serialVersionUID = 0L;
                        private final Seq replicas$1;
                        private final Seq inSyncReplicas$1;
                        private final Option leader$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"replicas = ").append(this.replicas$1).append((Object)", in sync replicas = ").append(this.inSyncReplicas$1).append((Object)", leader = ").append(this.leader$1).toString();
                        }
                        {
                            this.replicas$1 = replicas$1;
                            this.inSyncReplicas$1 = inSyncReplicas$1;
                            this.leader$1 = leader$1;
                        }
                    }));
                    Node leaderInfo = Node.noNode();
                    ObjectRef<Nil$> replicaInfo = new ObjectRef<Nil$>(Nil$.MODULE$);
                    ObjectRef<Nil$> isrInfo = new ObjectRef<Nil$>(Nil$.MODULE$);
                    try {
                        Option<Object> option = leader;
                        if (option instanceof Some) {
                            Node node;
                            Some some = (Some)option;
                            int l = BoxesRunTime.unboxToInt(some.x());
                            leaderInfo = node = this.liftedTree1$1(partition2, l);
                            try {
                                replicaInfo.elem = AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$4, this.cachedBrokerInfo$1, replicas).map(new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.19 $outer;

                                    public final Node apply(Broker x$9) {
                                        return x$9.getNode(this.$outer.protocol$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                isrInfo.elem = AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$4, this.cachedBrokerInfo$1, inSyncReplicas).map(new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.19 $outer;

                                    public final Node apply(Broker x$10) {
                                        return x$10.getNode(this.$outer.protocol$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                            }
                            catch (Throwable throwable) {
                                throw new ReplicaNotAvailableException(throwable);
                            }
                            if (((Seq)replicaInfo.elem).size() < replicas.size()) {
                                throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"Replica information not available for following brokers: ").append((Object)((TraversableOnce)replicas.filterNot((Function1<Object, Object>)((Object)new Serializable(this, replicaInfo){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef replicaInfo$1;

                                    public final boolean apply(int x$12) {
                                        return this.apply$mcZI$sp(x$12);
                                    }

                                    public boolean apply$mcZI$sp(int x$12) {
                                        return ((SeqLike)((Seq)this.replicaInfo$1.elem).map(new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(Node x$11) {
                                                return x$11.id();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).contains(BoxesRunTime.boxToInteger(x$12));
                                    }
                                    {
                                        this.replicaInfo$1 = replicaInfo$1;
                                    }
                                }))).mkString(",")).toString());
                            }
                            if (((Seq)isrInfo.elem).size() < inSyncReplicas.size()) {
                                throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"In Sync Replica information not available for following brokers: ").append((Object)((TraversableOnce)inSyncReplicas.filterNot((Function1<Object, Object>)((Object)new Serializable(this, isrInfo){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef isrInfo$1;

                                    public final boolean apply(int x$14) {
                                        return this.apply$mcZI$sp(x$14);
                                    }

                                    public boolean apply$mcZI$sp(int x$14) {
                                        return ((SeqLike)((Seq)this.isrInfo$1.elem).map(new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(Node x$13) {
                                                return x$13.id();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).contains(BoxesRunTime.boxToInteger(x$14));
                                    }
                                    {
                                        this.isrInfo$1 = isrInfo$1;
                                    }
                                }))).mkString(",")).toString());
                            }
                            partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, partition2, leaderInfo, JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaInfo.elem).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)isrInfo.elem).asJava());
                            return partitionMetadata;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option2 = option;
                        if (none$ == null) {
                            if (option2 == null) throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader exists for partition ").append(BoxesRunTime.boxToInteger(partition2)).toString());
                            throw new MatchError(option);
                        }
                        if (!none$.equals(option2)) throw new MatchError(option);
                        throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader exists for partition ").append(BoxesRunTime.boxToInteger(partition2)).toString());
                    }
                    catch (Throwable throwable) {
                        AdminUtils$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, partition2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.19 $outer;
                            private final int partition$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Error while fetching metadata for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$4, BoxesRunTime.boxToInteger(this.partition$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.partition$1 = partition$1;
                            }
                        }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$1;

                            public final Throwable apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = e$1;
                            }
                        }));
                        partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.forException(throwable), partition2, leaderInfo, JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaInfo.elem).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)isrInfo.elem).asJava());
                    }
                    return partitionMetadata;
                }

                private final Node liftedTree1$1(int partition$1, int l$1) {
                    try {
                        return ((Broker)AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$4, this.cachedBrokerInfo$1, (Seq<Object>)List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{l$1}))).head()).getNode(this.protocol$1);
                    }
                    catch (Throwable throwable) {
                        throw new LeaderNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Leader not available for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4, BoxesRunTime.boxToInteger(partition$1)})), throwable);
                    }
                }
                {
                    this.topic$4 = topic$4;
                    this.zkUtils$4 = zkUtils$4;
                    this.cachedBrokerInfo$1 = cachedBrokerInfo$1;
                    this.protocol$1 = protocol$1;
                }
            }, List$.MODULE$.canBuildFrom());
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic$.MODULE$.isInternal(topic), JavaConverters$.MODULE$.seqAsJavaListConverter(partitionMetadata).asJava());
        } else {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, Topic$.MODULE$.isInternal(topic), Collections.<MetadataResponse.PartitionMetadata>emptyList());
        }
        return topicMetadata;
    }

    public SecurityProtocol kafka$admin$AdminUtils$$fetchTopicMetadataFromZk$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Broker> kafka$admin$AdminUtils$$getBrokerInfoFromCache(ZkUtils zkUtils, scala.collection.mutable.Map<Object, Broker> cachedBrokerInfo, Seq<Object> brokerIds) {
        ObjectRef failedBrokerIds = new ObjectRef(new ListBuffer());
        Seq<Option<Broker>> brokerMetadata = brokerIds.map(new Serializable(zkUtils, cachedBrokerInfo, failedBrokerIds){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$6;
            private final scala.collection.mutable.Map cachedBrokerInfo$3;
            private final ObjectRef failedBrokerIds$1;

            public final Option<Broker> apply(int id) {
                Option<B> option;
                block4: {
                    Option<Broker> option2;
                    block7: {
                        Option option3;
                        block3: {
                            Option option4;
                            block6: {
                                block5: {
                                    block2: {
                                        Option<B> optionalBrokerInfo = this.cachedBrokerInfo$3.get(BoxesRunTime.boxToInteger(id));
                                        option = optionalBrokerInfo;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        Broker brokerInfo = (Broker)some.x();
                                        option3 = new Some<Broker>(brokerInfo);
                                        break block3;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<B> option5 = option;
                                    if (none$ != null ? !none$.equals(option5) : option5 != null) break block4;
                                    option2 = this.zkUtils$6.getBrokerInfo(id);
                                    if (!(option2 instanceof Some)) break block5;
                                    Some some = (Some)option2;
                                    Broker brokerInfo = (Broker)some.x();
                                    this.cachedBrokerInfo$3.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(id)), brokerInfo));
                                    option4 = new Some<Broker>(brokerInfo);
                                    break block6;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<Broker> option6 = option2;
                                if (none$ != null ? !none$.equals(option6) : option6 != null) break block7;
                                ((ListBuffer)this.failedBrokerIds$1.elem).$plus$eq(BoxesRunTime.boxToInteger(id));
                                option4 = None$.MODULE$;
                            }
                            option3 = option4;
                        }
                        return option3;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError(option);
            }
            {
                this.zkUtils$6 = zkUtils$6;
                this.cachedBrokerInfo$3 = cachedBrokerInfo$3;
                this.failedBrokerIds$1 = failedBrokerIds$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return ((TraversableLike)brokerMetadata.filter((Function1<Option<Broker>, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Broker> x$15) {
                return x$15.isDefined();
            }
        }))).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Option<Broker> x$16) {
                return x$16.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int kafka$admin$AdminUtils$$replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
        this.EntityConfigChangeZnodePrefix = "config_change_";
    }
}

