/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Shell {
    Logger LOG = Logger.getLogger(Shell.class);
    public static final String USER_NAME_COMMAND = "whoami";
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String SET_OWNER_COMMAND = "chown";
    public static final String SET_GROUP_COMMAND = "chgrp";
    protected long timeOutInterval = 0L;
    private AtomicBoolean timedOut;
    public static final String ULIMIT_COMMAND = "ulimit";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private long interval;
    private long lastTime;
    private Map<String, String> environment;
    private File dir;
    private Process process;
    private int exitCode;
    private volatile AtomicBoolean completed;

    public static String[] getGroupsCommand() {
        return new String[]{"bash", "-c", "groups"};
    }

    public static String[] getGroupsForUserCommand(String user) {
        return new String[]{"bash", "-c", "id -Gn " + user};
    }

    public static String[] getGET_PERMISSION_COMMAND() {
        return new String[]{WINDOWS ? "ls" : "/bin/ls", "-ld"};
    }

    public static String[] getUlimitMemoryCommand(int memoryLimit) {
        if (WINDOWS) {
            return null;
        }
        return new String[]{ULIMIT_COMMAND, "-v", String.valueOf(memoryLimit)};
    }

    public Shell() {
        this(0L);
    }

    public Shell(long interval) {
        this.interval = interval;
        this.lastTime = interval < 0L ? 0L : -interval;
    }

    protected void setEnvironment(Map<String, String> env) {
        this.environment = env;
    }

    protected void setWorkingDirectory(File dir) {
        this.dir = dir;
    }

    protected void run() throws IOException {
        if (this.lastTime + this.interval > System.currentTimeMillis()) {
            return;
        }
        this.exitCode = 0;
        this.runCommand();
    }

    /*
     * Loose catch block
     */
    private void runCommand() throws IOException {
        block24: {
            Thread errThread;
            BufferedReader inReader;
            BufferedReader errReader;
            Timer timeOutTimer;
            block22: {
                ProcessBuilder builder = new ProcessBuilder(this.getExecString());
                timeOutTimer = null;
                ShellTimeoutTimerTask timeoutTimerTask = null;
                this.timedOut = new AtomicBoolean(false);
                this.completed = new AtomicBoolean(false);
                if (this.environment != null) {
                    builder.environment().putAll(this.environment);
                }
                if (this.dir != null) {
                    builder.directory(this.dir);
                }
                this.process = builder.start();
                if (this.timeOutInterval > 0L) {
                    timeOutTimer = new Timer();
                    timeoutTimerTask = new ShellTimeoutTimerTask(this);
                    timeOutTimer.schedule((TimerTask)timeoutTimerTask, this.timeOutInterval);
                }
                errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                inReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                final StringBuffer errMsg = new StringBuffer();
                errThread = new Thread(){

                    public void run() {
                        try {
                            String line = errReader.readLine();
                            while (line != null && !this.isInterrupted()) {
                                errMsg.append(line);
                                errMsg.append(System.getProperty("line.separator"));
                                line = errReader.readLine();
                            }
                        }
                        catch (IOException ioe) {
                            Shell.this.LOG.warn((Object)"Error reading the error stream", (Throwable)ioe);
                        }
                    }
                };
                try {
                    errThread.start();
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
                this.parseExecResult(inReader);
                String line = inReader.readLine();
                while (line != null) {
                    line = inReader.readLine();
                }
                this.exitCode = this.process.waitFor();
                try {
                    errThread.join();
                }
                catch (InterruptedException ie) {
                    this.LOG.warn((Object)"Interrupted while reading the error stream", (Throwable)ie);
                }
                this.completed.set(true);
                if (this.exitCode != 0) {
                    throw new ExitCodeException(this.exitCode, errMsg.toString());
                }
                Object var11_12 = null;
                if (timeOutTimer == null || this.timedOut.get()) break block22;
                timeOutTimer.cancel();
            }
            try {
                inReader.close();
            }
            catch (IOException ioe) {
                this.LOG.warn((Object)"Error while closing the input stream", (Throwable)ioe);
            }
            if (!this.completed.get()) {
                errThread.interrupt();
            }
            try {
                errReader.close();
                break block24;
            }
            catch (IOException ioe) {
                this.LOG.warn((Object)"Error while closing the error stream", (Throwable)ioe);
            }
            {
                break block24;
                catch (InterruptedException ie) {
                    throw new IOException(ie.toString());
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (timeOutTimer != null && !this.timedOut.get()) {
                    timeOutTimer.cancel();
                }
                try {
                    inReader.close();
                }
                catch (IOException ioe) {
                    this.LOG.warn((Object)"Error while closing the input stream", (Throwable)ioe);
                }
                if (!this.completed.get()) {
                    errThread.interrupt();
                }
                try {
                    errReader.close();
                }
                catch (IOException ioe) {
                    this.LOG.warn((Object)"Error while closing the error stream", (Throwable)ioe);
                }
                this.process.destroy();
                this.lastTime = System.currentTimeMillis();
                throw throwable;
            }
        }
        this.process.destroy();
        this.lastTime = System.currentTimeMillis();
    }

    protected abstract String[] getExecString();

    protected abstract void parseExecResult(BufferedReader var1) throws IOException;

    public Process getProcess() {
        return this.process;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isTimedOut() {
        return this.timedOut.get();
    }

    private void setTimedOut() {
        this.timedOut.set(true);
    }

    public static String execCommand(String ... cmd) throws IOException {
        return Shell.execCommand(null, cmd, 0L);
    }

    public static String execCommand(Map<String, String> env, String[] cmd, long timeout) throws IOException {
        ShellCommandExecutor exec = new ShellCommandExecutor(cmd, null, env, timeout);
        exec.execute();
        return exec.getOutput();
    }

    public static String execCommand(Map<String, String> env, String ... cmd) throws IOException {
        return Shell.execCommand(env, cmd, 0L);
    }

    private static class ShellTimeoutTimerTask
    extends TimerTask {
        private Shell shell;

        public ShellTimeoutTimerTask(Shell shell) {
            this.shell = shell;
        }

        public void run() {
            block2: {
                Process p = this.shell.getProcess();
                try {
                    p.exitValue();
                }
                catch (Exception e) {
                    if (p == null || this.shell.completed.get()) break block2;
                    this.shell.setTimedOut();
                    p.destroy();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShellCommandExecutor
    extends Shell {
        private String[] command;
        private StringBuffer output;

        public ShellCommandExecutor(String[] execString) {
            this(execString, null);
        }

        public ShellCommandExecutor(String[] execString, File dir) {
            this(execString, dir, null);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env) {
            this(execString, dir, env, 0L);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env, long timeout) {
            this.command = (String[])execString.clone();
            if (dir != null) {
                this.setWorkingDirectory(dir);
            }
            if (env != null) {
                this.setEnvironment(env);
            }
            this.timeOutInterval = timeout;
        }

        public void execute() throws IOException {
            this.run();
        }

        @Override
        protected String[] getExecString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader lines2) throws IOException {
            int nRead;
            this.output = new StringBuffer();
            char[] buf = new char[512];
            while ((nRead = lines2.read(buf, 0, buf.length)) > 0) {
                this.output.append(buf, 0, nRead);
            }
        }

        public String getOutput() {
            return this.output == null ? "" : this.output.toString();
        }

        public String toString() {
            String[] args;
            StringBuilder builder = new StringBuilder();
            for (String s2 : args = this.getExecString()) {
                if (s2.indexOf(32) >= 0) {
                    builder.append('\"').append(s2).append('\"');
                } else {
                    builder.append(s2);
                }
                builder.append(' ');
            }
            return builder.toString();
        }
    }

    public static class ExitCodeException
    extends IOException {
        int exitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

