/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class LongDeserializer
implements Deserializer<Long> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Long deserialize(String topic, byte[] data2) {
        if (data2 == null) {
            return null;
        }
        if (data2.length != 8) {
            throw new SerializationException("Size of data received by LongDeserializer is not 8");
        }
        long value2 = 0L;
        for (byte b : data2) {
            value2 <<= 8;
            value2 |= (long)(b & 0xFF);
        }
        return value2;
    }

    @Override
    public void close() {
    }
}

