/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetFetchResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.OFFSET_FETCH.id);
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String COMMIT_OFFSET_KEY_NAME = "offset";
    private static final String METADATA_KEY_NAME = "metadata";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final long INVALID_OFFSET = -1L;
    public static final String NO_METADATA = "";
    private final Map<TopicPartition, PartitionData> responseData;

    public OffsetFetchResponse(Map<TopicPartition, PartitionData> responseData) {
        super(new Struct(CURRENT_SCHEMA));
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> entries : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : entries.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(COMMIT_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                partitionData.set(METADATA_KEY_NAME, (Object)fetchPartitionData.metadata);
                partitionData.set(ERROR_CODE_KEY_NAME, (Object)fetchPartitionData.errorCode);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        this.responseData = responseData;
    }

    public OffsetFetchResponse(Struct struct) {
        super(struct);
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.getInt(PARTITION_KEY_NAME);
                long offset = partitionResponse.getLong(COMMIT_OFFSET_KEY_NAME);
                String metadata = partitionResponse.getString(METADATA_KEY_NAME);
                short errorCode = partitionResponse.getShort(ERROR_CODE_KEY_NAME);
                PartitionData partitionData = new PartitionData(offset, metadata, errorCode);
                this.responseData.put(new TopicPartition(topic, partition2), partitionData);
            }
        }
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public static OffsetFetchResponse parse(ByteBuffer buffer) {
        return new OffsetFetchResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }

    public static final class PartitionData {
        public final long offset;
        public final String metadata;
        public final short errorCode;

        public PartitionData(long offset, String metadata, short errorCode) {
            this.offset = offset;
            this.metadata = metadata;
            this.errorCode = errorCode;
        }

        public boolean hasError() {
            return this.errorCode != Errors.NONE.code();
        }
    }
}

