/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.io.Serializable;

public class OffsetAndMetadata
implements Serializable {
    private final long offset;
    private final String metadata;

    public OffsetAndMetadata(long offset, String metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata cannot be null");
        }
        this.offset = offset;
        this.metadata = metadata;
    }

    public OffsetAndMetadata(long offset) {
        this(offset, "");
    }

    public long offset() {
        return this.offset;
    }

    public String metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetAndMetadata that = (OffsetAndMetadata)o;
        if (this.offset != that.offset) {
            return false;
        }
        return this.metadata == null ? that.metadata == null : this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result2 = (int)(this.offset ^ this.offset >>> 32);
        result2 = 31 * result2 + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "OffsetAndMetadata{offset=" + this.offset + ", metadata='" + this.metadata + '\'' + '}';
    }
}

