/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Metadata {
    private static final Logger log = LoggerFactory.getLogger(Metadata.class);
    private final long refreshBackoffMs;
    private final long metadataExpireMs;
    private int version;
    private long lastRefreshMs;
    private long lastSuccessfulRefreshMs;
    private Cluster cluster;
    private boolean needUpdate;
    private final Set<String> topics;
    private final List<Listener> listeners;
    private boolean needMetadataForAllTopics;

    public Metadata() {
        this(100L, 3600000L);
    }

    public Metadata(long refreshBackoffMs, long metadataExpireMs) {
        this.refreshBackoffMs = refreshBackoffMs;
        this.metadataExpireMs = metadataExpireMs;
        this.lastRefreshMs = 0L;
        this.lastSuccessfulRefreshMs = 0L;
        this.version = 0;
        this.cluster = Cluster.empty();
        this.needUpdate = false;
        this.topics = new HashSet<String>();
        this.listeners = new ArrayList<Listener>();
        this.needMetadataForAllTopics = false;
    }

    public synchronized Cluster fetch() {
        return this.cluster;
    }

    public synchronized void add(String topic) {
        this.topics.add(topic);
    }

    public synchronized long timeToNextUpdate(long nowMs) {
        long timeToExpire = this.needUpdate ? 0L : Math.max(this.lastSuccessfulRefreshMs + this.metadataExpireMs - nowMs, 0L);
        long timeToAllowUpdate = this.lastRefreshMs + this.refreshBackoffMs - nowMs;
        return Math.max(timeToExpire, timeToAllowUpdate);
    }

    public synchronized int requestUpdate() {
        this.needUpdate = true;
        return this.version;
    }

    public synchronized void awaitUpdate(int lastVersion, long maxWaitMs) throws InterruptedException {
        if (maxWaitMs < 0L) {
            throw new IllegalArgumentException("Max time to wait for metadata updates should not be < 0 milli seconds");
        }
        long begin = System.currentTimeMillis();
        long remainingWaitMs = maxWaitMs;
        while (this.version <= lastVersion) {
            long elapsed;
            if (remainingWaitMs != 0L) {
                this.wait(remainingWaitMs);
            }
            if ((elapsed = System.currentTimeMillis() - begin) >= maxWaitMs) {
                throw new TimeoutException("Failed to update metadata after " + maxWaitMs + " ms.");
            }
            remainingWaitMs = maxWaitMs - elapsed;
        }
    }

    public synchronized void setTopics(Collection<String> topics) {
        if (!this.topics.containsAll(topics)) {
            this.requestUpdate();
        }
        this.topics.clear();
        this.topics.addAll(topics);
    }

    public synchronized Set<String> topics() {
        return new HashSet<String>(this.topics);
    }

    public synchronized boolean containsTopic(String topic) {
        return this.topics.contains(topic);
    }

    public synchronized void update(Cluster cluster, long now) {
        this.needUpdate = false;
        this.lastRefreshMs = now;
        this.lastSuccessfulRefreshMs = now;
        ++this.version;
        for (Listener listener : this.listeners) {
            listener.onMetadataUpdate(cluster);
        }
        this.cluster = this.needMetadataForAllTopics ? this.getClusterForCurrentTopics(cluster) : cluster;
        this.notifyAll();
        log.debug("Updated cluster metadata version {} to {}", this.version, (Object)this.cluster);
    }

    public synchronized void failedUpdate(long now) {
        this.lastRefreshMs = now;
    }

    public synchronized int version() {
        return this.version;
    }

    public synchronized long lastSuccessfulUpdate() {
        return this.lastSuccessfulRefreshMs;
    }

    public long refreshBackoff() {
        return this.refreshBackoffMs;
    }

    public synchronized void needMetadataForAllTopics(boolean needMetadaForAllTopics) {
        this.needMetadataForAllTopics = needMetadaForAllTopics;
    }

    public synchronized boolean needMetadataForAllTopics() {
        return this.needMetadataForAllTopics;
    }

    public synchronized void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private Cluster getClusterForCurrentTopics(Cluster cluster) {
        HashSet<String> unauthorizedTopics = new HashSet<String>();
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        List<Node> nodes = Collections.emptyList();
        if (cluster != null) {
            unauthorizedTopics.addAll(cluster.unauthorizedTopics());
            unauthorizedTopics.retainAll(this.topics);
            for (String topic : this.topics) {
                partitionInfos.addAll(cluster.partitionsForTopic(topic));
            }
            nodes = cluster.nodes();
        }
        return new Cluster(nodes, partitionInfos, unauthorizedTopics);
    }

    public static interface Listener {
        public void onMetadataUpdate(Cluster var1);
    }
}

