/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.ExceptionUtil;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.ZkEventThread;
import org.I0Itec.zkclient.ZkLock;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.exception.ZkTimeoutException;
import org.I0Itec.zkclient.serialize.SerializableSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.I0Itec.zkclient.util.ZkPathUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZkClient
implements Watcher {
    private static final Logger LOG = Logger.getLogger(ZkClient.class);
    protected static final String JAVA_LOGIN_CONFIG_PARAM = "java.security.auth.login.config";
    protected static final String ZK_SASL_CLIENT = "zookeeper.sasl.client";
    protected static final String ZK_LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    protected final IZkConnection _connection;
    protected final long operationRetryTimeoutInMillis;
    private final Map<String, Set<IZkChildListener>> _childListener = new ConcurrentHashMap<String, Set<IZkChildListener>>();
    private final ConcurrentHashMap<String, Set<IZkDataListener>> _dataListener = new ConcurrentHashMap();
    private final Set<IZkStateListener> _stateListener = new CopyOnWriteArraySet<IZkStateListener>();
    private Watcher.Event.KeeperState _currentState;
    private final ZkLock _zkEventLock = new ZkLock();
    private boolean _shutdownTriggered;
    private ZkEventThread _eventThread;
    private Thread _zookeeperEventThread;
    private ZkSerializer _zkSerializer;
    private volatile boolean _closed;
    private boolean _isZkSaslEnabled;

    public ZkClient(String serverstring) {
        this(serverstring, Integer.MAX_VALUE);
    }

    public ZkClient(String zkServers, int connectionTimeout) {
        this(new ZkConnection(zkServers), connectionTimeout);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout) {
        this(new ZkConnection(zkServers, sessionTimeout), connectionTimeout);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, ZkSerializer zkSerializer) {
        this(new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, ZkSerializer zkSerializer, long operationRetryTimeout) {
        this(new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer, operationRetryTimeout);
    }

    public ZkClient(IZkConnection connection) {
        this(connection, Integer.MAX_VALUE);
    }

    public ZkClient(IZkConnection connection, int connectionTimeout) {
        this(connection, connectionTimeout, new SerializableSerializer());
    }

    public ZkClient(IZkConnection zkConnection, int connectionTimeout, ZkSerializer zkSerializer) {
        this(zkConnection, connectionTimeout, zkSerializer, -1L);
    }

    public ZkClient(IZkConnection zkConnection, int connectionTimeout, ZkSerializer zkSerializer, long operationRetryTimeout) {
        if (zkConnection == null) {
            throw new NullPointerException("Zookeeper connection is null!");
        }
        this._connection = zkConnection;
        this._zkSerializer = zkSerializer;
        this.operationRetryTimeoutInMillis = operationRetryTimeout;
        this._isZkSaslEnabled = this.isZkSaslEnabled();
        this.connect(connectionTimeout, this);
    }

    public void setZkSerializer(ZkSerializer zkSerializer) {
        this._zkSerializer = zkSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        Map<String, Set<IZkChildListener>> map2 = this._childListener;
        synchronized (map2) {
            Set<IZkChildListener> listeners = this._childListener.get(path);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<IZkChildListener>();
                this._childListener.put(path, listeners);
            }
            listeners.add(listener);
        }
        return this.watchForChilds(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeChildChanges(String path, IZkChildListener childListener) {
        Map<String, Set<IZkChildListener>> map2 = this._childListener;
        synchronized (map2) {
            Set<IZkChildListener> listeners = this._childListener.get(path);
            if (listeners != null) {
                listeners.remove(childListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeDataChanges(String path, IZkDataListener listener) {
        ConcurrentHashMap<String, Set<IZkDataListener>> concurrentHashMap = this._dataListener;
        synchronized (concurrentHashMap) {
            Set<IZkDataListener> listeners = this._dataListener.get(path);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<IZkDataListener>();
                this._dataListener.put(path, listeners);
            }
            listeners.add(listener);
        }
        this.watchForData(path);
        LOG.debug((Object)("Subscribed data changes for " + path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeDataChanges(String path, IZkDataListener dataListener) {
        ConcurrentHashMap<String, Set<IZkDataListener>> concurrentHashMap = this._dataListener;
        synchronized (concurrentHashMap) {
            Set<IZkDataListener> listeners = this._dataListener.get(path);
            if (listeners != null) {
                listeners.remove(dataListener);
            }
            if (listeners == null || listeners.isEmpty()) {
                this._dataListener.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeStateChanges(IZkStateListener listener) {
        Set<IZkStateListener> set = this._stateListener;
        synchronized (set) {
            this._stateListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeStateChanges(IZkStateListener stateListener) {
        Set<IZkStateListener> set = this._stateListener;
        synchronized (set) {
            this._stateListener.remove(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll() {
        Object object = this._childListener;
        synchronized (object) {
            this._childListener.clear();
        }
        object = this._dataListener;
        synchronized (object) {
            this._dataListener.clear();
        }
        object = this._stateListener;
        synchronized (object) {
            this._stateListener.clear();
        }
    }

    public void createPersistent(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, false);
    }

    public void createPersistent(String path, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    public void createPersistent(String path, boolean createParents, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            this.create(path, null, acl, CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException e) {
            if (!createParents) {
                throw e;
            }
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistent(parentDir, createParents, acl);
            this.createPersistent(path, createParents, acl);
        }
    }

    public void setAcl(final String path, final List<ACL> acl) throws ZkException {
        if (path == null) {
            throw new NullPointerException("Missing value for path");
        }
        if (acl == null || acl.size() == 0) {
            throw new NullPointerException("Missing value for ACL");
        }
        if (!this.exists(path)) {
            throw new RuntimeException("trying to set acls on non existing node " + path);
        }
        this.retryUntilConnected(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Stat stat = new Stat();
                ZkClient.this._connection.readData(path, stat, false);
                ZkClient.this._connection.setAcl(path, acl, stat.getAversion());
                return null;
            }
        });
    }

    public Map.Entry<List<ACL>, Stat> getAcl(final String path) throws ZkException {
        if (path == null) {
            throw new NullPointerException("Missing value for path");
        }
        if (!this.exists(path)) {
            throw new RuntimeException("trying to get acls on non existing node " + path);
        }
        return this.retryUntilConnected(new Callable<Map.Entry<List<ACL>, Stat>>(){

            @Override
            public Map.Entry<List<ACL>, Stat> call() throws Exception {
                return ZkClient.this._connection.getAcl(path);
            }
        });
    }

    public void createPersistent(String path, Object data2) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data2, CreateMode.PERSISTENT);
    }

    public void createPersistent(String path, Object data2, List<ACL> acl) {
        this.create(path, data2, acl, CreateMode.PERSISTENT);
    }

    public String createPersistentSequential(String path, Object data2) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data2, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public String createPersistentSequential(String path, Object data2, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data2, acl, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public void createEphemeral(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, acl, CreateMode.EPHEMERAL);
    }

    public String create(String path, Object data2, CreateMode mode) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data2, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public String create(final String path, Object data2, final List<ACL> acl, final CreateMode mode) {
        if (path == null) {
            throw new NullPointerException("Missing value for path");
        }
        if (acl == null || acl.size() == 0) {
            throw new NullPointerException("Missing value for ACL");
        }
        final byte[] bytes = data2 == null ? null : this.serialize(data2);
        return this.retryUntilConnected(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ZkClient.this._connection.create(path, bytes, acl, mode);
            }
        });
    }

    public void createEphemeral(String path, Object data2) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data2, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, Object data2, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data2, acl, CreateMode.EPHEMERAL);
    }

    public String createEphemeralSequential(String path, Object data2) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data2, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public String createEphemeralSequential(String path, Object data2, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data2, acl, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent event) {
        LOG.debug((Object)("Received event: " + event));
        this._zookeeperEventThread = Thread.currentThread();
        boolean stateChanged = event.getPath() == null;
        boolean znodeChanged = event.getPath() != null;
        boolean dataChanged = event.getType() == Watcher.Event.EventType.NodeDataChanged || event.getType() == Watcher.Event.EventType.NodeDeleted || event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeChildrenChanged;
        this.getEventLock().lock();
        try {
            if (this.getShutdownTrigger()) {
                LOG.debug((Object)("ignoring event '{" + (Object)((Object)event.getType()) + " | " + event.getPath() + "}' since shutdown triggered"));
                return;
            }
            if (stateChanged) {
                this.processStateChanged(event);
            }
            if (dataChanged) {
                this.processDataOrChildChange(event);
            }
        }
        finally {
            if (stateChanged) {
                this.getEventLock().getStateChangedCondition().signalAll();
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    this.getEventLock().getZNodeEventCondition().signalAll();
                    this.getEventLock().getDataChangedCondition().signalAll();
                    this.fireAllEvents();
                }
            }
            if (znodeChanged) {
                this.getEventLock().getZNodeEventCondition().signalAll();
            }
            if (dataChanged) {
                this.getEventLock().getDataChangedCondition().signalAll();
            }
            this.getEventLock().unlock();
            LOG.debug((Object)"Leaving process event");
        }
    }

    private void fireAllEvents() {
        for (Map.Entry<String, Set<IZkChildListener>> entry2 : this._childListener.entrySet()) {
            this.fireChildChangedEvents(entry2.getKey(), entry2.getValue());
        }
        for (Map.Entry<String, Set<Object>> entry3 : this._dataListener.entrySet()) {
            this.fireDataChangedEvents(entry3.getKey(), entry3.getValue());
        }
    }

    public List<String> getChildren(String path) {
        return this.getChildren(path, this.hasListeners(path));
    }

    protected List<String> getChildren(final String path, final boolean watch) {
        return this.retryUntilConnected(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ZkClient.this._connection.getChildren(path, watch);
            }
        });
    }

    public int countChildren(String path) {
        try {
            return this.getChildren(path).size();
        }
        catch (ZkNoNodeException e) {
            return 0;
        }
    }

    protected boolean exists(final String path, final boolean watch) {
        return this.retryUntilConnected(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ZkClient.this._connection.exists(path, watch);
            }
        });
    }

    public boolean exists(String path) {
        return this.exists(path, this.hasListeners(path));
    }

    private void processStateChanged(WatchedEvent event) {
        LOG.info((Object)("zookeeper state changed (" + (Object)((Object)event.getState()) + ")"));
        this.setCurrentState(event.getState());
        if (this.getShutdownTrigger()) {
            return;
        }
        this.fireStateChangedEvent(event.getState());
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            try {
                this.reconnect();
                this.fireNewSessionEvents();
            }
            catch (Exception e) {
                LOG.info((Object)"Unable to re-establish connection. Notifying consumer of the following exception: ", (Throwable)e);
                this.fireSessionEstablishmentError(e);
            }
        }
    }

    private void fireNewSessionEvents() {
        for (final IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("New session event sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleNewSession();
                }
            });
        }
    }

    private void fireStateChangedEvent(final Watcher.Event.KeeperState state) {
        for (final IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("State changed to " + (Object)((Object)state) + " sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleStateChanged(state);
                }
            });
        }
    }

    private void fireSessionEstablishmentError(final Throwable error) {
        for (final IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("Session establishment error(" + error + ") sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleSessionEstablishmentError(error);
                }
            });
        }
    }

    private boolean hasListeners(String path) {
        Set<IZkDataListener> dataListeners = this._dataListener.get(path);
        if (dataListeners != null && dataListeners.size() > 0) {
            return true;
        }
        Set<IZkChildListener> childListeners = this._childListener.get(path);
        return childListeners != null && childListeners.size() > 0;
    }

    public boolean deleteRecursive(String path) {
        List<String> children;
        try {
            children = this.getChildren(path, false);
        }
        catch (ZkNoNodeException e) {
            return true;
        }
        for (String subPath : children) {
            if (this.deleteRecursive(path + "/" + subPath)) continue;
            return false;
        }
        return this.delete(path);
    }

    private void processDataOrChildChange(WatchedEvent event) {
        Set<IZkDataListener> listeners;
        Set<IZkChildListener> childListeners;
        String path = event.getPath();
        if (!(event.getType() != Watcher.Event.EventType.NodeChildrenChanged && event.getType() != Watcher.Event.EventType.NodeCreated && event.getType() != Watcher.Event.EventType.NodeDeleted || (childListeners = this._childListener.get(path)) == null || childListeners.isEmpty())) {
            this.fireChildChangedEvents(path, childListeners);
        }
        if (!(event.getType() != Watcher.Event.EventType.NodeDataChanged && event.getType() != Watcher.Event.EventType.NodeDeleted && event.getType() != Watcher.Event.EventType.NodeCreated || (listeners = this._dataListener.get(path)) == null || listeners.isEmpty())) {
            this.fireDataChangedEvents(event.getPath(), listeners);
        }
    }

    private void fireDataChangedEvents(final String path, Set<IZkDataListener> listeners) {
        for (final IZkDataListener listener : listeners) {
            this._eventThread.send(new ZkEventThread.ZkEvent("Data of " + path + " changed sent to " + listener){

                @Override
                public void run() throws Exception {
                    ZkClient.this.exists(path, true);
                    try {
                        Object data2 = ZkClient.this.readData(path, null, true);
                        listener.handleDataChange(path, data2);
                    }
                    catch (ZkNoNodeException e) {
                        listener.handleDataDeleted(path);
                    }
                }
            });
        }
    }

    private void fireChildChangedEvents(final String path, Set<IZkChildListener> childListeners) {
        try {
            for (final IZkChildListener listener : childListeners) {
                this._eventThread.send(new ZkEventThread.ZkEvent("Children of " + path + " changed sent to " + listener){

                    @Override
                    public void run() throws Exception {
                        try {
                            ZkClient.this.exists(path);
                            List<String> children = ZkClient.this.getChildren(path);
                            listener.handleChildChange(path, children);
                        }
                        catch (ZkNoNodeException e) {
                            listener.handleChildChange(path, null);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to fire child changed event. Unable to getChildren.  ", (Throwable)e);
        }
    }

    public boolean waitUntilExists(String path, TimeUnit timeUnit, long time) throws ZkInterruptedException {
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        LOG.debug((Object)("Waiting until znode '" + path + "' becomes available."));
        if (this.exists(path)) {
            return true;
        }
        this.acquireEventLock();
        try {
            boolean gotSignal;
            while (!this.exists(path, true)) {
                gotSignal = this.getEventLock().getZNodeEventCondition().awaitUntil(timeout);
                if (gotSignal) continue;
                boolean bl = false;
                return bl;
            }
            gotSignal = true;
            return gotSignal;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    protected Set<IZkDataListener> getDataListener(String path) {
        return this._dataListener.get(path);
    }

    public void showFolders(OutputStream output) {
        try {
            output.write(ZkPathUtil.toString(this).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isZkSaslEnabled() {
        boolean isSecurityEnabled = false;
        boolean zkSaslEnabled = Boolean.parseBoolean(System.getProperty(ZK_SASL_CLIENT, "true"));
        String zkLoginContextName = System.getProperty(ZK_LOGIN_CONTEXT_NAME_KEY, "Client");
        if (!zkSaslEnabled) {
            LOG.warn((Object)"Client SASL has been explicitly disabled with zookeeper.sasl.client");
            return false;
        }
        String loginConfigFile = System.getProperty(JAVA_LOGIN_CONFIG_PARAM);
        if (loginConfigFile != null && loginConfigFile.length() > 0) {
            LOG.info((Object)("JAAS File name: " + loginConfigFile));
            File configFile = new File(loginConfigFile);
            if (!configFile.canRead()) {
                throw new IllegalArgumentException("File " + loginConfigFile + "cannot be read.");
            }
            try {
                Configuration loginConf = Configuration.getConfiguration();
                isSecurityEnabled = loginConf.getAppConfigurationEntry(zkLoginContextName) != null;
            }
            catch (Exception e) {
                throw new ZkException(e);
            }
        }
        return isSecurityEnabled;
    }

    public void waitUntilConnected() throws ZkInterruptedException {
        this.waitUntilConnected(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean waitUntilConnected(long time, TimeUnit timeUnit) throws ZkInterruptedException {
        if (this._isZkSaslEnabled) {
            return this.waitForKeeperState(Watcher.Event.KeeperState.SaslAuthenticated, time, timeUnit);
        }
        return this.waitForKeeperState(Watcher.Event.KeeperState.SyncConnected, time, timeUnit);
    }

    public boolean waitForKeeperState(Watcher.Event.KeeperState keeperState, long time, TimeUnit timeUnit) throws ZkInterruptedException {
        if (this._zookeeperEventThread != null && Thread.currentThread() == this._zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        LOG.info((Object)("Waiting for keeper state " + (Object)((Object)keeperState)));
        this.acquireEventLock();
        try {
            boolean stillWaiting = true;
            while (this._currentState != keeperState) {
                if (!stillWaiting) {
                    boolean bl = false;
                    return bl;
                }
                stillWaiting = this.getEventLock().getStateChangedCondition().awaitUntil(timeout);
            }
            LOG.debug((Object)("State is " + (Object)((Object)this._currentState)));
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    private void acquireEventLock() {
        try {
            this.getEventLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    public <T> T retryUntilConnected(Callable<T> callable) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        if (this._zookeeperEventThread != null && Thread.currentThread() == this._zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        long operationStartTime = System.currentTimeMillis();
        do {
            if (this._closed) {
                throw new IllegalStateException("ZkClient already closed!");
            }
            try {
                return callable.call();
            }
            catch (KeeperException.ConnectionLossException e) {
                Thread.yield();
                this.waitForRetry();
            }
            catch (KeeperException.SessionExpiredException e) {
                Thread.yield();
                this.waitForRetry();
            }
            catch (KeeperException e) {
                throw ZkException.create(e);
            }
            catch (InterruptedException e) {
                throw new ZkInterruptedException(e);
            }
            catch (Exception e) {
                throw ExceptionUtil.convertToRuntimeException(e);
            }
        } while (this.operationRetryTimeoutInMillis <= -1L || System.currentTimeMillis() - operationStartTime < this.operationRetryTimeoutInMillis);
        throw new ZkTimeoutException("Operation cannot be retried because of retry timeout (" + this.operationRetryTimeoutInMillis + " milli seconds)");
    }

    private void waitForRetry() {
        if (this.operationRetryTimeoutInMillis < 0L) {
            this.waitUntilConnected();
            return;
        }
        this.waitUntilConnected(this.operationRetryTimeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentState(Watcher.Event.KeeperState currentState) {
        this.getEventLock().lock();
        try {
            this._currentState = currentState;
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public ZkLock getEventLock() {
        return this._zkEventLock;
    }

    public boolean delete(final String path) {
        try {
            this.retryUntilConnected(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ZkClient.this._connection.delete(path);
                    return null;
                }
            });
            return true;
        }
        catch (ZkNoNodeException e) {
            return false;
        }
    }

    private byte[] serialize(Object data2) {
        return this._zkSerializer.serialize(data2);
    }

    private <T> T derializable(byte[] data2) {
        if (data2 == null) {
            return null;
        }
        return (T)this._zkSerializer.deserialize(data2);
    }

    public <T> T readData(String path) {
        return this.readData(path, false);
    }

    public <T> T readData(String path, boolean returnNullIfPathNotExists) {
        T data2;
        block2: {
            data2 = null;
            try {
                data2 = this.readData(path, null);
            }
            catch (ZkNoNodeException e) {
                if (returnNullIfPathNotExists) break block2;
                throw e;
            }
        }
        return data2;
    }

    public <T> T readData(String path, Stat stat) {
        return this.readData(path, stat, this.hasListeners(path));
    }

    protected <T> T readData(final String path, final Stat stat, final boolean watch) {
        byte[] data2 = this.retryUntilConnected(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return ZkClient.this._connection.readData(path, stat, watch);
            }
        });
        return this.derializable(data2);
    }

    public void writeData(String path, Object object) {
        this.writeData(path, object, -1);
    }

    public <T> void updateDataSerialized(String path, DataUpdater<T> updater) {
        boolean retry;
        Stat stat = new Stat();
        do {
            retry = false;
            try {
                T oldData = this.readData(path, stat);
                T newData = updater.update(oldData);
                this.writeData(path, newData, stat.getVersion());
            }
            catch (ZkBadVersionException e) {
                retry = true;
            }
        } while (retry);
    }

    public void writeData(String path, Object datat, int expectedVersion) {
        this.writeDataReturnStat(path, datat, expectedVersion);
    }

    public Stat writeDataReturnStat(final String path, Object datat, final int expectedVersion) {
        final byte[] data2 = this.serialize(datat);
        return (Stat)this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Stat stat = ZkClient.this._connection.writeDataReturnStat(path, data2, expectedVersion);
                return stat;
            }
        });
    }

    public void watchForData(final String path) {
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ZkClient.this._connection.exists(path, true);
                return null;
            }
        });
    }

    public List<String> watchForChilds(final String path) {
        if (this._zookeeperEventThread != null && Thread.currentThread() == this._zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        return this.retryUntilConnected(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ZkClient.this.exists(path, true);
                try {
                    return ZkClient.this.getChildren(path, true);
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    return null;
                }
            }
        });
    }

    public void addAuthInfo(final String scheme, final byte[] auth) {
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ZkClient.this._connection.addAuthInfo(scheme, auth);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(long maxMsToWaitUntilConnected, Watcher watcher) throws ZkInterruptedException, ZkTimeoutException, IllegalStateException {
        boolean started = false;
        this.acquireEventLock();
        try {
            this.setShutdownTrigger(false);
            this._eventThread = new ZkEventThread(this._connection.getServers());
            this._eventThread.start();
            this._connection.connect(watcher);
            LOG.debug((Object)"Awaiting connection to Zookeeper server");
            boolean waitSuccessful = this.waitUntilConnected(maxMsToWaitUntilConnected, TimeUnit.MILLISECONDS);
            if (!waitSuccessful) {
                throw new ZkTimeoutException("Unable to connect to zookeeper server within timeout: " + maxMsToWaitUntilConnected);
            }
            started = true;
        }
        finally {
            this.getEventLock().unlock();
            if (!started) {
                this.close();
            }
        }
    }

    public long getCreationTime(String path) {
        this.acquireEventLock();
        try {
            long l = this._connection.getCreateTime(path);
            return l;
        }
        catch (KeeperException e) {
            throw ZkException.create(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public void close() throws ZkInterruptedException {
        if (this._closed) {
            return;
        }
        LOG.debug((Object)"Closing ZkClient...");
        this.getEventLock().lock();
        try {
            this.setShutdownTrigger(true);
            this._eventThread.interrupt();
            this._eventThread.join(2000L);
            this._connection.close();
            this._closed = true;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
        LOG.debug((Object)"Closing ZkClient...done");
    }

    private void reconnect() {
        this.getEventLock().lock();
        try {
            this._connection.close();
            this._connection.connect(this);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public void setShutdownTrigger(boolean triggerState) {
        this._shutdownTriggered = triggerState;
    }

    public boolean getShutdownTrigger() {
        return this._shutdownTriggered;
    }

    public int numberOfListeners() {
        int listeners = 0;
        for (Set<IZkChildListener> set : this._childListener.values()) {
            listeners += set.size();
        }
        for (Set<Object> set : this._dataListener.values()) {
            listeners += set.size();
        }
        return listeners += this._stateListener.size();
    }

    public List<OpResult> multi(final Iterable<Op> ops2) throws ZkException {
        if (ops2 == null) {
            throw new NullPointerException("ops must not be null.");
        }
        return this.retryUntilConnected(new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return ZkClient.this._connection.multi(ops2);
            }
        });
    }
}

