/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.FileMessageSet$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.CoreUtils$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u0001\u001d\u0011aBR5mK6+7o]1hKN+GO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000f5,7o]1hK&\u0011QB\u0003\u0002\u000b\u001b\u0016\u001c8/Y4f'\u0016$\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!\u00111A\u0005\u0002Y\tAAZ5mKV\tq\u0003\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005\u0011\u0011n\u001c\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0003GS2,\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0007I\u0011A\u0011\u0002\u0011\u0019LG.Z0%KF$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\tUs\u0017\u000e\u001e\u0005\bS}\t\t\u00111\u0001\u0018\u0003\rAH%\r\u0005\tW\u0001\u0011\t\u0011)Q\u0005/\u0005)a-\u001b7fA!\u0012!&\f\t\u0003G9J!a\f\u0013\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"\r\u0001\u0003\u0006\u0004%\tA\u0001\u001a\u0002\u000f\rD\u0017M\u001c8fYV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005A1\r[1o]\u0016d7O\u0003\u000297\u0005\u0019a.[8\n\u0005i*$a\u0003$jY\u0016\u001c\u0005.\u00198oK2D\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IaM\u0001\tG\"\fgN\\3mA!Ia\b\u0001BC\u0002\u0013\u0005!aP\u0001\u0006gR\f'\u000f^\u000b\u0002\u0001B\u00111%Q\u0005\u0003\u0005\u0012\u00121!\u00138u\u0011!!\u0005A!A!\u0002\u0013\u0001\u0015AB:uCJ$\b\u0005C\u0005G\u0001\t\u0015\r\u0011\"\u0001\u0003\u007f\u0005\u0019QM\u001c3\t\u0011!\u0003!\u0011!Q\u0001\n\u0001\u000bA!\u001a8eA!A!\n\u0001B\u0001B\u0003%1*A\u0004jgNc\u0017nY3\u0011\u0005\rb\u0015BA'%\u0005\u001d\u0011un\u001c7fC:Daa\u0014\u0001\u0005\u0002\u0011\u0001\u0016A\u0002\u001fj]&$h\b\u0006\u0004R'R+fk\u0016\t\u0003%\u0002i\u0011A\u0001\u0005\u0006+9\u0003\ra\u0006\u0005\u0006c9\u0003\ra\r\u0005\u0006}9\u0003\r\u0001\u0011\u0005\u0006\r:\u0003\r\u0001\u0011\u0005\u0006\u0015:\u0003\ra\u0013\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0003\u0015y6/\u001b>f+\u0005Y\u0006C\u0001/d\u001b\u0005i&B\u00010`\u0003\u0019\tGo\\7jG*\u0011\u0001-Y\u0001\u000bG>t7-\u001e:sK:$(B\u00012\u001c\u0003\u0011)H/\u001b7\n\u0005\u0011l&!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0004g\u0001\u0001\u0006IaW\u0001\u0007?NL'0\u001a\u0011\t\u000b=\u0003A\u0011\u00015\u0015\u0007EK'\u000eC\u0003\u0016O\u0002\u0007q\u0003C\u00032O\u0002\u00071\u0007C\u0003P\u0001\u0011\u0005A\u000e\u0006\u0002R[\")Qc\u001ba\u0001/!)q\n\u0001C\u0001_R)\u0011\u000b]9tk\")QC\u001ca\u0001/!)!O\u001ca\u0001\u0017\u0006\tb-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:\t\u000bQt\u0007\u0019\u0001!\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u000bYt\u0007\u0019A&\u0002\u0017A\u0014X-\u00197m_\u000e\fG/\u001a\u0005\u0006\u001f\u0002!\t\u0001\u001f\u000b\u0004#fT\b\"B\u000bx\u0001\u00049\u0002\"B>x\u0001\u0004Y\u0015aB7vi\u0006\u0014G.\u001a\u0005\u0006\u001f\u0002!\t! \u000b\b#z|\u0018\u0011AA\u0002\u0011\u0015)B\u00101\u0001\u0018\u0011\u0015\tD\u00101\u00014\u0011\u0015qD\u00101\u0001A\u0011\u00151E\u00101\u0001A\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tAA]3bIR)\u0011+a\u0003\u0002\u0010!9\u0011QBA\u0003\u0001\u0004\u0001\u0015\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005E\u0011Q\u0001a\u0001\u0001\u0006!1/\u001b>f\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\t\u0011b]3be\u000eDgi\u001c:\u0015\r\u0005e\u0011qDA\u0015!\r\u0011\u00161D\u0005\u0004\u0003;\u0011!AD(gMN,G\u000fU8tSRLwN\u001c\u0005\t\u0003C\t\u0019\u00021\u0001\u0002$\u0005aA/\u0019:hKR|eMZ:fiB\u00191%!\n\n\u0007\u0005\u001dBE\u0001\u0003M_:<\u0007bBA\u0016\u0003'\u0001\r\u0001Q\u0001\u0011gR\f'\u000f^5oOB{7/\u001b;j_:Dq!a\f\u0001\t\u0003\t\t$A\u0004xe&$X\rV8\u0015\u000f\u0001\u000b\u0019$!\u0010\u0002B!A\u0011QGA\u0017\u0001\u0004\t9$A\u0006eKN$8\t[1o]\u0016d\u0007c\u0001\u001b\u0002:%\u0019\u00111H\u001b\u0003)\u001d\u000bG\u000f[3sS:<')\u001f;f\u0007\"\fgN\\3m\u0011!\ty$!\fA\u0002\u0005\r\u0012!D<sSR,\u0007k\\:ji&|g\u000eC\u0004\u0002\u0012\u00055\u0002\u0019\u0001!\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005A\u0011\u000e^3sCR|'\u000f\u0006\u0002\u0002JA1\u00111JA.\u0003CrA!!\u0014\u0002X9!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0007\u0005eC%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0013q\f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011\u0011\f\u0013\u0011\u0007%\t\u0019'C\u0002\u0002f)\u0011\u0001#T3tg\u0006<W-\u00118e\u001f\u001a47/\u001a;\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002jQ!\u0011\u0011JA6\u0011\u001d\ti'a\u001aA\u0002\u0001\u000ba\"\\1y\u001b\u0016\u001c8/Y4f'&TX\rC\u0004\u0002r\u0001!\t!a\u001d\u0002\u0017ML'0Z%o\u0005f$Xm\u001d\u000b\u0002\u0001\"9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0014AB1qa\u0016tG\rF\u0002#\u0003wB\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\t[\u0016\u001c8/Y4fgB\u0019\u0011\"!!\n\u0007\u0005\r%B\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003\u00151G.^:i)\u0005\u0011\u0003bBAG\u0001\u0011\u0005\u0011\u0011R\u0001\u0006G2|7/\u001a\u0005\b\u0003#\u0003A\u0011AAE\u0003\u0011!(/[7\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u00061A-\u001a7fi\u0016$\u0012a\u0013\u0005\b\u00037\u0003A\u0011AAO\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004\u0001\u0006}\u0005bBAQ\u00033\u0003\r\u0001Q\u0001\u000bi\u0006\u0014x-\u001a;TSj,\u0007bBAS\u0001\u0011\u0005\u0011qU\u0001\te\u0016\fG-\u00138u_R1\u0011\u0011VAY\u0003k\u0003B!a+\u0002.6\tq'C\u0002\u00020^\u0012!BQ=uK\n+hMZ3s\u0011!\t\u0019,a)A\u0002\u0005%\u0016A\u00022vM\u001a,'\u000fC\u0004\u00028\u0006\r\u0006\u0019\u0001!\u0002!I,G.\u0019;jm\u0016\u0004vn]5uS>t\u0007bBA^\u0001\u0011\u0005\u0011QX\u0001\te\u0016t\u0017-\\3U_R\u00191*a0\t\u000f\u0005\u0005\u0017\u0011\u0018a\u0001/\u0005\ta\rK\u0002\u0001\u0003\u000b\u00042aDAd\u0013\r\tI\r\u0005\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3\b\u000f\u00055'\u0001#\u0001\u0002P\u0006qa)\u001b7f\u001b\u0016\u001c8/Y4f'\u0016$\bc\u0001*\u0002R\u001a1\u0011A\u0001E\u0001\u0003'\u001cB!!5\u0002VB\u00191%a6\n\u0007\u0005eGE\u0001\u0004B]f\u0014VM\u001a\u0005\b\u001f\u0006EG\u0011AAo)\t\ty\r\u0003\u0005\u0002b\u0006EG\u0011AAr\u0003-y\u0007/\u001a8DQ\u0006tg.\u001a7\u0015\u0017M\n)/a:\u0002j\u0006-\u0018Q\u001e\u0005\u0007+\u0005}\u0007\u0019A\f\t\rm\fy\u000e1\u0001L\u0011!\u0011\u0018q\u001cI\u0001\u0002\u0004Y\u0005\u0002\u0003;\u0002`B\u0005\t\u0019\u0001!\t\u0011Y\fy\u000e%AA\u0002-C!\"!=\u0002RF\u0005I\u0011AAz\u0003Uy\u0007/\u001a8DQ\u0006tg.\u001a7%I\u00164\u0017-\u001e7uIM*\"!!>+\u0007-\u000b9p\u000b\u0002\u0002zB!\u00111 B\u0003\u001b\t\tiP\u0003\u0003\u0002\u0000\n\u0005\u0011!C;oG\",7m[3e\u0015\r\u0011\u0019\u0001J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0004\u0003{\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011Y!!5\u0012\u0002\u0013\u0005!QB\u0001\u0016_B,gn\u00115b]:,G\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yAK\u0002A\u0003oD!Ba\u0005\u0002RF\u0005I\u0011AAz\u0003Uy\u0007/\u001a8DQ\u0006tg.\u001a7%I\u00164\u0017-\u001e7uIU\u0002")
public class FileMessageSet
extends MessageSet
implements Logging {
    private volatile File file;
    private final FileChannel channel;
    private final int start;
    private final int end;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean openChannel$default$5() {
        return FileMessageSet$.MODULE$.openChannel$default$5();
    }

    public static int openChannel$default$4() {
        return FileMessageSet$.MODULE$.openChannel$default$4();
    }

    public static boolean openChannel$default$3() {
        return FileMessageSet$.MODULE$.openChannel$default$3();
    }

    public static FileChannel openChannel(File file, boolean bl, boolean bl2, int n, boolean bl3) {
        return FileMessageSet$.MODULE$.openChannel(file, bl, bl2, n, bl3);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet read(int position, int size2) {
        if (position < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid position: ").append(BoxesRunTime.boxToInteger(position)).toString());
        }
        if (size2 < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid size: ").append(BoxesRunTime.boxToInteger(size2)).toString());
        }
        return new FileMessageSet(this.file(), this.channel(), this.start() + position, package$.MODULE$.min(this.start() + position + size2, this.sizeInBytes()));
    }

    public OffsetPosition searchFor(long targetOffset, int startingPosition) {
        int position = startingPosition;
        ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int size2 = this.sizeInBytes();
        while (position + MessageSet$.MODULE$.LogOverhead() < size2) {
            buffer.rewind();
            this.channel().read(buffer, position);
            if (buffer.hasRemaining()) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(targetOffset), BoxesRunTime.boxToInteger(startingPosition), this.file().getAbsolutePath()})));
            }
            buffer.rewind();
            long offset = buffer.getLong();
            if (offset >= targetOffset) {
                return new OffsetPosition(offset, position);
            }
            int messageSize = buffer.getInt();
            if (messageSize < Message$.MODULE$.MessageOverhead()) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Invalid message size: ").append(BoxesRunTime.boxToInteger(messageSize)).toString());
            }
            position += MessageSet$.MODULE$.LogOverhead() + messageSize;
        }
        return null;
    }

    @Override
    public int writeTo(GatheringByteChannel destChannel, long writePosition, int size2) {
        long l;
        int newSize = package$.MODULE$.min((int)this.channel().size(), this.end()) - this.start();
        if (newSize < this._size().get()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger(this._size().get()), BoxesRunTime.boxToInteger(newSize)})));
        }
        long position = (long)this.start() + writePosition;
        int count2 = package$.MODULE$.min(size2, this.sizeInBytes());
        GatheringByteChannel gatheringByteChannel = destChannel;
        if (gatheringByteChannel instanceof TransportLayer) {
            TransportLayer transportLayer = (TransportLayer)gatheringByteChannel;
            l = transportLayer.transferFrom(this.channel(), position, count2);
        } else {
            l = this.channel().transferTo(position, count2, gatheringByteChannel);
        }
        int bytesTransferred = (int)l;
        this.trace((Function0<String>)((Object)new Serializable(this, size2, bytesTransferred){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;
            private final int size$1;
            private final int bytesTransferred$1;

            public final String apply() {
                return new StringBuilder().append((Object)"FileMessageSet ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" : bytes transferred : ").append(BoxesRunTime.boxToInteger(this.bytesTransferred$1)).append((Object)" bytes requested for transfer : ").append(BoxesRunTime.boxToInteger(package$.MODULE$.min(this.size$1, this.$outer.sizeInBytes()))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.size$1 = size$1;
                this.bytesTransferred$1 = bytesTransferred$1;
            }
        }));
        return bytesTransferred;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.iterator(Integer.MAX_VALUE);
    }

    public Iterator<MessageAndOffset> iterator(int maxMessageSize) {
        return new IteratorTemplate<MessageAndOffset>(this, maxMessageSize){
            private int location;
            private final ByteBuffer sizeOffsetBuffer;
            private final /* synthetic */ FileMessageSet $outer;
            private final int maxMessageSize$1;

            private int location() {
                return this.location;
            }

            private void location_$eq(int x$1) {
                this.location = x$1;
            }

            private ByteBuffer sizeOffsetBuffer() {
                return this.sizeOffsetBuffer;
            }

            public MessageAndOffset makeNext() {
                if (this.location() >= this.$outer.end()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                this.$outer.channel().read(this.sizeOffsetBuffer(), this.location());
                if (this.sizeOffsetBuffer().hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                long offset = this.sizeOffsetBuffer().getLong();
                int size2 = this.sizeOffsetBuffer().getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    return (MessageAndOffset)this.allDone();
                }
                if (size2 > this.maxMessageSize$1) {
                    throw new InvalidMessageException(new StringOps(Predef$.MODULE$.augmentString("Message size exceeds the largest allowable message size (%d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxMessageSize$1)})));
                }
                ByteBuffer buffer = ByteBuffer.allocate(size2);
                this.$outer.channel().read(buffer, this.location() + 12);
                if (buffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                buffer.rewind();
                this.location_$eq(this.location() + (size2 + 12));
                return new MessageAndOffset(new Message(buffer), offset);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.location = $outer.start();
                this.sizeOffsetBuffer = ByteBuffer.allocate(12);
            }
        };
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet messages) {
        int written = messages.writeTo(this.channel(), 0L, messages.sizeInBytes());
        this._size().getAndAdd(written);
    }

    public void flush() {
        this.channel().force(true);
    }

    public void close() {
        this.flush();
        this.trim();
        this.channel().close();
    }

    public void trim() {
        this.truncateTo(this.sizeInBytes());
    }

    public boolean delete() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        return this.file().delete();
    }

    public int truncateTo(int targetSize) {
        int originalSize = this.sizeInBytes();
        if (targetSize > originalSize || targetSize < 0) {
            throw new KafkaException(new StringBuilder().append((Object)"Attempt to truncate log segment to ").append(BoxesRunTime.boxToInteger(targetSize)).append((Object)" bytes failed, ").append((Object)" size of this log segment is ").append(BoxesRunTime.boxToInteger(originalSize)).append((Object)" bytes.").toString());
        }
        this.channel().truncate(targetSize);
        this.channel().position(targetSize);
        this._size().set(targetSize);
        return originalSize - targetSize;
    }

    public ByteBuffer readInto(ByteBuffer buffer, int relativePosition) {
        this.channel().read(buffer, relativePosition + this.start());
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTo(File f) {
        void var2_2;
        boolean success2 = this.file().renameTo(f);
        this.file_$eq(f);
        return (boolean)var2_2;
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end, boolean isSlice) {
        this.file = file;
        this.channel = channel;
        this.start = start;
        this.end = end;
        Logging$class.$init$(this);
        this._size = isSlice ? new AtomicInteger(end - start) : new AtomicInteger(package$.MODULE$.min((int)channel.size(), end) - start);
        Object object = isSlice ? BoxedUnit.UNIT : channel.position(package$.MODULE$.min((int)channel.size(), end));
    }

    public FileMessageSet(File file, FileChannel channel) {
        this(file, channel, 0, Integer.MAX_VALUE, false);
    }

    public FileMessageSet(File file) {
        this(file, FileMessageSet$.MODULE$.openChannel(file, true, FileMessageSet$.MODULE$.openChannel$default$3(), FileMessageSet$.MODULE$.openChannel$default$4(), FileMessageSet$.MODULE$.openChannel$default$5()));
    }

    public FileMessageSet(File file, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        this(file, FileMessageSet$.MODULE$.openChannel(file, true, fileAlreadyExists, initFileSize, preallocate), 0, !fileAlreadyExists && preallocate ? 0 : Integer.MAX_VALUE, false);
    }

    public FileMessageSet(File file, boolean mutable) {
        this(file, FileMessageSet$.MODULE$.openChannel(file, mutable, FileMessageSet$.MODULE$.openChannel$default$3(), FileMessageSet$.MODULE$.openChannel$default$4(), FileMessageSet$.MODULE$.openChannel$default$5()));
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end) {
        this(file, channel, start, end, true);
    }
}

