/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.admin.AdminClient$;
import kafka.admin.AdminClient$ConsumerSummary$;
import kafka.common.KafkaException;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.MemberSummary;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.SendFailedException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\re\u0001B\u0001\u0003\u0001\u001d\u00111\"\u00113nS:\u001cE.[3oi*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005!A/[7f+\u00059\u0002C\u0001\r\"\u001b\u0005I\"BA\t\u001b\u0015\tYB$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000buQ!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO&\u0011!%\u0007\u0002\u0005)&lW\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u0018\u0003\u0015!\u0018.\\3!\u0011!1\u0003A!b\u0001\n\u00039\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t+\u0005A\u0003CA\u0005*\u0013\tQ#BA\u0002J]RD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0012e\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011A\u0018\u0002\r\rd\u0017.\u001a8u+\u0005\u0001\u0004CA\u00199\u001b\u0005\u0011$BA\u001a5\u0003%Ig\u000e^3s]\u0006d7O\u0003\u00026m\u0005A1m\u001c8tk6,'O\u0003\u000289\u000591\r\\5f]R\u001c\u0018BA\u001d3\u0005U\u0019uN\\:v[\u0016\u0014h*\u001a;x_J\\7\t\\5f]RD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\bG2LWM\u001c;!\u0011!i\u0004A!b\u0001\n\u0003q\u0014\u0001\u00052p_R\u001cHO]1q\u0005J|7.\u001a:t+\u0005y\u0004c\u0001!I\u0017:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005\u001dS\u0011a\u00029bG.\fw-Z\u0005\u0003\u0013*\u0013A\u0001T5ti*\u0011qI\u0003\t\u0003\u00196k\u0011AG\u0005\u0003\u001dj\u0011AAT8eK\"A\u0001\u000b\u0001B\u0001B\u0003%q(A\tc_>$8\u000f\u001e:ba\n\u0013xn[3sg\u0002BQA\u0015\u0001\u0005\u0002M\u000ba\u0001P5oSRtD#\u0002+W/bK\u0006CA+\u0001\u001b\u0005\u0011\u0001\"B\u000bR\u0001\u00049\u0002\"\u0002\u0014R\u0001\u0004A\u0003\"\u0002\u0018R\u0001\u0004\u0001\u0004\"B\u001fR\u0001\u0004y\u0004\"B.\u0001\t\u0013a\u0016\u0001B:f]\u0012$B!X3h[B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0006if\u0004Xm\u001d\u0006\u0003Ej\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003I~\u0013aa\u0015;sk\u000e$\b\"\u00024[\u0001\u0004Y\u0015A\u0002;be\u001e,G\u000fC\u0003i5\u0002\u0007\u0011.A\u0002ba&\u0004\"A[6\u000e\u0003\u0005L!\u0001\\1\u0003\u000f\u0005\u0003\u0018nS3zg\")aN\u0017a\u0001_\u00069!/Z9vKN$\bC\u00019t\u001b\u0005\t(B\u0001:\u001b\u0003!\u0011X-];fgR\u001c\u0018B\u0001;r\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"\u0002<\u0001\t\u00139\u0018aC:f]\u0012\fe.\u001f(pI\u0016$2!\u0018=z\u0011\u0015AW\u000f1\u0001j\u0011\u0015qW\u000f1\u0001p\u0011\u0015Y\b\u0001\"\u0003}\u0003=1\u0017N\u001c3D_>\u0014H-\u001b8bi>\u0014HCA&~\u0011\u0015q(\u00101\u0001\u0000\u0003\u001d9'o\\;q\u0013\u0012\u0004B!!\u0001\u0002\b9\u0019\u0011\"a\u0001\n\u0007\u0005\u0015!\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bQ\u0001bBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\u000bY&\u001cHo\u0012:pkB\u001cH\u0003BA\n\u0003C\u0001B\u0001\u0011%\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0011\t1bY8pe\u0012Lg.\u0019;pe&!\u0011qDA\r\u000559%o\\;q\u001fZ,'O^5fo\"9\u00111EA\u0007\u0001\u0004Y\u0015\u0001\u00028pI\u0016Dq!a\n\u0001\t\u0013\tI#\u0001\bgS:$\u0017\t\u001c7Ce>\\WM]:\u0015\u0003}Bq!!\f\u0001\t\u0003\ty#A\u0007mSN$\u0018\t\u001c7He>,\bo\u001d\u000b\u0003\u0003c\u0001r!!\u0001\u00024-\u000b\u0019\"\u0003\u0003\u00026\u0005-!aA'ba\"9\u0011\u0011\b\u0001\u0005\u0002\u0005=\u0012!\u00067jgR\fE\u000e\\\"p]N,X.\u001a:He>,\bo\u001d\u0005\b\u0003{\u0001A\u0011AA \u0003Ya\u0017n\u001d;BY2<%o\\;qg\u001ac\u0017\r\u001e;f]\u0016$GCAA\n\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u007f\ta\u0004\\5ti\u0006cGnQ8ogVlWM]$s_V\u00048O\u00127biR,g.\u001a3\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J\u0005iA-Z:de&\u0014Wm\u0012:pkB$B!a\u0013\u0002RA!\u0011qCA'\u0013\u0011\ty%!\u0007\u0003\u0019\u001d\u0013x.\u001e9Tk6l\u0017M]=\t\ry\f)\u00051\u0001\u0000\r\u0019\t)\u0006\u0001!\u0002X\ty1i\u001c8tk6,'oU;n[\u0006\u0014\u0018pE\u0004\u0002T!\tI&a\u0018\u0011\u0007%\tY&C\u0002\u0002^)\u0011q\u0001\u0015:pIV\u001cG\u000fE\u0002\n\u0003CJ1!a\u0019\u000b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011-\t9'a\u0015\u0003\u0016\u0004%\t!!\u001b\u0002\u00115,WNY3s\u0013\u0012,\u0012a \u0005\u000b\u0003[\n\u0019F!E!\u0002\u0013y\u0018!C7f[\n,'/\u00133!\u0011-\t\t(a\u0015\u0003\u0016\u0004%\t!!\u001b\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012D!\"!\u001e\u0002T\tE\t\u0015!\u0003\u0000\u0003%\u0019G.[3oi&#\u0007\u0005C\u0006\u0002z\u0005M#Q3A\u0005\u0002\u0005%\u0014AC2mS\u0016tG\u000fS8ti\"Q\u0011QPA*\u0005#\u0005\u000b\u0011B@\u0002\u0017\rd\u0017.\u001a8u\u0011>\u001cH\u000f\t\u0005\f\u0003\u0003\u000b\u0019F!f\u0001\n\u0003\t\u0019)\u0001\u0006bgNLwM\\7f]R,\"!!\"\u0011\t\u0001C\u0015q\u0011\t\u0004\u0019\u0006%\u0015bAAF5\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bCAH\u0003'\u0012\t\u0012)A\u0005\u0003\u000b\u000b1\"Y:tS\u001etW.\u001a8uA!9!+a\u0015\u0005\u0002\u0005MECCAK\u00033\u000bY*!(\u0002 B!\u0011qSA*\u001b\u0005\u0001\u0001bBA4\u0003#\u0003\ra \u0005\b\u0003c\n\t\n1\u0001\u0000\u0011\u001d\tI(!%A\u0002}D\u0001\"!!\u0002\u0012\u0002\u0007\u0011Q\u0011\u0005\u000b\u0003G\u000b\u0019&!A\u0005\u0002\u0005\u0015\u0016\u0001B2paf$\"\"!&\u0002(\u0006%\u00161VAW\u0011%\t9'!)\u0011\u0002\u0003\u0007q\u0010C\u0005\u0002r\u0005\u0005\u0006\u0013!a\u0001\u007f\"I\u0011\u0011PAQ!\u0003\u0005\ra \u0005\u000b\u0003\u0003\u000b\t\u000b%AA\u0002\u0005\u0015\u0005BCAY\u0003'\n\n\u0011\"\u0001\u00024\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA[U\ry\u0018qW\u0016\u0003\u0003s\u0003B!a/\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0019\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002H\u0006u&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u00111ZA*#\u0003%\t!a-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q\u0011qZA*#\u0003%\t!a-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u00111[A*#\u0003%\t!!6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u001b\u0016\u0005\u0003\u000b\u000b9\f\u0003\u0006\u0002\\\u0006M\u0013\u0011!C!\u0003;\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAp!\u0011\t\t/a;\u000e\u0005\u0005\r(\u0002BAs\u0003O\fA\u0001\\1oO*\u0011\u0011\u0011^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\n\u0005\r\b\"CAx\u0003'\n\t\u0011\"\u0001(\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\t\u00190a\u0015\u0002\u0002\u0013\u0005\u0011Q_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t90!@\u0011\u0007%\tI0C\u0002\u0002|*\u00111!\u00118z\u0011%\ty0!=\u0002\u0002\u0003\u0007\u0001&A\u0002yIEB!Ba\u0001\u0002T\u0005\u0005I\u0011\tB\u0003\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0004!\u0019\u0011IAa\u0004\u0002x6\u0011!1\u0002\u0006\u0004\u0005\u001bQ\u0011AC2pY2,7\r^5p]&!!\u0011\u0003B\u0006\u0005!IE/\u001a:bi>\u0014\bB\u0003B\u000b\u0003'\n\t\u0011\"\u0001\u0003\u0018\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u001a\t}\u0001cA\u0005\u0003\u001c%\u0019!Q\u0004\u0006\u0003\u000f\t{w\u000e\\3b]\"Q\u0011q B\n\u0003\u0003\u0005\r!a>\t\u0015\t\r\u00121KA\u0001\n\u0003\u0012)#\u0001\u0005iCND7i\u001c3f)\u0005A\u0003B\u0003B\u0015\u0003'\n\t\u0011\"\u0011\u0003,\u0005AAo\\*ue&tw\r\u0006\u0002\u0002`\"Q!qFA*\u0003\u0003%\tE!\r\u0002\r\u0015\fX/\u00197t)\u0011\u0011IBa\r\t\u0015\u0005}(QFA\u0001\u0002\u0004\t9pB\u0005\u00038\u0001\t\t\u0011#\u0001\u0003:\u0005y1i\u001c8tk6,'oU;n[\u0006\u0014\u0018\u0010\u0005\u0003\u0002\u0018\nmb!CA+\u0001\u0005\u0005\t\u0012\u0001B\u001f'\u0019\u0011YDa\u0010\u0002`AY!\u0011\tB$\u007f~|\u0018QQAK\u001b\t\u0011\u0019EC\u0002\u0003F)\tqA];oi&lW-\u0003\u0003\u0003J\t\r#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!9!Ka\u000f\u0005\u0002\t5CC\u0001B\u001d\u0011)\u0011ICa\u000f\u0002\u0002\u0013\u0015#1\u0006\u0005\u000b\u0005'\u0012Y$!A\u0005\u0002\nU\u0013!B1qa2LHCCAK\u0005/\u0012IFa\u0017\u0003^!9\u0011q\rB)\u0001\u0004y\bbBA9\u0005#\u0002\ra \u0005\b\u0003s\u0012\t\u00061\u0001\u0000\u0011!\t\tI!\u0015A\u0002\u0005\u0015\u0005B\u0003B1\u0005w\t\t\u0011\"!\u0003d\u00059QO\\1qa2LH\u0003\u0002B3\u0005c\u0002R!\u0003B4\u0005WJ1A!\u001b\u000b\u0005\u0019y\u0005\u000f^5p]BA\u0011B!\u001c\u0000\u007f~\f))C\u0002\u0003p)\u0011a\u0001V;qY\u0016$\u0004B\u0003B:\u0005?\n\t\u00111\u0001\u0002\u0016\u0006\u0019\u0001\u0010\n\u0019\t\u0015\t]$1HA\u0001\n\u0013\u0011I(A\u0006sK\u0006$'+Z:pYZ,GC\u0001B>!\u0011\t\tO! \n\t\t}\u00141\u001d\u0002\u0007\u001f\nTWm\u0019;\t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0006\u0006)B-Z:de&\u0014WmQ8ogVlWM]$s_V\u0004H\u0003\u0002BD\u0005\u0013\u0003B\u0001\u0011%\u0002\u0016\"1aP!!A\u0002}DqA!$\u0001\t\u0003\u0011y)A\u0003dY>\u001cX\r\u0006\u0002\u0003\u0012B\u0019\u0011Ba%\n\u0007\tU%B\u0001\u0003V]&$xa\u0002BM\u0005!\u0005!1T\u0001\f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fE\u0002V\u0005;3a!\u0001\u0002\t\u0002\t}5c\u0001BO\u0011!9!K!(\u0005\u0002\t\rFC\u0001BN\u0011%\u00119K!(C\u0002\u0013\u0005q%\u0001\u000eEK\u001a\fW\u000f\u001c;D_:tWm\u0019;j_:l\u0015\r_%eY\u0016l5\u000f\u0003\u0005\u0003,\nu\u0005\u0015!\u0003)\u0003m!UMZ1vYR\u001cuN\u001c8fGRLwN\\'bq&#G.Z'tA!I!q\u0016BO\u0005\u0004%\taJ\u0001\u0018\t\u00164\u0017-\u001e7u%\u0016\fX/Z:u)&lWm\\;u\u001bND\u0001Ba-\u0003\u001e\u0002\u0006I\u0001K\u0001\u0019\t\u00164\u0017-\u001e7u%\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\u0003\"\u0003B\\\u0005;\u0013\r\u0011\"\u0001(\u0003\u001d\"UMZ1vYRl\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;t!\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8\t\u0011\tm&Q\u0014Q\u0001\n!\n\u0001\u0006R3gCVdG/T1y\u0013:4E.[4iiJ+\u0017/^3tiN\u0004VM]\"p]:,7\r^5p]\u0002B\u0011Ba0\u0003\u001e\n\u0007I\u0011A\u0014\u00023\u0011+g-Y;miJ+7m\u001c8oK\u000e$()Y2l_\u001a4Wj\u001d\u0005\t\u0005\u0007\u0014i\n)A\u0005Q\u0005QB)\u001a4bk2$(+Z2p]:,7\r\u001e\"bG.|gMZ'tA!I!q\u0019BO\u0005\u0004%\taJ\u0001\u0017\t\u00164\u0017-\u001e7u'\u0016tGMQ;gM\u0016\u0014()\u001f;fg\"A!1\u001aBOA\u0003%\u0001&A\fEK\u001a\fW\u000f\u001c;TK:$')\u001e4gKJ\u0014\u0015\u0010^3tA!I!q\u001aBO\u0005\u0004%\taJ\u0001\u001a\t\u00164\u0017-\u001e7u%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:CsR,7\u000f\u0003\u0005\u0003T\nu\u0005\u0015!\u0003)\u0003i!UMZ1vYR\u0014VmY3jm\u0016\u0014UO\u001a4fe\nKH/Z:!\u0011%\u00119N!(C\u0002\u0013\u0005q%A\u000bEK\u001a\fW\u000f\u001c;SKR\u0014\u0018PQ1dW>4g-T:\t\u0011\tm'Q\u0014Q\u0001\n!\na\u0003R3gCVdGOU3uef\u0014\u0015mY6pM\u001al5\u000f\t\u0005\u000b\u0005?\u0014iJ1A\u0005\u0002\t\u0005\u0018!F!e[&t7\t\\5f]RLEmU3rk\u0016t7-Z\u000b\u0003\u0005G\u0004BA!:\u0003t6\u0011!q\u001d\u0006\u0005\u0005S\u0014Y/\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0005[\u0014y/\u0001\u0006d_:\u001cWO\u001d:f]RTAA!=\u0002h\u0006!Q\u000f^5m\u0013\u0011\u0011)Pa:\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011%\u0011IP!(!\u0002\u0013\u0011\u0019/\u0001\fBI6Lgn\u00117jK:$\u0018\nZ*fcV,gnY3!\u0011)\u0011iP!(C\u0002\u0013\u0005!q`\u0001\u000f\u0003\u0012l\u0017N\\\"p]\u001aLw\rR3g+\t\u0019\t\u0001\u0005\u0003\u0004\u0004\r%QBAB\u0003\u0015\r\u00199AG\u0001\u0007G>tg-[4\n\t\r-1Q\u0001\u0002\n\u0007>tg-[4EK\u001aD\u0011ba\u0004\u0003\u001e\u0002\u0006Ia!\u0001\u0002\u001f\u0005#W.\u001b8D_:4\u0017n\u001a#fM\u00022qaa\u0005\u0003\u001e\u0002\u0019)BA\u0006BI6LgnQ8oM&<7\u0003BB\t\u0007/\u0001Baa\u0001\u0004\u001a%!11DB\u0003\u00059\t%m\u001d;sC\u000e$8i\u001c8gS\u001eD1ba\b\u0004\u0012\t\u0005\t\u0015!\u0003\u0004\"\u0005IqN]5hS:\fGn\u001d\u0019\u0007\u0007G\u0019Ica\u000e\u0011\u0011\u0005\u0005\u00111GB\u0013\u0007k\u0001Baa\n\u0004*1\u0001A\u0001DB\u0016\u0007;\t\t\u0011!A\u0003\u0002\r5\"aA0%cE!1qFA|!\rI1\u0011G\u0005\u0004\u0007gQ!a\u0002(pi\"Lgn\u001a\t\u0005\u0007O\u00199\u0004\u0002\u0007\u0004:\ru\u0011\u0011!A\u0001\u0006\u0003\u0019iCA\u0002`IIBqAUB\t\t\u0003\u0019i\u0004\u0006\u0003\u0004@\r\r\u0003\u0003BB!\u0007#i!A!(\t\u0011\r}11\ba\u0001\u0007\u000b\u0002daa\u0012\u0004L\r=\u0003\u0003CA\u0001\u0003g\u0019Ie!\u0014\u0011\t\r\u001d21\n\u0003\r\u0007W\u0019\u0019%!A\u0001\u0002\u000b\u00051Q\u0006\t\u0005\u0007O\u0019y\u0005\u0002\u0007\u0004:\r\r\u0013\u0011!A\u0001\u0006\u0003\u0019i\u0003\u0003\u0005\u0004T\tuE\u0011AB+\u0003U\u0019'/Z1uKNKW\u000e\u001d7f!2\f\u0017N\u001c;fqR$2\u0001VB,\u0011\u001d\u0019If!\u0015A\u0002}\f\u0011B\u0019:pW\u0016\u0014XK\u001d7\t\u0011\ru#Q\u0014C\u0001\u0007?\naa\u0019:fCR,Gc\u0001+\u0004b!A11MB.\u0001\u0004\u0019)'A\u0003qe>\u00048\u000f\u0005\u0003\u0004h\r%TB\u0001Bx\u0013\u0011\u0019YGa<\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0005\u0004^\tuE\u0011AB8)\r!6\u0011\u000f\u0005\t\u0007G\u001ai\u00071\u0001\u0004tA\"1QOB=!\u001d\t\t!a\r\u0000\u0007o\u0002Baa\n\u0004z\u0011a11PB9\u0003\u0003\u0005\tQ!\u0001\u0004.\t\u0019q\fJ\u001a\t\u0011\ru#Q\u0014C\u0001\u0007\u007f\"2\u0001VBA\u0011!\u00199a! A\u0002\r}\u0002")
public class AdminClient
implements Logging {
    private final Time time;
    private final int requestTimeoutMs;
    private final ConsumerNetworkClient client;
    private final List<Node> bootstrapBrokers;
    private volatile AdminClient$ConsumerSummary$ ConsumerSummary$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static AdminClient create(AdminConfig adminConfig) {
        return AdminClient$.MODULE$.create(adminConfig);
    }

    public static AdminClient create(Map<String, Object> map2) {
        return AdminClient$.MODULE$.create(map2);
    }

    public static AdminClient create(Properties properties) {
        return AdminClient$.MODULE$.create(properties);
    }

    public static AdminClient createSimplePlaintext(String string2) {
        return AdminClient$.MODULE$.createSimplePlaintext(string2);
    }

    public static ConfigDef AdminConfigDef() {
        return AdminClient$.MODULE$.AdminConfigDef();
    }

    public static AtomicInteger AdminClientIdSequence() {
        return AdminClient$.MODULE$.AdminClientIdSequence();
    }

    public static int DefaultRetryBackoffMs() {
        return AdminClient$.MODULE$.DefaultRetryBackoffMs();
    }

    public static int DefaultReceiveBufferBytes() {
        return AdminClient$.MODULE$.DefaultReceiveBufferBytes();
    }

    public static int DefaultSendBufferBytes() {
        return AdminClient$.MODULE$.DefaultSendBufferBytes();
    }

    public static int DefaultReconnectBackoffMs() {
        return AdminClient$.MODULE$.DefaultReconnectBackoffMs();
    }

    public static int DefaultMaxInFlightRequestsPerConnection() {
        return AdminClient$.MODULE$.DefaultMaxInFlightRequestsPerConnection();
    }

    public static int DefaultRequestTimeoutMs() {
        return AdminClient$.MODULE$.DefaultRequestTimeoutMs();
    }

    public static int DefaultConnectionMaxIdleMs() {
        return AdminClient$.MODULE$.DefaultConnectionMaxIdleMs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AdminClient$ConsumerSummary$ ConsumerSummary$lzycompute() {
        AdminClient adminClient = this;
        synchronized (adminClient) {
            if (this.ConsumerSummary$module != null) return this.ConsumerSummary$module;
            this.ConsumerSummary$module = new AdminClient$ConsumerSummary$(this);
            return this.ConsumerSummary$module;
        }
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminClient adminClient = this;
        synchronized (adminClient) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Time time() {
        return this.time;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public ConsumerNetworkClient client() {
        return this.client;
    }

    public List<Node> bootstrapBrokers() {
        return this.bootstrapBrokers;
    }

    public Struct kafka$admin$AdminClient$$send(Node target, ApiKeys api, AbstractRequest request) {
        long now = this.time().milliseconds();
        long deadline = now + (long)this.requestTimeoutMs();
        RequestFuture<ClientResponse> future = null;
        do {
            future = this.client().send(target, api, request);
            this.client().poll(future);
            if (!future.succeeded()) continue;
            return future.value().responseBody();
        } while ((now = this.time().milliseconds()) < deadline && future.exception() instanceof SendFailedException);
        throw future.exception();
    }

    private Struct sendAnyNode(ApiKeys api, AbstractRequest request) {
        Object object = new Object();
        try {
            this.bootstrapBrokers().foreach(new Serializable(this, api, request, object){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AdminClient $outer;
                public final ApiKeys api$1;
                private final AbstractRequest request$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(Node x0$1) {
                    Node node = x0$1;
                    try {
                        throw new NonLocalReturnControl<Struct>(this.nonLocalReturnKey1$1, this.$outer.kafka$admin$AdminClient$$send(node, this.api$1, this.request$1));
                    }
                    catch (Exception exception) {
                        this.$outer.debug((Function0<String>)((Object)new Serializable(this, node){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$sendAnyNode$1 $outer;
                            private final Node x1$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " failed against node ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.api$1, this.x1$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.x1$1 = x1$1;
                            }
                        }), (Function0<Throwable>)((Object)new Serializable(this, exception){
                            public static final long serialVersionUID = 0L;
                            private final Exception e$1;

                            public final Exception apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = e$1;
                            }
                        }));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.api$1 = api$1;
                    this.request$1 = request$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw new RuntimeException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " failed on brokers ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{api, this.bootstrapBrokers()})));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (Struct)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    private Node findCoordinator(String groupId) {
        GroupCoordinatorRequest request = new GroupCoordinatorRequest(groupId);
        Struct responseBody = this.sendAnyNode(ApiKeys.GROUP_COORDINATOR, request);
        GroupCoordinatorResponse response = new GroupCoordinatorResponse(responseBody);
        Errors.forCode(response.errorCode()).maybeThrow();
        return response.node();
    }

    public List<GroupOverview> listGroups(Node node) {
        Struct responseBody = this.kafka$admin$AdminClient$$send(node, ApiKeys.LIST_GROUPS, new ListGroupsRequest());
        ListGroupsResponse response = new ListGroupsResponse(responseBody);
        Errors.forCode(response.errorCode()).maybeThrow();
        return ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(response.groups()).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GroupOverview apply(ListGroupsResponse.Group group) {
                return new GroupOverview(group.groupId(), group.protocolType());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
    }

    private List<Node> findAllBrokers() {
        MetadataRequest request = new MetadataRequest(JavaConversions$.MODULE$.seqAsJavaList(Nil$.MODULE$));
        Struct responseBody = this.sendAnyNode(ApiKeys.METADATA, request);
        MetadataResponse response = new MetadataResponse(responseBody);
        if (!response.errors().isEmpty()) {
            this.debug((Function0<String>)((Object)new Serializable(this, response){
                public static final long serialVersionUID = 0L;
                private final MetadataResponse response$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metadata request contained errors: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.response$1.errors()}));
                }
                {
                    this.response$1 = response$1;
                }
            }));
        }
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(response.cluster().nodes()).asScala()).toList();
    }

    public Map<Node, List<GroupOverview>> listAllGroups() {
        return ((TraversableOnce)this.findAllBrokers().map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClient $outer;

            public final Tuple2<Node, List<GroupOverview>> apply(Node x0$2) {
                Node node = x0$2;
                Tuple2<Node, List<GroupOverview>> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(node), this.liftedTree1$1(node));
                return tuple2;
            }

            private final List liftedTree1$1(Node x1$2) {
                Nil$ nil$;
                try {
                    nil$ = this.$outer.listGroups(x1$2);
                }
                catch (Exception exception) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, x1$2){
                        public static final long serialVersionUID = 0L;
                        private final Node x1$2;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find groups from broker ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.x1$2}));
                        }
                        {
                            this.x1$2 = x1$2;
                        }
                    }), (Function0<Throwable>)((Object)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$2;

                        public final Exception apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    }));
                    nil$ = Nil$.MODULE$;
                }
                return nil$;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Map<Node, List<GroupOverview>> listAllConsumerGroups() {
        return this.listAllGroups().mapValues(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<GroupOverview> apply(List<GroupOverview> groups) {
                return (List)groups.filter((Function1<GroupOverview, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(GroupOverview x$1) {
                        String string2 = x$1.protocolType();
                        String string3 = "consumer";
                        return !(string2 != null ? !string2.equals(string3) : string3 != null);
                    }
                }));
            }
        });
    }

    public List<GroupOverview> listAllGroupsFlattened() {
        return ((TraversableOnce)this.listAllGroups().values().flatten(Predef$.MODULE$.conforms())).toList();
    }

    public List<GroupOverview> listAllConsumerGroupsFlattened() {
        return (List)this.listAllGroupsFlattened().filter((Function1<GroupOverview, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GroupOverview x$2) {
                String string2 = x$2.protocolType();
                String string3 = "consumer";
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
        }));
    }

    public GroupSummary describeGroup(String groupId) {
        Node coordinator = this.findCoordinator(groupId);
        Struct responseBody = this.kafka$admin$AdminClient$$send(coordinator, ApiKeys.DESCRIBE_GROUPS, new DescribeGroupsRequest(JavaConverters$.MODULE$.seqAsJavaListConverter(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupId}))).asJava()));
        DescribeGroupsResponse response = new DescribeGroupsResponse(responseBody);
        DescribeGroupsResponse.GroupMetadata metadata = response.groups().get(groupId);
        if (metadata == null) {
            throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response from broker contained no metadata for group ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{groupId})));
        }
        Errors.forCode(metadata.errorCode()).maybeThrow();
        List<MemberSummary> members = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(metadata.members()).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MemberSummary apply(DescribeGroupsResponse.GroupMember member) {
                byte[] metadata = Utils.readBytes(member.memberMetadata());
                byte[] assignment = Utils.readBytes(member.memberAssignment());
                return new MemberSummary(member.memberId(), member.clientId(), member.clientHost(), metadata, assignment);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        return new GroupSummary(metadata.state(), metadata.protocolType(), metadata.protocol(), members);
    }

    public AdminClient$ConsumerSummary$ ConsumerSummary() {
        return this.ConsumerSummary$module == null ? this.ConsumerSummary$lzycompute() : this.ConsumerSummary$module;
    }

    public List<ConsumerSummary> describeConsumerGroup(String groupId) {
        GroupSummary group = this.describeGroup(groupId);
        String string2 = group.state();
        String string3 = "Dead";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return List$.MODULE$.empty();
        }
        String string4 = group.protocolType();
        String string5 = "consumer";
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            String string6 = group.state();
            String string7 = "Stable";
            return !(string6 != null ? !string6.equals(string7) : string7 != null) ? group.members().map(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AdminClient $outer;

                public final ConsumerSummary apply(MemberSummary member) {
                    PartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment(ByteBuffer.wrap(member.assignment()));
                    return new ConsumerSummary(this.$outer, member.memberId(), member.clientId(), member.clientHost(), ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(assignment.partitions()).asScala()).toList());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, List$.MODULE$.canBuildFrom()) : List$.MODULE$.empty();
        }
        throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group ", " with protocol type '", "' is not a valid consumer group"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{groupId, group.protocolType()})));
    }

    public void close() {
        this.client().close();
    }

    public AdminClient(Time time, int requestTimeoutMs, ConsumerNetworkClient client, List<Node> bootstrapBrokers) {
        this.time = time;
        this.requestTimeoutMs = requestTimeoutMs;
        this.client = client;
        this.bootstrapBrokers = bootstrapBrokers;
        Logging$class.$init$(this);
    }

    public static class AdminConfig
    extends AbstractConfig {
        public AdminConfig(Map<?, Object> originals) {
            super(AdminClient$.MODULE$.AdminConfigDef(), JavaConversions$.MODULE$.mapAsJavaMap(originals), Predef$.MODULE$.boolean2Boolean(false));
        }
    }

    public class ConsumerSummary
    implements Product,
    Serializable {
        private final String memberId;
        private final String clientId;
        private final String clientHost;
        private final List<TopicPartition> assignment;
        public final /* synthetic */ AdminClient $outer;

        public String memberId() {
            return this.memberId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public List<TopicPartition> assignment() {
            return this.assignment;
        }

        public ConsumerSummary copy(String memberId, String clientId, String clientHost, List<TopicPartition> assignment) {
            return new ConsumerSummary(this.kafka$admin$AdminClient$ConsumerSummary$$$outer(), memberId, clientId, clientHost, assignment);
        }

        public String copy$default$1() {
            return this.memberId();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public String copy$default$3() {
            return this.clientHost();
        }

        public List<TopicPartition> copy$default$4() {
            return this.assignment();
        }

        @Override
        public String productPrefix() {
            return "ConsumerSummary";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
                case 3: {
                    object = this.assignment();
                    break;
                }
                case 2: {
                    object = this.clientHost();
                    break;
                }
                case 1: {
                    object = this.clientId();
                    break;
                }
                case 0: {
                    object = this.memberId();
                }
            }
            return object;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConsumerSummary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConsumerSummary)) return false;
            if (((ConsumerSummary)object).kafka$admin$AdminClient$ConsumerSummary$$$outer() != this.kafka$admin$AdminClient$ConsumerSummary$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConsumerSummary consumerSummary = (ConsumerSummary)x$1;
            String string2 = this.memberId();
            String string3 = consumerSummary.memberId();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            String string4 = this.clientId();
            String string5 = consumerSummary.clientId();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            String string6 = this.clientHost();
            String string7 = consumerSummary.clientHost();
            if (string6 == null) {
                if (string7 != null) {
                    return false;
                }
            } else if (!string6.equals(string7)) return false;
            List<TopicPartition> list2 = this.assignment();
            List<TopicPartition> list3 = consumerSummary.assignment();
            if (list2 == null) {
                if (list3 != null) {
                    return false;
                }
            } else if (!((Object)list2).equals(list3)) return false;
            if (!consumerSummary.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ AdminClient kafka$admin$AdminClient$ConsumerSummary$$$outer() {
            return this.$outer;
        }

        public ConsumerSummary(AdminClient $outer, String memberId, String clientId, String clientHost, List<TopicPartition> assignment) {
            this.memberId = memberId;
            this.clientId = clientId;
            this.clientHost = clientHost;
            this.assignment = assignment;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product$class.$init$(this);
        }
    }
}

