/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class MainHelper {
    public static final String argFilePrefix = "scala-maven-";
    public static final String argFileSuffix = ".args";

    public static String toMultiPath(List<String> paths) {
        return StringUtils.join(paths.iterator(), File.pathSeparator);
    }

    public static String toMultiPath(String[] paths) {
        return StringUtils.join(paths, File.pathSeparator);
    }

    public static String[] findFiles(File dir, String pattern) {
        return MainHelper.findFiles(dir, new String[]{pattern}, new String[0]);
    }

    public static String[] findFiles(File dir, String[] includes2, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.setIncludes(includes2);
        scanner.setExcludes(excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String toClasspathString(ClassLoader cl) throws Exception {
        StringBuilder back = new StringBuilder();
        LinkedList<String> cps = new LinkedList<String>();
        MainHelper.appendUrltoClasspathCollection(cl, cps);
        for (String cp : cps) {
            if (back.length() != 0) {
                back.append(File.pathSeparatorChar);
            }
            back.append(cp);
        }
        return back.toString();
    }

    public static void appendUrltoClasspathCollection(ClassLoader cl, Collection<String> classpath) throws Exception {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls;
                URLClassLoader ucl = (URLClassLoader)cl;
                for (URL url : urls = ucl.getURLs()) {
                    classpath.add(url.getFile());
                }
            }
            cl = cl.getParent();
        }
    }

    private static String escapeArgumentForScalacArgumentFile(String arg) {
        if (arg.matches(".*\\s.*")) {
            return '\"' + arg + '\"';
        }
        return arg;
    }

    private static String unescapeArgumentForScalacArgumentFile(String arg) {
        if (arg.charAt(0) == '\"' && arg.charAt(arg.length() - 1) == '\"') {
            return arg.substring(1, arg.length() - 1);
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createArgFile(List<String> args2) throws IOException {
        File argFile = File.createTempFile(argFilePrefix, argFileSuffix);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(argFile)));
        try {
            for (String arg : args2) {
                out.println(MainHelper.escapeArgumentForScalacArgumentFile(arg));
            }
        }
        finally {
            out.close();
        }
        return argFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readArgFile(File argFile) throws IOException {
        ArrayList<String> back = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(argFile));
        try {
            String line2 = null;
            while ((line2 = in.readLine()) != null) {
                back.add(MainHelper.unescapeArgumentForScalacArgumentFile(line2));
            }
        }
        finally {
            in.close();
        }
        return back;
    }

    public static void runMain(String mainClassName, List<String> args2, ClassLoader cl) throws Exception {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Class<?> mainClass2 = cl.loadClass(mainClassName);
        Method mainMethod = mainClass2.getMethod("main", String[].class);
        int mods = mainMethod.getModifiers();
        if (mainMethod.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        String[] argArray = args2.toArray(new String[args2.size()]);
        mainMethod.invoke(null, new Object[]{argArray});
    }

    public static String locateJar(Class<?> c) throws Exception {
        String classLocation2 = c.getName().replace('.', '/') + ".class";
        ClassLoader loader2 = c.getClassLoader();
        URL location = loader2 == null ? ClassLoader.getSystemResource(classLocation2) : loader2.getResource(classLocation2);
        if (location != null) {
            Pattern p = Pattern.compile("^.*file:(.*)!.*$");
            Matcher m = p.matcher(location.toString());
            if (m.find()) {
                return URLDecoder.decode(m.group(1), "UTF-8");
            }
            throw new ClassNotFoundException("Cannot parse location of '" + location + "'.  Probably not loaded from a Jar");
        }
        throw new ClassNotFoundException("Cannot find class '" + c.getName() + " using the classloader");
    }
}

