/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.JavaMainCaller;

public abstract class JavaMainCallerSupport
implements JavaMainCaller {
    protected AbstractMojo requester;
    protected List<String> env = new ArrayList<String>();
    protected String mainClassName;
    protected List<String> jvmArgs = new ArrayList<String>();
    protected List<String> args = new ArrayList<String>();

    protected JavaMainCallerSupport(AbstractMojo requester1, String mainClassName1, String classpath, String[] jvmArgs1, String[] args1) throws Exception {
        this.requester = requester1;
        for (String key : System.getenv().keySet()) {
            this.env.add(key + "=" + System.getenv(key));
        }
        this.mainClassName = mainClassName1;
        if (StringUtils.isNotEmpty(classpath)) {
            this.addJvmArgs("-classpath", classpath);
        }
        this.addJvmArgs(jvmArgs1);
        this.addArgs(args1);
    }

    @Override
    public void addJvmArgs(String ... args0) {
        if (args0 != null) {
            for (String arg : args0) {
                if (!StringUtils.isNotEmpty(arg)) continue;
                this.jvmArgs.add(arg);
            }
        }
    }

    public void addToClasspath(File entry2) throws Exception {
        if (entry2 == null || !entry2.exists()) {
            return;
        }
        boolean found = false;
        boolean isClasspath = false;
        for (int i = 0; i < this.jvmArgs.size(); ++i) {
            String item = this.jvmArgs.get(i);
            if (isClasspath) {
                item = item + File.pathSeparator + entry2.getCanonicalPath();
                this.jvmArgs.set(i, item);
                isClasspath = false;
                found = true;
                break;
            }
            isClasspath = "-classpath".equals(item);
        }
        if (!found) {
            this.addJvmArgs("-classpath", entry2.getCanonicalPath());
        }
    }

    @Override
    public void addOption(String key, String value2) {
        if (StringUtils.isEmpty(value2) || StringUtils.isEmpty(key)) {
            return;
        }
        this.addArgs(key, value2);
    }

    @Override
    public void addOption(String key, File value2) {
        if (value2 == null || StringUtils.isEmpty(key)) {
            return;
        }
        this.addArgs(key, value2.getAbsolutePath());
    }

    @Override
    public void addOption(String key, boolean value2) {
        if (!value2 || StringUtils.isEmpty(key)) {
            return;
        }
        this.addArgs(key);
    }

    @Override
    public void addArgs(String ... args1) {
        if (args1 != null) {
            for (String arg : args1) {
                if (!StringUtils.isNotEmpty(arg)) continue;
                this.args.add(arg);
            }
        }
    }

    @Override
    public void addEnvVar(String key, String value2) {
        this.env.add(key + "=" + value2);
    }

    @Override
    public void run(boolean displayCmd) throws Exception {
        this.run(displayCmd, true);
    }
}

