/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.strategy.SelfFirstStrategy;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.FileUtils;
import scala_maven.ScalaMojoSupport;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.MainHelper;

@Mojo(name="script", requiresDependencyResolution=ResolutionScope.RUNTIME, executionStrategy="always", threadSafe=true)
public class ScalaScriptMojo
extends ScalaMojoSupport {
    @Parameter(property="project.build.directory")
    protected File outputDir;
    @Parameter(property="scriptFile")
    protected File scriptFile;
    @Parameter(property="scriptEncoding", defaultValue="UTF-8")
    protected String scriptEncoding;
    @Parameter(property="script")
    protected String script;
    @Parameter(property="maven.scala.keepGeneratedScript", defaultValue="false")
    protected boolean keepGeneratedScript;
    @Parameter(property="maven.scala.includeScopes")
    protected String includeScopes;
    @Parameter(property="maven.scala.excludeScopes")
    protected String excludeScopes;
    @Parameter(property="addToClasspath")
    protected String addToClasspath;
    @Parameter(property="removeFromClasspath")
    protected String removeFromClasspath;
    private static AtomicInteger _lastScriptIndex = new AtomicInteger(0);

    private static String scriptBaseNameOf(File scriptFile, int idx) {
        if (scriptFile == null) {
            return "embeddedScript_" + idx;
        }
        int dot = scriptFile.getName().lastIndexOf(46);
        if (dot == -1) {
            return scriptFile.getName() + "_" + idx;
        }
        return scriptFile.getName().substring(0, dot) + "_" + idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        if (this.script == null && this.scriptFile == null) {
            throw new MojoFailureException("Either script or scriptFile must be defined");
        }
        if (this.script != null && this.scriptFile != null) {
            throw new MojoFailureException("Only one of script or scriptFile can be defined");
        }
        if (StringUtils.isEmpty(this.includeScopes)) {
            this.includeScopes = this.scriptFile != null ? "compile, test, runtime" : "plugin";
        }
        if (this.excludeScopes == null) {
            this.excludeScopes = "";
        }
        File scriptDir = new File(this.outputDir, ".scalaScriptGen");
        scriptDir.mkdirs();
        String baseName = ScalaScriptMojo.scriptBaseNameOf(this.scriptFile, _lastScriptIndex.incrementAndGet());
        File destFile = new File(scriptDir, baseName + ".scala");
        HashSet<String> classpath = new HashSet<String>();
        this.configureClasspath(classpath);
        boolean mavenProjectDependency = this.includeScopes.contains("plugin");
        this.wrapScript(destFile, mavenProjectDependency);
        try {
            URLClassLoader loader2 = this.createScriptClassloader(scriptDir, classpath);
            this.getLog().debug("classpath : " + Arrays.asList(loader2.getURLs()));
            this.compileScript(scriptDir, destFile, loader2);
            this.runScript(mavenProjectDependency, loader2, baseName);
        }
        finally {
            if (!this.keepGeneratedScript) {
                this.delete(scriptDir);
            }
        }
    }

    private void runScript(boolean mavenProjectDependency, URLClassLoader loader2, String baseName) throws Exception {
        Class<?> compiledScript = loader2.loadClass(baseName);
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader2);
        try {
            try {
                Object instance;
                if (mavenProjectDependency) {
                    Constructor<?> constructor = compiledScript.getConstructor(MavenProject.class, MavenSession.class, Log.class);
                    instance = constructor.newInstance(this.project, this.session, this.getLog());
                } else {
                    instance = compiledScript.newInstance();
                }
                try {
                    compiledScript.getMethod("run", new Class[0]).invoke(instance, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
            catch (ExceptionInInitializerError e) {
                if (e.getException() != null) {
                    throw e.getException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception("A " + e.getClass().getSimpleName() + " exception was thrown", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
        }
    }

    private URLClassLoader createScriptClassloader(File scriptDir, Set<String> classpath) throws Exception {
        ClassWorld w = new ClassWorld("zero", null);
        w.newRealm("mojo", this.getClass().getClassLoader());
        SelfFirstStrategy s = new SelfFirstStrategy(w.newRealm("scalaScript", null));
        ClassRealm rScript = s.getRealm();
        rScript.setParentClassLoader(this.getClass().getClassLoader());
        rScript.importFrom("mojo", "org.apache.maven");
        rScript.addURL(scriptDir.toURI().toURL());
        for (String string2 : classpath) {
            rScript.addURL(new File(string2).toURI().toURL());
        }
        return rScript;
    }

    private void compileScript(File scriptDir, File destFile, URLClassLoader loader2) throws Exception {
        JavaMainCaller jcmd = this.getScalaCommand();
        jcmd.addArgs("-classpath", MainHelper.toClasspathString(loader2));
        jcmd.addArgs("-d", scriptDir.getAbsolutePath());
        jcmd.addArgs("-sourcepath", scriptDir.getAbsolutePath());
        jcmd.addArgs(destFile.getAbsolutePath());
        jcmd.run(this.displayCmd);
    }

    private void configureClasspath(Set<String> classpath) throws Exception, DependencyResolutionRequiredException {
        TreeSet<String> includes2 = new TreeSet<String>(Arrays.asList(StringUtils.split(this.includeScopes.toLowerCase(), ",")));
        TreeSet<String> excludes = new TreeSet<String>(Arrays.asList(StringUtils.split(this.excludeScopes.toLowerCase(), ",")));
        for (Artifact a : this.project.getArtifacts()) {
            if (!includes2.contains(a.getScope().toLowerCase()) || excludes.contains(a.getScope())) continue;
            this.addToClasspath(a, classpath, true);
        }
        if (includes2.contains("plugin") && !excludes.contains("plugin")) {
            for (Plugin p : this.project.getBuildPlugins()) {
                if (!"scala-maven-plugin".equals(p.getArtifactId())) continue;
                for (Dependency d : p.getDependencies()) {
                    this.addToClasspath(this.factory.createDependencyArtifact(d), classpath, true);
                }
            }
            for (Artifact a : this.project.getPluginArtifacts()) {
                if (!"scala-maven-plugin".equals(a.getArtifactId())) continue;
                this.addToClasspath(a, classpath, true);
            }
        }
        if (this.addToClasspath != null) {
            classpath.addAll(Arrays.asList(StringUtils.split(this.addToClasspath, ",")));
        }
        if (this.removeFromClasspath != null) {
            ArrayList<String> toRemove = new ArrayList<String>();
            String[] jars = StringUtils.split(this.removeFromClasspath.trim(), ",");
            for (String string2 : classpath) {
                for (String jar : jars) {
                    if (!string2.contains(jar.trim())) continue;
                    toRemove.add(string2);
                }
            }
            classpath.removeAll(toRemove);
        }
        this.addCompilerToClasspath(classpath);
        this.addLibraryToClasspath(classpath);
        boolean ok = true;
        for (String s : classpath) {
            File f2 = new File(s);
            this.getLog().debug("classpath entry for running and compiling scripts: " + f2);
            if (f2.exists()) continue;
            this.getLog().error("classpath entry for script not found : " + f2);
            ok = false;
        }
        if (!ok) {
            throw new MojoFailureException("some script dependencies not found (see log)");
        }
        this.getLog().debug("Using the following classpath for running and compiling scripts: " + classpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapScript(File destFile, boolean mavenProjectDependency) throws IOException {
        destFile.delete();
        FileOutputStream fileOutputStream2 = new FileOutputStream(destFile);
        PrintStream out = new PrintStream((OutputStream)fileOutputStream2, false, this.encoding);
        BufferedReader reader = null;
        try {
            reader = this.scriptFile != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.scriptFile), Charset.forName(this.scriptEncoding))) : new BufferedReader(new StringReader(this.script));
            String baseName = FileUtils.basename(destFile.getName(), ".scala");
            if (mavenProjectDependency) {
                out.println("class " + baseName + "(project :" + MavenProject.class.getCanonicalName() + ",session :" + MavenSession.class.getCanonicalName() + ",log :" + Log.class.getCanonicalName() + ") {");
            } else {
                out.println("class " + baseName + " {");
            }
            String line2 = reader.readLine();
            while (line2 != null) {
                out.print("  ");
                out.println(line2);
                line2 = reader.readLine();
            }
            out.println("}");
        }
        catch (Throwable throwable2) {
            IOUtil.close(out);
            IOUtil.close(fileOutputStream2);
            IOUtil.close(reader);
            throw throwable2;
        }
        IOUtil.close(out);
        IOUtil.close(fileOutputStream2);
        IOUtil.close(reader);
    }

    private void delete(File scriptDir) {
        if (scriptDir.isDirectory()) {
            for (File file : scriptDir.listFiles()) {
                this.delete(file);
            }
        }
        scriptDir.deleteOnExit();
        scriptDir.delete();
    }
}

