/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala_maven.FileUtils;
import scala_maven.ScalaCompilerSupport;
import scala_maven.TychoUtilities;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ScalaCompileMojo
extends ScalaCompilerSupport {
    @Parameter(property="project.build.outputDirectory")
    protected File outputDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala")
    protected File sourceDir;
    @Parameter(property="analysisCacheFile", defaultValue="${project.build.directory}/analysis/compile")
    protected File analysisCacheFile;

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        List<String> sources = this.project.getCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = FileUtils.pathOf(this.sourceDir, this.useCanonicalPath))) {
            sources = new LinkedList<String>(sources);
            sources.add(scalaSourceDir);
        }
        return this.normalize(sources);
    }

    @Override
    protected List<String> getClasspathElements() throws Exception {
        List<String> back = this.project.getCompileClasspathElements();
        back.remove(this.project.getBuild().getOutputDirectory());
        back = TychoUtilities.addOsgiClasspathElements(this.project, back);
        return back;
    }

    @Override
    @Deprecated
    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    @Override
    protected File getOutputDir() throws Exception {
        return this.outputDir.getAbsoluteFile();
    }

    @Override
    protected File getAnalysisCacheFile() throws Exception {
        return this.analysisCacheFile.getAbsoluteFile();
    }
}

