/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import scala_maven.FileUtils;

@Mojo(name="add-source", executionStrategy="always", defaultPhase=LifecyclePhase.INITIALIZE, requiresDirectInvocation=false, threadSafe=true)
public class AddSourceMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala")
    protected File sourceDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala")
    protected File testSourceDir;
    @Parameter(property="maven.scala.useCanonicalPath", defaultValue="true")
    protected boolean useCanonicalPath = true;

    @Override
    public void execute() throws MojoExecutionException {
        try {
            String path2;
            if (this.sourceDir != null) {
                path2 = FileUtils.pathOf(this.sourceDir, this.useCanonicalPath);
                if (!this.project.getCompileSourceRoots().contains(path2)) {
                    this.getLog().info("Add Source directory: " + path2);
                    this.project.addCompileSourceRoot(path2);
                }
            }
            if (this.testSourceDir != null) {
                path2 = FileUtils.pathOf(this.testSourceDir, this.useCanonicalPath);
                if (!this.project.getTestCompileSourceRoots().contains(path2)) {
                    this.getLog().info("Add Test Source directory: " + path2);
                    this.project.addTestCompileSourceRoot(path2);
                }
            }
        }
        catch (Exception exc) {
            this.getLog().warn(exc);
        }
    }
}

