/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline_embedded.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import scala.tools.jline_embedded.internal.Configuration;
import scala.tools.jline_embedded.internal.Preconditions;
import scala.tools.jline_embedded.internal.TestAccessible;

public final class Log {
    public static final boolean TRACE = Configuration.getBoolean(Log.class.getName() + ".trace");
    public static final boolean DEBUG = TRACE || Configuration.getBoolean(Log.class.getName() + ".debug");
    private static PrintStream output = System.err;
    private static boolean useJul = Configuration.getBoolean("scala.tools.jline_embedded.log.jul");

    public static PrintStream getOutput() {
        return output;
    }

    public static void setOutput(PrintStream out) {
        output = Preconditions.checkNotNull(out);
    }

    @TestAccessible
    static void render(PrintStream out, Object message) {
        if (message.getClass().isArray()) {
            Object[] array2 = (Object[])message;
            out.print("[");
            for (int i = 0; i < array2.length; ++i) {
                out.print(array2[i]);
                if (i + 1 >= array2.length) continue;
                out.print(",");
            }
            out.print("]");
        } else {
            out.print(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestAccessible
    static void log(Level level, Object ... messages2) {
        if (useJul) {
            Log.logWithJul(level, messages2);
            return;
        }
        PrintStream printStream = output;
        synchronized (printStream) {
            output.format("[%s] ", new Object[]{level});
            for (int i = 0; i < messages2.length; ++i) {
                if (i + 1 == messages2.length && messages2[i] instanceof Throwable) {
                    output.println();
                    ((Throwable)messages2[i]).printStackTrace(output);
                    continue;
                }
                Log.render(output, messages2[i]);
            }
            output.println();
            output.flush();
        }
    }

    static void logWithJul(Level level, Object ... messages2) {
        Logger logger = Logger.getLogger("jline");
        Throwable cause = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        for (int i = 0; i < messages2.length; ++i) {
            if (i + 1 == messages2.length && messages2[i] instanceof Throwable) {
                cause = (Throwable)messages2[i];
                continue;
            }
            Log.render(ps, messages2[i]);
        }
        ps.close();
        LogRecord r = new LogRecord(Log.toJulLevel(level), baos.toString());
        r.setThrown(cause);
        logger.log(r);
    }

    private static java.util.logging.Level toJulLevel(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.FINEST;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void trace(Object ... messages2) {
        if (TRACE) {
            Log.log(Level.TRACE, messages2);
        }
    }

    public static void debug(Object ... messages2) {
        if (TRACE || DEBUG) {
            Log.log(Level.DEBUG, messages2);
        }
    }

    public static void info(Object ... messages2) {
        Log.log(Level.INFO, messages2);
    }

    public static void warn(Object ... messages2) {
        Log.log(Level.WARN, messages2);
    }

    public static void error(Object ... messages2) {
        Log.log(Level.ERROR, messages2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

