/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.IncOptions;
import com.typesafe.zinc.Inputs;
import com.typesafe.zinc.Setup;
import com.typesafe.zinc.ZincClient;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import sbt.compiler.CompileFailed;
import sbt_inc.SbtLogger;
import scala.Option;
import scala_maven_executions.MainHelper;
import util.JavaLocator;
import xsbti.Logger;
import xsbti.Problem;

public class SbtIncrementalCompiler {
    public static final String SBT_GROUP_ID = "com.typesafe.sbt";
    public static final String COMPILER_INTEGRATION_ARTIFACT_ID = "incremental-compiler";
    public static final String COMPILER_INTERFACE_ARTIFACT_ID = "compiler-interface";
    public static final String COMPILER_INTERFACE_CLASSIFIER = "sources";
    public static final String XSBTI_ARTIFACT_ID = "sbt-interface";
    private static final String ANALYSIS_MAP_ARG_SEPARATOR = ",";
    private static final String ANALYSIS_MAP_PAIR_SEPARATOR = File.pathSeparator;
    private Log log;
    private ZincClient zinc;
    private boolean useServer = false;
    private File compilerJar;
    private File libraryJar;
    private List<File> extraJars;
    private List<String> extraArgs;
    private Logger logger;
    private Compiler compiler;

    public SbtIncrementalCompiler(boolean useZincServer, String zincHost, int zincPort, File libraryJar, File compilerJar, List<File> extraJars, File xsbtiJar, File interfaceJar, Log l, List<String> args2) throws Exception {
        this.log = l;
        if (useZincServer) {
            this.zinc = new ZincClient(zincHost, zincPort);
            if (this.zinc.serverAvailable()) {
                l.info("Using zinc server for incremental compilation");
                this.useServer = true;
                this.compilerJar = compilerJar;
                this.libraryJar = libraryJar;
                this.extraJars = extraJars;
                this.extraArgs = args2;
            } else {
                l.warn("Zinc server is not available at port " + zincPort + " - reverting to normal incremental compile");
                this.useServer = false;
            }
        }
        if (!this.useServer) {
            l.info("Using incremental compilation");
            if (args2.size() > 0) {
                l.warn("extra args for zinc are ignored in non-server mode");
            }
            this.logger = new SbtLogger(l);
            Setup setup = Setup.create(compilerJar, libraryJar, extraJars, xsbtiJar, interfaceJar, null, false);
            if (l.isDebugEnabled()) {
                Setup.debug(setup, this.logger);
            }
            this.compiler = Compiler.create(setup, this.logger);
        }
    }

    private IncOptions defaultOptions() {
        sbt.inc.IncOptions defaultSbtOptions = sbt.inc.IncOptions.Default();
        return new IncOptions(defaultSbtOptions.transitiveStep(), defaultSbtOptions.recompileAllFraction(), defaultSbtOptions.relationsDebug(), defaultSbtOptions.apiDebug(), defaultSbtOptions.apiDiffContextSize(), defaultSbtOptions.apiDumpDirectory(), false, (Option<File>)Option.empty(), defaultSbtOptions.recompileOnMacroDef(), defaultSbtOptions.nameHashing());
    }

    public void compile(File baseDir, List<String> classpathElements, List<File> sources, File classesDirectory, List<String> scalacOptions, List<String> javacOptions, File cacheFile, Map<File, File> cacheMap, String compileOrder, Toolchain toolchain) throws Exception {
        if (this.useServer) {
            this.zincCompile(baseDir, classpathElements, sources, classesDirectory, scalacOptions, javacOptions, cacheFile, cacheMap, compileOrder, toolchain);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Incremental compiler = " + this.compiler + " [" + Integer.toHexString(this.compiler.hashCode()) + "]");
            }
            List<File> classpath = this.pathsToFiles(classpathElements);
            Inputs inputs2 = Inputs.create(classpath, sources, classesDirectory, scalacOptions, javacOptions, cacheFile, cacheMap, compileOrder, this.defaultOptions(), true);
            if (this.log.isDebugEnabled()) {
                Inputs.debug(inputs2, this.logger);
            }
            this.compiler.compile(inputs2, this.logger);
        }
    }

    private void zincCompile(File baseDir, List<String> classpathElements, List<File> sources, File classesDirectory, List<String> scalacOptions, List<String> javacOptions, File cacheFile, Map<File, File> cacheMap, String compileOrder, Toolchain toolchain) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>(this.extraArgs);
        arguments.add("-log-level");
        arguments.add(this.logLevelToString(this.log));
        arguments.add("-scala-compiler");
        arguments.add(this.compilerJar.getAbsolutePath());
        arguments.add("-scala-library");
        arguments.add(this.libraryJar.getAbsolutePath());
        arguments.add("-scala-extra");
        ArrayList<String> extraPaths = new ArrayList<String>();
        for (File file : this.extraJars) {
            extraPaths.add(file.getAbsolutePath());
        }
        arguments.add(MainHelper.toMultiPath(extraPaths));
        if (!classpathElements.isEmpty()) {
            arguments.add("-classpath");
            arguments.add(MainHelper.toMultiPath(classpathElements));
        }
        arguments.add("-d");
        arguments.add(classesDirectory.getAbsolutePath());
        for (String string2 : scalacOptions) {
            arguments.add("-S" + string2);
        }
        String javaHome = JavaLocator.findHomeFromToolchain(toolchain);
        if (javaHome != null) {
            this.log.info("Toolchain in scala-maven-plugin: " + javaHome);
            arguments.add("-java-home");
            arguments.add(javaHome);
        }
        for (String javacOption : javacOptions) {
            arguments.add("-C" + javacOption);
        }
        arguments.add("-compile-order");
        arguments.add(compileOrder);
        arguments.add("-analysis-cache");
        arguments.add(cacheFile.getAbsolutePath());
        arguments.add("-analysis-map");
        arguments.add(this.cacheMapToString(cacheMap));
        for (File source : sources) {
            arguments.add(source.getAbsolutePath());
        }
        int n = this.zinc.run(arguments, baseDir, (OutputStream)System.out, (OutputStream)System.err);
        if (n != 0) {
            Problem[] problems = null;
            throw new CompileFailed(arguments.toArray(new String[arguments.size()]), "Compile failed via zinc server", problems);
        }
    }

    private List<File> pathsToFiles(List<String> paths) {
        ArrayList<File> files2 = new ArrayList<File>(paths.size());
        for (String path2 : paths) {
            files2.add(new File(path2));
        }
        return files2;
    }

    private String logLevelToString(Log l) {
        if (l.isDebugEnabled()) {
            return "debug";
        }
        if (l.isInfoEnabled()) {
            return "info";
        }
        if (l.isWarnEnabled()) {
            return "warn";
        }
        if (l.isErrorEnabled()) {
            return "error";
        }
        return "info";
    }

    private String cacheMapToString(Map<File, File> cacheMap) throws Exception {
        String analysisMap = "";
        boolean addArgSeparator = false;
        for (Map.Entry<File, File> entry2 : cacheMap.entrySet()) {
            if (addArgSeparator) {
                analysisMap = analysisMap + ANALYSIS_MAP_ARG_SEPARATOR;
            }
            analysisMap = analysisMap + entry2.getKey().getAbsolutePath();
            analysisMap = analysisMap + ANALYSIS_MAP_PAIR_SEPARATOR;
            analysisMap = analysisMap + entry2.getValue().getAbsolutePath();
            addArgSeparator = true;
        }
        return analysisMap;
    }
}

