/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.Properties;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.AllPassFilter$;
import sbt.ErrorHandling$;
import sbt.GlobFilter$;
import sbt.IO$;
import sbt.IO$$anonfun$sbt$IO$;
import sbt.NameFilter;
import sbt.Path$;
import sbt.PathFinder;
import sbt.PathFinder$;
import sbt.Using;
import sbt.Using$;
import scala.Array$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class IO$ {
    public static final IO$ MODULE$;
    private final int MaximumTries;
    private Random random;
    private final File temporaryDirectory;
    private final int BufferSize;
    private final String FileScheme;
    private final String Newline;
    private final Charset utf8;
    private final Pattern PathSeparatorPattern;
    private volatile boolean bitmap$0;

    static {
        new IO$();
    }

    private Random random$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if (!this.bitmap$0) {
                this.random = new Random();
                this.bitmap$0 = true;
            }
            return this.random;
        }
    }

    private int MaximumTries() {
        return this.MaximumTries;
    }

    private Random random() {
        return this.bitmap$0 ? this.random : this.random$lzycompute();
    }

    public File temporaryDirectory() {
        return this.temporaryDirectory;
    }

    private int BufferSize() {
        return this.BufferSize;
    }

    public String FileScheme() {
        return this.FileScheme;
    }

    public String Newline() {
        return this.Newline;
    }

    public Charset utf8() {
        return this.utf8;
    }

    public <T> URL classLocation(Manifest<T> mf) {
        return this.classLocation(mf.runtimeClass());
    }

    public URL classLocation(Class<?> cl) {
        URL uRL;
        CodeSource codeSource = cl.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        } else {
            String clsfile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".class"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cl.getName().replace('.', '/')}));
            uRL = ((File)Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader().getResource(clsfile)).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<File> apply(URL url) {
                    return IO$.MODULE$.urlAsFile(url);
                }
            }).getOrElse((Function0)new Serializable(cl){
                public static final long serialVersionUID = 0L;
                private final Class cl$1;

                public final Nothing$ apply() {
                    return scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"No class location for ").append((Object)this.cl$1).toString());
                }
                {
                    this.cl$1 = cl$1;
                }
            })).toURI().toURL();
        }
        return uRL;
    }

    public <T> File classLocationFile(Manifest<T> mf) {
        return this.classLocationFile(mf.runtimeClass());
    }

    public File classLocationFile(Class<?> cl) {
        Option option;
        block4: {
            File file;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)cl.getProtectionDomain().getCodeSource());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    CodeSource codeSource = (CodeSource)some.x();
                    URL classURL = codeSource.getLocation();
                    file = this.toFile(classURL);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                String clsfile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".class"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cl.getName().replace('.', '/')}));
                file = (File)Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader().getResource(clsfile)).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<File> apply(URL url) {
                        return IO$.MODULE$.urlAsFile(url);
                    }
                }).getOrElse((Function0)new Serializable(cl){
                    public static final long serialVersionUID = 0L;
                    private final Class cl$2;

                    public final Nothing$ apply() {
                        return scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"No class location for ").append((Object)this.cl$2).toString());
                    }
                    {
                        this.cl$2 = cl$2;
                    }
                });
            }
            return file;
        }
        throw new MatchError((Object)option);
    }

    public <T> URL classfileLocation(Manifest<T> mf) {
        return this.classfileLocation(mf.runtimeClass());
    }

    public URL classfileLocation(Class<?> cl) {
        String clsfile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".class"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cl.getName().replace('.', '/')}));
        try {
            return (URL)((TraversableLike)scala.package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply((Object)cl.getClassLoader()), new Some((Object)ClassLoader.getSystemClassLoader())})).flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<ClassLoader> apply(Option<ClassLoader> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            }).flatMap((Function1)new Serializable(clsfile){
                public static final long serialVersionUID = 0L;
                private final String clsfile$1;

                public final Iterable<URL> apply(ClassLoader classLoader) {
                    return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)classLoader.getResource(this.clsfile$1)));
                }
                {
                    this.clsfile$1 = clsfile$1;
                }
            }, Stream$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(cl){
                public static final long serialVersionUID = 0L;
                private final Class cl$3;

                public final Nothing$ apply() {
                    return scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"No class location for ").append((Object)this.cl$3).toString());
                }
                {
                    this.cl$3 = cl$3;
                }
            });
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
            throw throwable2;
        }
    }

    public File toFile(URL url) {
        File file;
        try {
            file = this.uriToFile(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(url.getPath());
        }
        return file;
    }

    public File asFile(URL url) {
        return (File)this.urlAsFile(url).getOrElse((Function0)new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final URL url$1;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"URL is not a file: ").append((Object)this.url$1).toString());
            }
            {
                this.url$1 = url$1;
            }
        });
    }

    public Option<File> urlAsFile(URL url) {
        Object object;
        String string2 = url.getProtocol();
        String string3 = this.FileScheme();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            object = new Some((Object)this.toFile(url));
        } else {
            String path2;
            int end;
            String string5 = string2;
            object = !("jar" != null ? !"jar".equals(string5) : string5 != null) ? new Some((Object)this.uriToFile((end = (path2 = url.getPath()).indexOf(33)) == -1 ? path2 : path2.substring(0, end))) : None$.MODULE$;
        }
        return object;
    }

    private File uriToFile(String uriString) {
        return this.uriToFile(new URI(uriString));
    }

    private File uriToFile(URI uri) {
        String string2 = uri.getScheme();
        String string3 = this.FileScheme();
        Predef$.MODULE$.assert(!(string2 != null ? !string2.equals(string3) : string3 != null), (Function0)new Serializable(uri){
            public static final long serialVersionUID = 0L;
            private final URI uri$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Expected protocol to be '").append((Object)IO$.MODULE$.FileScheme()).append((Object)"' in URI ").append((Object)this.uri$1).toString();
            }
            {
                this.uri$1 = uri$1;
            }
        });
        String part = uri.getSchemeSpecificPart();
        Option option = Option$.MODULE$.apply((Object)uri.getAuthority());
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        File file = !(none$ != null ? !none$.equals(option2) : option2 != null) && part.startsWith("/") ? new File(uri) : (part.startsWith("/") ? new File(part) : new File(new StringBuilder().append((Object)"//").append((Object)part).toString()));
        return file;
    }

    public void assertDirectory(File file) {
        Predef$.MODULE$.assert(file.isDirectory(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringBuilder().append((Object)(this.file$1.exists() ? "Not a directory: " : "Directory not found: ")).append((Object)this.file$1).toString();
            }
            {
                this.file$1 = file$1;
            }
        });
    }

    public void assertDirectories(Seq<File> file) {
        file.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                IO$.MODULE$.assertDirectory(file);
            }
        });
    }

    public Tuple2<String, String> split(String name) {
        int lastDot = name.lastIndexOf(46);
        return lastDot >= 0 ? new Tuple2((Object)name.substring(0, lastDot), (Object)name.substring(lastDot + 1)) : new Tuple2((Object)name, (Object)"");
    }

    public void touch(Traversable<File> files2) {
        files2.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File f2) {
                IO$.MODULE$.touch(f2, IO$.MODULE$.touch$default$2());
            }
        });
    }

    public void touch(File file, boolean setModified) {
        File absFile = file.getAbsoluteFile();
        this.createDirectory(absFile.getParentFile());
        boolean created = BoxesRunTime.unboxToBoolean(ErrorHandling$.MODULE$.translate((Function0<String>)new Serializable(absFile){
            public static final long serialVersionUID = 0L;
            private final File absFile$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Could not create file ").append((Object)this.absFile$1).toString();
            }
            {
                this.absFile$1 = absFile$1;
            }
        }, new Serializable(absFile){
            public static final long serialVersionUID = 0L;
            private final File absFile$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.absFile$1.createNewFile();
            }
            {
                this.absFile$1 = absFile$1;
            }
        }));
        if (!created && !absFile.isDirectory() && setModified && !absFile.setLastModified(System.currentTimeMillis())) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Could not update last modified time for file ").append((Object)absFile).toString());
        }
    }

    public boolean touch$default$2() {
        return true;
    }

    public void createDirectories(Traversable<File> dirs2) {
        dirs2.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File dir) {
                IO$.MODULE$.createDirectory(dir);
            }
        });
    }

    public void createDirectory(File dir) {
        for (int tryCount = 0; !dir.exists() && !dir.mkdirs() && tryCount < 100; ++tryCount) {
        }
        if (dir.isDirectory()) {
            return;
        }
        if (dir.exists()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)this.failBase$1(dir)).append((Object)": file exists and is not a directory.").toString());
        }
        throw scala.sys.package$.MODULE$.error(this.failBase$1(dir));
    }

    public void gzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file != null ? !((Object)file).equals(file2) : file2 != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Input file cannot be the same as the output file.";
            }
        });
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final File out$1;

            public final void apply(BufferedInputStream inputStream) {
                ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(this.out$1, new Serializable(this, inputStream){
                    public static final long serialVersionUID = 0L;
                    private final BufferedInputStream inputStream$1;

                    public final void apply(BufferedOutputStream outputStream) {
                        IO$.MODULE$.gzip(this.inputStream$1, outputStream);
                    }
                    {
                        this.inputStream$1 = inputStream$1;
                    }
                });
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    public void gzip(InputStream input2, OutputStream output) {
        Using$.MODULE$.gzipOutputStream().apply(output, new Serializable(input2){
            public static final long serialVersionUID = 0L;
            private final InputStream input$1;

            public final void apply(GZIPOutputStream gzStream) {
                IO$.MODULE$.transfer(this.input$1, (OutputStream)gzStream);
            }
            {
                this.input$1 = input$1;
            }
        });
    }

    public void gunzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file != null ? !((Object)file).equals(file2) : file2 != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Input file cannot be the same as the output file.";
            }
        });
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final File out$4;

            public final void apply(BufferedInputStream inputStream) {
                ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(this.out$4, new Serializable(this, inputStream){
                    public static final long serialVersionUID = 0L;
                    private final BufferedInputStream inputStream$2;

                    public final void apply(BufferedOutputStream outputStream) {
                        IO$.MODULE$.gunzip(this.inputStream$2, outputStream);
                    }
                    {
                        this.inputStream$2 = inputStream$2;
                    }
                });
            }
            {
                this.out$4 = out$4;
            }
        });
    }

    public void gunzip(InputStream input2, OutputStream output) {
        Using$.MODULE$.gzipInputStream().apply(input2, new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final OutputStream output$1;

            public final void apply(GZIPInputStream gzStream) {
                IO$.MODULE$.transfer((InputStream)gzStream, this.output$1);
            }
            {
                this.output$1 = output$1;
            }
        });
    }

    public scala.collection.immutable.Set<File> unzip(File from, File toDirectory, NameFilter filter2, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, new Serializable(toDirectory, filter2, preserveLastModified){
            public static final long serialVersionUID = 0L;
            private final File toDirectory$1;
            private final NameFilter filter$1;
            private final boolean preserveLastModified$1;

            public final scala.collection.immutable.Set<File> apply(BufferedInputStream in) {
                return IO$.MODULE$.unzipStream(in, this.toDirectory$1, this.filter$1, this.preserveLastModified$1);
            }
            {
                this.toDirectory$1 = toDirectory$1;
                this.filter$1 = filter$1;
                this.preserveLastModified$1 = preserveLastModified$1;
            }
        });
    }

    public NameFilter unzip$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzip$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipURL(URL from, File toDirectory, NameFilter filter2, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)Using$.MODULE$.urlInputStream().apply(from, new Serializable(toDirectory, filter2, preserveLastModified){
            public static final long serialVersionUID = 0L;
            private final File toDirectory$3;
            private final NameFilter filter$3;
            private final boolean preserveLastModified$3;

            public final scala.collection.immutable.Set<File> apply(BufferedInputStream in) {
                return IO$.MODULE$.unzipStream(in, this.toDirectory$3, this.filter$3, this.preserveLastModified$3);
            }
            {
                this.toDirectory$3 = toDirectory$3;
                this.filter$3 = filter$3;
                this.preserveLastModified$3 = preserveLastModified$3;
            }
        });
    }

    public NameFilter unzipURL$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipURL$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipStream(InputStream from, File toDirectory, NameFilter filter2, boolean preserveLastModified) {
        this.createDirectory(toDirectory);
        return (scala.collection.immutable.Set)Using$.MODULE$.zipInputStream().apply(from, new Serializable(toDirectory, filter2, preserveLastModified){
            public static final long serialVersionUID = 0L;
            private final File toDirectory$2;
            private final NameFilter filter$2;
            private final boolean preserveLastModified$2;

            public final scala.collection.immutable.Set<File> apply(ZipInputStream zipInput) {
                return IO$.MODULE$.sbt$IO$$extract(zipInput, this.toDirectory$2, this.filter$2, this.preserveLastModified$2);
            }
            {
                this.toDirectory$2 = toDirectory$2;
                this.filter$2 = filter$2;
                this.preserveLastModified$2 = preserveLastModified$2;
            }
        });
    }

    public NameFilter unzipStream$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipStream$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> sbt$IO$$extract(ZipInputStream from, File toDirectory, NameFilter filter2, boolean preserveLastModified) {
        HashSet set2 = new HashSet();
        this.next$1(from, toDirectory, filter2, preserveLastModified, set2);
        return (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)set2);
    }

    public void download(URL url, File to) {
        Using$.MODULE$.urlInputStream().apply(url, new Serializable(to){
            public static final long serialVersionUID = 0L;
            private final File to$1;

            public final void apply(BufferedInputStream inputStream) {
                IO$.MODULE$.transfer((InputStream)inputStream, this.to$1);
            }
            {
                this.to$1 = to$1;
            }
        });
    }

    public void transfer(File in, File out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final File out$3;

            public final void apply(BufferedInputStream in) {
                IO$.MODULE$.transfer((InputStream)in, this.out$3);
            }
            {
                this.out$3 = out$3;
            }
        });
    }

    public void transfer(File in, OutputStream out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final OutputStream out$2;

            public final void apply(BufferedInputStream in) {
                IO$.MODULE$.transfer((InputStream)in, this.out$2);
            }
            {
                this.out$2 = out$2;
            }
        });
    }

    public void transfer(InputStream in, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;

            public final void apply(BufferedOutputStream outputStream) {
                IO$.MODULE$.transfer(this.in$1, (OutputStream)outputStream);
            }
            {
                this.in$1 = in$1;
            }
        });
    }

    public void transfer(InputStream in, OutputStream out) {
        this.transferImpl(in, out, false);
    }

    public void transferAndClose(InputStream in, OutputStream out) {
        this.transferImpl(in, out, true);
    }

    private void transferImpl(InputStream in, OutputStream out, boolean close2) {
        try {
            byte[] buffer = new byte[this.BufferSize()];
            this.read$1(in, out, buffer);
            return;
        }
        finally {
            if (close2) {
                in.close();
            }
        }
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action2) {
        File dir = this.createTemporaryDirectory();
        try {
            return (T)action2.apply((Object)dir);
        }
        finally {
            this.delete(dir);
        }
    }

    public File createTemporaryDirectory() {
        return this.createUniqueDirectory(this.temporaryDirectory());
    }

    public File createUniqueDirectory(File baseDirectory) {
        return this.create$1(0, baseDirectory);
    }

    public <T> T withTemporaryFile(String prefix, String postfix, Function1<File, T> action2) {
        File file = File.createTempFile(prefix, postfix);
        try {
            return (T)action2.apply((Object)file);
        }
        finally {
            file.delete();
        }
    }

    public Iterable<File> jars(File dir) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(dir, GlobFilter$.MODULE$.apply("*.jar")));
    }

    public void deleteIfEmpty(Set<File> dirs2) {
        HashMap isEmpty2 = new HashMap();
        dirs2.foreach((Function1)new Serializable(dirs2, isEmpty2){
            public static final long serialVersionUID = 0L;
            private final Set dirs$1;
            private final HashMap isEmpty$1;

            public final boolean apply(File f2) {
                return IO$.MODULE$.sbt$IO$$visit$1(f2, this.dirs$1, this.isEmpty$1);
            }
            {
                this.dirs$1 = dirs$1;
                this.isEmpty$1 = isEmpty$1;
            }
        });
        isEmpty2.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<File, Object> check$ifrefutable$1) {
                boolean bl;
                Tuple2<File, Object> tuple2 = check$ifrefutable$1;
                boolean bl2 = tuple2 != null && true == (bl = tuple2._2$mcZ$sp());
                return bl2;
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<File, Object> x$1) {
                Tuple2<File, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    File f2 = (File)tuple2._1();
                    boolean bl = tuple2._2$mcZ$sp();
                    if (bl) {
                        boolean bl2 = f2.delete();
                        return bl2;
                    }
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void delete(Iterable<File> files2) {
        files2.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                IO$.MODULE$.delete(file);
            }
        });
    }

    public void deleteFilesEmptyDirs(Iterable<File> files2) {
        this.delete(files2);
        this.deleteEmpty$1(this.parents$1(files2.toSet()));
    }

    public void delete(File file) {
        ErrorHandling$.MODULE$.translate((Function0<String>)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Error deleting file ").append((Object)this.file$2).append((Object)": ").toString();
            }
            {
                this.file$2 = file$2;
            }
        }, new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final Object apply() {
                Object object;
                boolean deleted = this.file$2.delete();
                if (!deleted && this.file$2.isDirectory()) {
                    IO$.MODULE$.delete((Iterable<File>)Predef$.MODULE$.wrapRefArray((Object[])IO$.MODULE$.listFiles(this.file$2)));
                    object = BoxesRunTime.boxToBoolean((boolean)this.file$2.delete());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.file$2 = file$2;
            }
        });
    }

    public File[] listFiles(FileFilter filter2, File dir) {
        return this.wrapNull(dir.listFiles(filter2));
    }

    public File[] listFiles(File dir, FileFilter filter2) {
        return this.wrapNull(dir.listFiles(filter2));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        return a == null ? new File[]{} : a;
    }

    public void jar(Traversable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest2) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)new Some((Object)manifest2));
    }

    public void zip(Traversable<Tuple2<File, String>> sources, File outputZip) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$);
    }

    private void archive(Seq<Tuple2<File, String>> sources, File outputFile, Option<java.util.jar.Manifest> manifest2) {
        if (outputFile.isDirectory()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Specified output file ").append((Object)outputFile).append((Object)" is a directory.").toString());
        }
        File outputDir = outputFile.getParentFile();
        this.createDirectory(outputDir);
        this.withZipOutput(outputFile, manifest2, (Function1<ZipOutputStream, BoxedUnit>)new Serializable(sources, manifest2){
            public static final long serialVersionUID = 0L;
            private final Seq sources$1;
            private final Option manifest$1;

            public final void apply(ZipOutputStream output) {
                Object createEntry = this.manifest$1.isDefined() ? new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JarEntry apply(String x$3) {
                        return new JarEntry(x$3);
                    }
                } : new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ZipEntry apply(String x$4) {
                        return new ZipEntry(x$4);
                    }
                };
                IO$.MODULE$.sbt$IO$$writeZip((Seq<Tuple2<File, String>>)this.sources$1, output, (Function1<String, ZipEntry>)createEntry);
            }
            {
                this.sources$1 = sources$1;
                this.manifest$1 = manifest$1;
            }
        });
    }

    public void sbt$IO$$writeZip(Seq<Tuple2<File, String>> sources, ZipOutputStream output, Function1<String, ZipEntry> createEntry) {
        Seq files2 = (Seq)sources.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<File, String>> apply(Tuple2<File, String> x0$1) {
                Tuple2<File, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    Nil$ nil$;
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    if (file.isFile()) {
                        Tuple2 tuple22 = new Tuple2((Object)file, (Object)IO$.MODULE$.sbt$IO$$normalizeName(name));
                        nil$ = Nil$.MODULE$.$colon$colon((Object)tuple22);
                    } else {
                        nil$ = Nil$.MODULE$;
                    }
                    Nil$ nil$2 = nil$;
                    return nil$2;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        long now = System.currentTimeMillis();
        long emptyCRC = new CRC32().getValue();
        this.allDirectoryPaths((Iterable<Tuple2<File, String>>)files2).foreach((Function1)new Serializable(output, createEntry, now, emptyCRC){
            public static final long serialVersionUID = 0L;
            private final ZipOutputStream output$2;
            private final Function1 createEntry$1;
            private final long now$1;
            private final long emptyCRC$1;

            public final void apply(String name) {
                IO$.MODULE$.sbt$IO$$addDirectoryEntry$1(name, this.output$2, this.createEntry$1, this.now$1, this.emptyCRC$1);
            }
            {
                this.output$2 = output$2;
                this.createEntry$1 = createEntry$1;
                this.now$1 = now$1;
                this.emptyCRC$1 = emptyCRC$1;
            }
        });
        files2.foreach((Function1)new Serializable(output, createEntry){
            public static final long serialVersionUID = 0L;
            private final ZipOutputStream output$2;
            private final Function1 createEntry$1;

            public final void apply(Tuple2<File, String> x0$3) {
                Tuple2<File, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    IO$.MODULE$.sbt$IO$$addFileEntry$1(file, name, this.output$2, this.createEntry$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$2 = output$2;
                this.createEntry$1 = createEntry$1;
            }
        });
    }

    private List<String> relativeComponents(String path2) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])path2.split("/")).toList().dropRight(1);
    }

    private List<String> directories(List<String> path2) {
        return (List)path2.foldLeft((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(List<String> e, String l) {
                String string2 = new StringBuilder().append((Object)((String)e.head())).append((Object)l).append((Object)"/").toString();
                return e.$colon$colon((Object)string2);
            }
        });
    }

    public List<String> sbt$IO$$directoryPaths(String path2) {
        return (List)this.directories(this.relativeComponents(path2)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return x$7.length() > 1;
            }
        });
    }

    private TreeSet<String> allDirectoryPaths(Iterable<Tuple2<File, String>> files2) {
        return (TreeSet)TreeSet$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.String$.MODULE$).$plus$plus((GenTraversableOnce)files2.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(Tuple2<File, String> x0$2) {
                Tuple2<File, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._2();
                    List<String> list2 = IO$.MODULE$.sbt$IO$$directoryPaths(name);
                    return list2;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    private String normalizeDirName(String name) {
        String norm1 = this.sbt$IO$$normalizeName(name);
        return norm1.endsWith("/") ? norm1 : new StringBuilder().append((Object)norm1).append((Object)"/").toString();
    }

    public String sbt$IO$$normalizeName(String name) {
        char sep = File.separatorChar;
        return sep == '/' ? name : name.replace(sep, '/');
    }

    private void withZipOutput(File file, Option<java.util.jar.Manifest> manifest2, Function1<ZipOutputStream, BoxedUnit> f2) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(file, new Serializable(manifest2, f2){
            public static final long serialVersionUID = 0L;
            private final Option manifest$2;
            private final Function1 f$2;

            public final void apply(BufferedOutputStream fileOut) {
                ZipOutputStream zipOut;
                Option option;
                block9: {
                    Tuple2 tuple2;
                    block8: {
                        block7: {
                            option = this.manifest$2;
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            java.util.jar.Manifest mf = (java.util.jar.Manifest)some.x();
                            Attributes main2 = mf.getMainAttributes();
                            Object object = main2.containsKey(Attributes.Name.MANIFEST_VERSION) ? BoxedUnit.UNIT : main2.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                            tuple2 = new Tuple2((Object)new JarOutputStream((OutputStream)fileOut, mf), (Object)"jar");
                            break block8;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                        tuple2 = new Tuple2((Object)new ZipOutputStream(fileOut), (Object)"zip");
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        ZipOutputStream zipOut2 = (ZipOutputStream)tuple22._1();
                        String ext = (String)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)zipOut2, (Object)ext);
                        zipOut = (ZipOutputStream)tuple24._1();
                        String ext2 = (String)tuple24._2();
                        this.f$2.apply((Object)zipOut);
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)option);
                finally {
                    zipOut.close();
                }
            }
            {
                this.manifest$2 = manifest$2;
                this.f$2 = f$2;
            }
        });
    }

    public Option<File> relativizeFile(File base, File file) {
        return this.relativize(base, file).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String path2) {
                return new File(path2);
            }
        });
    }

    public Option<String> relativize(File base, File file) {
        String pathString = file.getAbsolutePath();
        return this.baseFileString(base).flatMap((Function1)new Serializable(pathString){
            public static final long serialVersionUID = 0L;
            private final String pathString$1;

            public final Option<String> apply(String baseString) {
                return this.pathString$1.startsWith(baseString) ? new Some((Object)this.pathString$1.substring(baseString.length())) : None$.MODULE$;
            }
            {
                this.pathString$1 = pathString$1;
            }
        });
    }

    private Option<String> baseFileString(File baseFile) {
        None$ none$;
        if (baseFile.isDirectory()) {
            String cp = baseFile.getAbsolutePath();
            Predef$.MODULE$.assert(cp.length() > 0);
            String normalized = cp.charAt(cp.length() - 1) == File.separatorChar ? cp : new StringBuilder().append((Object)cp).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).toString();
            none$ = new Some((Object)normalized);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public scala.collection.immutable.Set<File> copy(Traversable<Tuple2<File, File>> sources, boolean overwrite, boolean preserveLastModified) {
        return ((TraversableOnce)sources.map(Function$.MODULE$.tupled((Function2)new Serializable(overwrite, preserveLastModified){
            public static final long serialVersionUID = 0L;
            private final boolean overwrite$1;
            private final boolean preserveLastModified$5;

            public final File apply(File from, File to) {
                return IO$.MODULE$.sbt$IO$$copyImpl(this.overwrite$1, this.preserveLastModified$5, from, to);
            }
            {
                this.overwrite$1 = overwrite$1;
                this.preserveLastModified$5 = preserveLastModified$5;
            }
        }), Traversable$.MODULE$.canBuildFrom())).toSet();
    }

    public boolean copy$default$2() {
        return false;
    }

    public boolean copy$default$3() {
        return false;
    }

    public File sbt$IO$$copyImpl(boolean overwrite, boolean preserveLastModified, File from, File to) {
        if (overwrite || !to.exists() || from.lastModified() > to.lastModified()) {
            if (from.isDirectory()) {
                this.createDirectory(to);
            } else {
                this.createDirectory(to.getParentFile());
                this.copyFile(from, to, preserveLastModified);
            }
        }
        return to;
    }

    public void copyDirectory(File source, File target, boolean overwrite, boolean preserveLastModified) {
        PathFinder qual$1 = PathFinder$.MODULE$.apply(source).$times$times$times();
        Function1<File, Option<File>> x$16 = Path$.MODULE$.rebase(source, target);
        boolean x$17 = qual$1.pair$default$2();
        this.copy((Traversable<Tuple2<File, File>>)qual$1.pair(x$16, x$17), overwrite, preserveLastModified);
    }

    public boolean copyDirectory$default$3() {
        return false;
    }

    public boolean copyDirectory$default$4() {
        return false;
    }

    public void copyFile(File sourceFile2, File targetFile, boolean preserveLastModified) {
        Predef$.MODULE$.require(sourceFile2.exists(), (Function0)new Serializable(sourceFile2){
            public static final long serialVersionUID = 0L;
            private final File sourceFile$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Source file '").append((Object)this.sourceFile$1.getAbsolutePath()).append((Object)"' does not exist.").toString();
            }
            {
                this.sourceFile$1 = sourceFile$1;
            }
        });
        Predef$.MODULE$.require(!sourceFile2.isDirectory(), (Function0)new Serializable(sourceFile2){
            public static final long serialVersionUID = 0L;
            private final File sourceFile$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Source file '").append((Object)this.sourceFile$1.getAbsolutePath()).append((Object)"' is a directory.").toString();
            }
            {
                this.sourceFile$1 = sourceFile$1;
            }
        });
        ((Using)((Object)Using$.MODULE$.fileInputChannel())).apply(sourceFile2, new Serializable(sourceFile2, targetFile){
            public static final long serialVersionUID = 0L;
            public final File sourceFile$1;
            public final File targetFile$1;

            public final void apply(FileChannel in) {
                ((Using)((Object)Using$.MODULE$.fileOutputChannel())).apply(this.targetFile$1, new Serializable(this, in){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.copyFile.3 $outer;
                    private final FileChannel in$3;

                    public final void apply(FileChannel out) {
                        int max2 = 67076096;
                        long total2 = this.in$3.size();
                        long copied = this.loop$1(0L, out, max2, total2);
                        if (copied != this.in$3.size()) {
                            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Could not copy '").append((Object)this.$outer.sourceFile$1).append((Object)"' to '").append((Object)this.$outer.targetFile$1).append((Object)"' (").append((Object)BoxesRunTime.boxToLong((long)copied)).append((Object)"/").append((Object)BoxesRunTime.boxToLong((long)this.in$3.size())).append((Object)" bytes copied)").toString());
                        }
                    }

                    private final long loop$1(long offset, FileChannel out$6, int max$1, long total$1) {
                        while (offset < total$1) {
                            offset += out$6.transferFrom(this.in$3, offset, max$1);
                        }
                        return offset;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.in$3 = in$3;
                    }
                });
            }
            {
                this.sourceFile$1 = sourceFile$1;
                this.targetFile$1 = targetFile$1;
            }
        });
        if (preserveLastModified) {
            this.copyLastModified(sourceFile2, targetFile);
        }
    }

    public boolean copyFile$default$3() {
        return false;
    }

    public boolean copyLastModified(File sourceFile2, File targetFile) {
        long last = sourceFile2.lastModified();
        return targetFile.setLastModified(package$.MODULE$.max(last, 0L));
    }

    public Charset defaultCharset() {
        return this.utf8();
    }

    public void write(File file, String content, Charset charset, boolean append2) {
        this.writer(file, content, charset, append2, (Function1)new Serializable(content){
            public static final long serialVersionUID = 0L;
            private final String content$1;

            public final void apply(BufferedWriter x$9) {
                x$9.write(this.content$1);
            }
            {
                this.content$1 = content$1;
            }
        });
    }

    public <T> T writer(File file, String content, Charset charset, boolean append2, Function1<BufferedWriter, T> f2) {
        if (charset.newEncoder().canEncode(content)) {
            return ((Using)((Object)Using$.MODULE$.fileWriter(charset, append2))).apply(file, f2);
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"String cannot be encoded by charset ").append((Object)charset.name()).toString());
    }

    public <T> T reader(File file, Charset charset, Function1<BufferedReader, T> f2) {
        return ((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, f2);
    }

    public String read(File file, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        this.transfer(file, (OutputStream)out);
        return out.toString(charset.name());
    }

    public <T> Charset reader$default$2() {
        return this.defaultCharset();
    }

    public Charset read$default$2() {
        return this.defaultCharset();
    }

    public String readStream(InputStream in, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toString(charset.name());
    }

    public Charset readStream$default$2() {
        return this.defaultCharset();
    }

    public byte[] readBytes(File file) {
        return (byte[])((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(InputStream in) {
                return IO$.MODULE$.readBytes(in);
            }
        });
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toByteArray();
    }

    public void append(File file, String content, Charset charset) {
        this.write(file, content, charset, true);
    }

    public void append(File file, byte[] bytes2) {
        this.writeBytes(file, bytes2, true);
    }

    public Charset append$default$3() {
        return this.defaultCharset();
    }

    public void write(File file, byte[] bytes2) {
        this.writeBytes(file, bytes2, false);
    }

    private void writeBytes(File file, byte[] bytes2, boolean append2) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(append2))).apply(file, new Serializable(bytes2){
            public static final long serialVersionUID = 0L;
            private final byte[] bytes$1;

            public final void apply(BufferedOutputStream x$10) {
                x$10.write(this.bytes$1);
            }
            {
                this.bytes$1 = bytes$1;
            }
        });
    }

    public List<String> readLinesURL(URL url, Charset charset) {
        return (List)Using$.MODULE$.urlReader(charset).apply(url, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(BufferedReader in) {
                return IO$.MODULE$.readLines(in);
            }
        });
    }

    public List<String> readLines(File file, Charset charset) {
        return (List)((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(BufferedReader in) {
                return IO$.MODULE$.readLines(in);
            }
        });
    }

    public List<String> readLines(BufferedReader in) {
        return ((List)this.foldLines(in, (Object)Nil$.MODULE$, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(List<String> accum, String line2) {
                String string2 = line2;
                return accum.$colon$colon((Object)string2);
            }
        })).reverse();
    }

    public Charset readLinesURL$default$2() {
        return this.defaultCharset();
    }

    public Charset readLines$default$2() {
        return this.defaultCharset();
    }

    public void foreachLine(BufferedReader in, Function1<String, BoxedUnit> f2) {
        this.foldLines(in, (Object)BoxedUnit.UNIT, (Function2)new Serializable(f2){
            public static final long serialVersionUID = 0L;
            private final Function1 f$4;

            public final void apply(BoxedUnit x$12, String line2) {
                this.f$4.apply((Object)line2);
            }
            {
                this.f$4 = f$4;
            }
        });
    }

    public <T> T foldLines(BufferedReader in, T init2, Function2<T, String, T> f2) {
        return (T)this.readLine$1(init2, in, f2);
    }

    public void writeLines(File file, Seq<String> lines2, Charset charset, boolean append2) {
        this.writer(file, (String)lines2.headOption().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), charset, append2, (Function1)new Serializable(lines2){
            public static final long serialVersionUID = 0L;
            private final Seq lines$1;

            public final void apply(BufferedWriter w) {
                this.lines$1.foreach((Function1)new Serializable(this, w){
                    public static final long serialVersionUID = 0L;
                    private final BufferedWriter w$1;

                    public final void apply(String line2) {
                        this.w$1.write(line2);
                        this.w$1.newLine();
                    }
                    {
                        this.w$1 = w$1;
                    }
                });
            }
            {
                this.lines$1 = lines$1;
            }
        });
    }

    public void writeLines(PrintWriter writer, Seq<String> lines2) {
        lines2.foreach((Function1)new Serializable(writer){
            public static final long serialVersionUID = 0L;
            private final PrintWriter writer$1;

            public final void apply(String x$1) {
                this.writer$1.println(x$1);
            }
            {
                this.writer$1 = writer$1;
            }
        });
    }

    public void write(Properties properties, String label, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, new Serializable(properties, label){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;
            private final String label$1;

            public final void apply(BufferedOutputStream output) {
                this.properties$1.store(output, this.label$1);
            }
            {
                this.properties$1 = properties$1;
                this.label$1 = label$1;
            }
        });
    }

    public Charset write$default$3() {
        return this.defaultCharset();
    }

    public boolean write$default$4() {
        return false;
    }

    public <T> boolean writer$default$4() {
        return false;
    }

    public Charset writeLines$default$3() {
        return this.defaultCharset();
    }

    public boolean writeLines$default$4() {
        return false;
    }

    public void load(Properties properties, File from) {
        if (from.exists()) {
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final Properties properties$2;

                public final void apply(BufferedInputStream input2) {
                    this.properties$2.load(input2);
                }
                {
                    this.properties$2 = properties$2;
                }
            });
        }
    }

    private Pattern PathSeparatorPattern() {
        return this.PathSeparatorPattern;
    }

    public String[] pathSplit(String s) {
        return this.PathSeparatorPattern().split(s);
    }

    public <T> T stash(scala.collection.immutable.Set<File> files2, Function0<T> f2) {
        return this.withTemporaryDirectory((Function1<File, T>)new Serializable(files2, f2){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set files$1;
            private final Function0 f$5;

            public final T apply(File dir) {
                Tuple2<File, File>[] stashed = IO$.MODULE$.sbt$IO$$stashLocations(dir, (File[])this.files$1.toArray(ClassTag$.MODULE$.apply(File.class)));
                IO$.MODULE$.move((Traversable<Tuple2<File, File>>)Predef$.MODULE$.wrapRefArray((Object[])stashed));
                try {
                    return (T)this.f$5.apply();
                }
                catch (Exception exception) {
                    try {
                        IO$.MODULE$.move((Traversable<Tuple2<File, File>>)((Traversable)Predef$.MODULE$.refArrayOps((Object[])stashed).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<File, File> apply(Tuple2<File, File> x$13) {
                                return x$13.swap();
                            }
                        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                        throw exception;
                    }
                    catch (Exception exception2) {
                        throw exception;
                    }
                }
            }
            {
                this.files$1 = files$1;
                this.f$5 = f$5;
            }
        });
    }

    public Tuple2<File, File>[] sbt$IO$$stashLocations(File dir, File[] files2) {
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files2).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<File, Object> check$ifrefutable$2) {
                Tuple2<File, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(dir){
            public static final long serialVersionUID = 0L;
            private final File dir$2;

            public final Tuple2<File, File> apply(Tuple2<File, Object> x$14) {
                Tuple2<File, Object> tuple2 = x$14;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)file, (Object)new File(this.dir$2, RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(index))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.dir$2 = dir$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public void move(Traversable<Tuple2<File, File>> files2) {
        files2.foreach(Function$.MODULE$.tupled((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File a, File b) {
                IO$.MODULE$.move(a, b);
            }
        }));
    }

    public void move(File a, File b) {
        if (b.exists()) {
            this.delete(b);
        }
        this.createDirectory(b.getParentFile());
        if (!a.renameTo(b)) {
            this.copyFile(a, b, true);
            this.delete(a);
        }
    }

    public <T> T gzipFileOut(File file, Function1<OutputStream, T> f2) {
        return (T)((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(file, new Serializable(f2){
            public static final long serialVersionUID = 0L;
            public final Function1 f$6;

            public final T apply(BufferedOutputStream fout) {
                return (T)Using$.MODULE$.gzipOutputStream().apply(fout, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.gzipFileOut.1 $outer;

                    public final T apply(GZIPOutputStream outg) {
                        return (T)Using$.MODULE$.bufferedOutputStream().apply(outg, this.$outer.f$6);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.f$6 = f$6;
            }
        });
    }

    public <T> T gzipFileIn(File file, Function1<InputStream, T> f2) {
        return (T)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new Serializable(f2){
            public static final long serialVersionUID = 0L;
            public final Function1 f$7;

            public final T apply(BufferedInputStream fin) {
                return (T)Using$.MODULE$.gzipInputStream().apply(fin, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.gzipFileIn.1 $outer;

                    public final T apply(GZIPInputStream ing) {
                        return (T)Using$.MODULE$.bufferedInputStream().apply(ing, this.$outer.f$7);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.f$7 = f$7;
            }
        });
    }

    public URI directoryURI(File dir) {
        this.assertAbsolute(dir);
        return this.directoryURI(dir.toURI().normalize());
    }

    /*
     * Unable to fully structure code
     */
    public URI directoryURI(URI uri) {
        block2: {
            if (!uri.isAbsolute()) break block2;
            str = uri.toASCIIString();
            if (str.endsWith("/")) ** GOTO lbl-1000
            v0 = uri.getScheme();
            var4_3 = this.FileScheme();
            if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null) && !Option$.MODULE$.apply((Object)uri.getRawFragment()).isDefined()) {
                v1 = new StringBuilder().append((Object)str).append((Object)"/").toString();
            } else lbl-1000:
            // 2 sources

            {
                v1 = str;
            }
            dirStr = v1;
            return new URI(dirStr).normalize();
        }
        return uri;
    }

    public URI toURI(File f2) {
        return f2.isAbsolute() ? f2.toURI() : new URI(null, this.sbt$IO$$normalizeName(f2.getPath()), null);
    }

    /*
     * WARNING - void declaration
     */
    public File resolve(File base, File f2) {
        void var3_3;
        this.assertAbsolute(base);
        File fabs = f2.isAbsolute() ? f2 : new File(this.directoryURI(new File(base, f2.getPath())));
        this.assertAbsolute(fabs);
        return var3_3;
    }

    public void assertAbsolute(File f2) {
        Predef$.MODULE$.assert(f2.isAbsolute(), (Function0)new Serializable(f2){
            public static final long serialVersionUID = 0L;
            private final File f$8;

            public final String apply() {
                return new StringBuilder().append((Object)"Not absolute: ").append((Object)this.f$8).toString();
            }
            {
                this.f$8 = f$8;
            }
        });
    }

    public void assertAbsolute(URI uri) {
        Predef$.MODULE$.assert(uri.isAbsolute(), (Function0)new Serializable(uri){
            public static final long serialVersionUID = 0L;
            private final URI uri$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Not absolute: ").append((Object)this.uri$2).toString();
            }
            {
                this.uri$2 = uri$2;
            }
        });
    }

    public Seq<File> parseClasspath(String s) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.pathSplit(s)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$15) {
                return new File(x$15);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).toSeq();
    }

    public ObjectInputStream objectInputStream(InputStream wrapped, ClassLoader loader2) {
        return new ObjectInputStream(wrapped, loader2){
            private final ClassLoader loader$1;

            public Class<?> resolveClass(ObjectStreamClass osc) {
                Class<?> c = Class.forName(osc.getName(), false, this.loader$1);
                return c == null ? super.resolveClass(osc) : c;
            }
            {
                this.loader$1 = loader$1;
                super(wrapped$1);
            }
        };
    }

    private final String failBase$1(File dir$1) {
        return new StringBuilder().append((Object)"Could not create directory ").append((Object)dir$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void next$1(ZipInputStream from$1, File toDirectory$4, NameFilter filter$4, boolean preserveLastModified$4, HashSet set$1) {
        while (true) {
            Object object;
            void var7_6;
            ZipEntry entry2;
            if ((entry2 = from$1.getNextEntry()) == null) {
                return;
            }
            String name = var7_6.getName();
            if (filter$4.accept(name)) {
                Object object2;
                File target = new File(toDirectory$4, name);
                if (var7_6.isDirectory()) {
                    this.createDirectory(target);
                    object2 = BoxedUnit.UNIT;
                } else {
                    set$1.$plus$eq((Object)target);
                    object2 = ErrorHandling$.MODULE$.translate((Function0<String>)new Serializable(name, target){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;
                        private final File target$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error extracting zip entry '").append((Object)this.name$1).append((Object)"' to '").append((Object)this.target$1).append((Object)"': ").toString();
                        }
                        {
                            this.name$1 = name$1;
                            this.target$1 = target$1;
                        }
                    }, new Serializable(from$1, target){
                        public static final long serialVersionUID = 0L;
                        public final ZipInputStream from$1;
                        private final File target$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(this.target$1, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.next.1.1 $outer;

                                public final void apply(BufferedOutputStream out) {
                                    IO$.MODULE$.transfer((InputStream)this.$outer.from$1, (OutputStream)out);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.from$1 = from$1;
                            this.target$1 = target$1;
                        }
                    });
                }
                object = preserveLastModified$4 ? BoxesRunTime.boxToBoolean((boolean)target.setLastModified(var7_6.getTime())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            from$1.closeEntry();
        }
    }

    private final void read$1(InputStream in$2, OutputStream out$5, byte[] buffer$1) {
        int byteCount;
        while ((byteCount = in$2.read(buffer$1)) >= 0) {
            out$5.write(buffer$1, 0, byteCount);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final File create$1(int tries, File baseDirectory$1) {
        while (true) {
            if (tries > this.MaximumTries()) {
                throw scala.sys.package$.MODULE$.error("Could not create temporary directory.");
            }
            String randomName = new StringBuilder().append((Object)"sbt_").append((Object)Integer.toHexString(this.random().nextInt())).toString();
            File f2 = new File(baseDirectory$1, randomName);
            try {
                this.createDirectory(f2);
                return f2;
            }
            catch (Exception exception) {
                ++tries;
                continue;
            }
            break;
        }
    }

    public final boolean sbt$IO$$visit$1(File f2, Set dirs$1, HashMap isEmpty$1) {
        return BoxesRunTime.unboxToBoolean((Object)isEmpty$1.getOrElseUpdate((Object)f2, (Function0)new Serializable(dirs$1, isEmpty$1, f2){
            public static final long serialVersionUID = 0L;
            public final Set dirs$1;
            public final HashMap isEmpty$1;
            private final File f$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.dirs$1.apply((Object)this.f$1) && this.f$1.isDirectory() && Predef$.MODULE$.refArrayOps((Object[])this.f$1.listFiles()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$sbt$IO$$visit$1$1 $outer;

                    public final boolean apply(File f2) {
                        return IO$.MODULE$.sbt$IO$$visit$1(f2, this.$outer.dirs$1, this.$outer.isEmpty$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.dirs$1 = dirs$1;
                this.isEmpty$1 = isEmpty$1;
                this.f$1 = f$1;
            }
        }));
    }

    public final boolean sbt$IO$$isEmptyDirectory$1(File dir) {
        return dir.isDirectory() && Predef$.MODULE$.refArrayOps((Object[])this.listFiles(dir)).isEmpty();
    }

    private final scala.collection.immutable.Set parents$1(scala.collection.immutable.Set fs) {
        return (scala.collection.immutable.Set)fs.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<File> apply(File f2) {
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)f2.getParentFile()));
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private final void deleteEmpty$1(scala.collection.immutable.Set dirs2) {
        scala.collection.immutable.Set empty;
        while ((empty = (scala.collection.immutable.Set)dirs2.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File dir) {
                return IO$.MODULE$.sbt$IO$$isEmptyDirectory$1(dir);
            }
        })).nonEmpty()) {
            empty.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$2) {
                    return x$2.delete();
                }
            });
            dirs2 = this.parents$1(empty);
        }
    }

    public final void sbt$IO$$addDirectoryEntry$1(String name, ZipOutputStream output$2, Function1 createEntry$1, long now$1, long emptyCRC$1) {
        output$2.putNextEntry(this.makeDirectoryEntry$1(name, createEntry$1, now$1, emptyCRC$1));
        output$2.closeEntry();
    }

    private final ZipEntry makeDirectoryEntry$1(String name, Function1 createEntry$1, long now$1, long emptyCRC$1) {
        ZipEntry e = (ZipEntry)createEntry$1.apply((Object)name);
        e.setTime(now$1);
        e.setSize(0L);
        e.setMethod(0);
        e.setCrc(emptyCRC$1);
        return e;
    }

    private final ZipEntry makeFileEntry$1(File file, String name, Function1 createEntry$1) {
        ZipEntry e = (ZipEntry)createEntry$1.apply((Object)name);
        e.setTime(file.lastModified());
        return e;
    }

    public final void sbt$IO$$addFileEntry$1(File file, String name, ZipOutputStream output$2, Function1 createEntry$1) {
        output$2.putNextEntry(this.makeFileEntry$1(file, name, createEntry$1));
        this.transfer(file, (OutputStream)output$2);
        output$2.closeEntry();
    }

    private final Object readLine$1(Object accum, BufferedReader in$4, Function2 f$3) {
        String line2;
        while ((line2 = in$4.readLine()) != null) {
            accum = f$3.apply(accum, (Object)line2);
        }
        return accum;
    }

    private IO$() {
        MODULE$ = this;
        this.MaximumTries = 10;
        this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.BufferSize = 8192;
        this.FileScheme = "file";
        this.Newline = System.getProperty("line.separator");
        this.utf8 = Charset.forName("UTF-8");
        this.PathSeparatorPattern = Pattern.compile(File.pathSeparator);
    }
}

