/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.BT4;
import org.tukaani.xz.lz.HC4;
import org.tukaani.xz.lz.Matches;

public abstract class LZEncoder {
    public static final int MF_HC4 = 4;
    public static final int MF_BT4 = 20;
    private final int keepSizeBefore;
    private final int keepSizeAfter;
    final int matchLenMax;
    final int niceLen;
    final byte[] buf;
    final int bufSize;
    int readPos = -1;
    private int readLimit = -1;
    private boolean finishing = false;
    private int writePos = 0;
    private int pendingSize = 0;

    static void normalize(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] <= n2) {
                nArray[i] = 0;
                continue;
            }
            int n3 = i;
            nArray[n3] = nArray[n3] - n2;
        }
    }

    private static int getBufSize(int n, int n2, int n3, int n4) {
        int n5 = n2 + n;
        int n6 = n3 + n4;
        int n7 = Math.min(n / 2 + 262144, 0x20000000);
        return n5 + n6 + n7;
    }

    public static int getMemoryUsage(int n, int n2, int n3, int n4, int n5) {
        int n6 = LZEncoder.getBufSize(n, n2, n3, n4) / 1024 + 10;
        switch (n5) {
            case 4: {
                n6 += HC4.getMemoryUsage(n);
                break;
            }
            case 20: {
                n6 += BT4.getMemoryUsage(n);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n6;
    }

    public static LZEncoder getInstance(int n, int n2, int n3, int n4, int n5, int n6, int n7, ArrayCache arrayCache) {
        switch (n6) {
            case 4: {
                return new HC4(n, n2, n3, n4, n5, n7, arrayCache);
            }
            case 20: {
                return new BT4(n, n2, n3, n4, n5, n7, arrayCache);
            }
        }
        throw new IllegalArgumentException();
    }

    LZEncoder(int n, int n2, int n3, int n4, int n5, ArrayCache arrayCache) {
        this.bufSize = LZEncoder.getBufSize(n, n2, n3, n5);
        this.buf = arrayCache.getByteArray(this.bufSize, false);
        this.keepSizeBefore = n2 + n;
        this.keepSizeAfter = n3 + n5;
        this.matchLenMax = n5;
        this.niceLen = n4;
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void setPresetDict(int n, byte[] byArray) {
        assert (!this.isStarted());
        assert (this.writePos == 0);
        if (byArray != null) {
            int n2 = Math.min(byArray.length, n);
            int n3 = byArray.length - n2;
            System.arraycopy(byArray, n3, this.buf, 0, n2);
            this.writePos += n2;
            this.skip(n2);
        }
    }

    private void moveWindow() {
        int n = this.readPos + 1 - this.keepSizeBefore & 0xFFFFFFF0;
        int n2 = this.writePos - n;
        System.arraycopy(this.buf, n, this.buf, 0, n2);
        this.readPos -= n;
        this.readLimit -= n;
        this.writePos -= n;
    }

    public int fillWindow(byte[] byArray, int n, int n2) {
        assert (!this.finishing);
        if (this.readPos >= this.bufSize - this.keepSizeAfter) {
            this.moveWindow();
        }
        if (n2 > this.bufSize - this.writePos) {
            n2 = this.bufSize - this.writePos;
        }
        System.arraycopy(byArray, n, this.buf, this.writePos, n2);
        this.writePos += n2;
        if (this.writePos >= this.keepSizeAfter) {
            this.readLimit = this.writePos - this.keepSizeAfter;
        }
        this.processPendingBytes();
        return n2;
    }

    private void processPendingBytes() {
        if (this.pendingSize > 0 && this.readPos < this.readLimit) {
            this.readPos -= this.pendingSize;
            int n = this.pendingSize;
            this.pendingSize = 0;
            this.skip(n);
            assert (this.pendingSize < n);
        }
    }

    public boolean isStarted() {
        return this.readPos != -1;
    }

    public void setFlushing() {
        this.readLimit = this.writePos - 1;
        this.processPendingBytes();
    }

    public void setFinishing() {
        this.readLimit = this.writePos - 1;
        this.finishing = true;
        this.processPendingBytes();
    }

    public boolean hasEnoughData(int n) {
        return this.readPos - n < this.readLimit;
    }

    public void copyUncompressed(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(this.buf, this.readPos + 1 - n, n2);
    }

    public int getAvail() {
        assert (this.isStarted());
        return this.writePos - this.readPos;
    }

    public int getPos() {
        return this.readPos;
    }

    public int getByte(int n) {
        return this.buf[this.readPos - n] & 0xFF;
    }

    public int getByte(int n, int n2) {
        return this.buf[this.readPos + n - n2] & 0xFF;
    }

    public int getMatchLen(int n, int n2) {
        int n3;
        int n4 = this.readPos - n - 1;
        for (n3 = 0; n3 < n2 && this.buf[this.readPos + n3] == this.buf[n4 + n3]; ++n3) {
        }
        return n3;
    }

    public int getMatchLen(int n, int n2, int n3) {
        int n4;
        int n5 = this.readPos + n;
        int n6 = n5 - n2 - 1;
        for (n4 = 0; n4 < n3 && this.buf[n5 + n4] == this.buf[n6 + n4]; ++n4) {
        }
        return n4;
    }

    public boolean verifyMatches(Matches matches2) {
        int n = Math.min(this.getAvail(), this.matchLenMax);
        for (int i = 0; i < matches2.count; ++i) {
            if (this.getMatchLen(matches2.dist[i], n) == matches2.len[i]) continue;
            return false;
        }
        return true;
    }

    int movePos(int n, int n2) {
        assert (n >= n2);
        ++this.readPos;
        int n3 = this.writePos - this.readPos;
        if (!(n3 >= n || n3 >= n2 && this.finishing)) {
            ++this.pendingSize;
            n3 = 0;
        }
        return n3;
    }

    public abstract Matches getMatches();

    public abstract void skip(int var1);
}

