/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.util.ArrayList;
import java.util.List;
import org.tukaani.xz.ArrayCache;

public class ResettableArrayCache
extends ArrayCache {
    private final ArrayCache arrayCache;
    private final List<byte[]> byteArrays;
    private final List<int[]> intArrays;

    public ResettableArrayCache(ArrayCache arrayCache) {
        this.arrayCache = arrayCache;
        if (arrayCache == ArrayCache.getDummyCache()) {
            this.byteArrays = null;
            this.intArrays = null;
        } else {
            this.byteArrays = new ArrayList<byte[]>();
            this.intArrays = new ArrayList<int[]>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(int n, boolean bl) {
        byte[] byArray = this.arrayCache.getByteArray(n, bl);
        if (this.byteArrays != null) {
            List<byte[]> list2 = this.byteArrays;
            synchronized (list2) {
                this.byteArrays.add(byArray);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putArray(byte[] byArray) {
        if (this.byteArrays != null) {
            List<byte[]> list2 = this.byteArrays;
            synchronized (list2) {
                int n = this.byteArrays.lastIndexOf(byArray);
                if (n != -1) {
                    this.byteArrays.remove(n);
                }
            }
            this.arrayCache.putArray(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getIntArray(int n, boolean bl) {
        int[] nArray = this.arrayCache.getIntArray(n, bl);
        if (this.intArrays != null) {
            List<int[]> list2 = this.intArrays;
            synchronized (list2) {
                this.intArrays.add(nArray);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putArray(int[] nArray) {
        if (this.intArrays != null) {
            List<int[]> list2 = this.intArrays;
            synchronized (list2) {
                int n = this.intArrays.lastIndexOf(nArray);
                if (n != -1) {
                    this.intArrays.remove(n);
                }
            }
            this.arrayCache.putArray(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.byteArrays != null) {
            int n;
            List<byte[]> list2 = this.byteArrays;
            synchronized (list2) {
                for (n = this.byteArrays.size() - 1; n >= 0; --n) {
                    this.arrayCache.putArray(this.byteArrays.get(n));
                }
                this.byteArrays.clear();
            }
            list2 = this.intArrays;
            synchronized (list2) {
                for (n = this.intArrays.size() - 1; n >= 0; --n) {
                    this.arrayCache.putArray(this.intArrays.get(n));
                }
                this.intArrays.clear();
            }
        }
    }
}

