/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.util.internal.logging;

import org.spark_project.io.netty.util.internal.logging.InternalLogger;
import org.spark_project.io.netty.util.internal.logging.JdkLoggerFactory;
import org.spark_project.io.netty.util.internal.logging.Log4JLoggerFactory;
import org.spark_project.io.netty.util.internal.logging.Slf4JLoggerFactory;

public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory;

    private static InternalLoggerFactory newDefaultFactory(String name) {
        InternalLoggerFactory f2;
        try {
            f2 = new Slf4JLoggerFactory(true);
            f2.newInstance(name).debug("Using SLF4J as the default logging framework");
        }
        catch (Throwable t1) {
            try {
                f2 = Log4JLoggerFactory.INSTANCE;
                f2.newInstance(name).debug("Using Log4J as the default logging framework");
            }
            catch (Throwable t2) {
                f2 = JdkLoggerFactory.INSTANCE;
                f2.newInstance(name).debug("Using java.util.logging as the default logging framework");
            }
        }
        return f2;
    }

    public static InternalLoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = InternalLoggerFactory.newDefaultFactory(InternalLoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        InternalLoggerFactory.defaultFactory = defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz2) {
        return InternalLoggerFactory.getInstance(clazz2.getName());
    }

    public static InternalLogger getInstance(String name) {
        return InternalLoggerFactory.getDefaultFactory().newInstance(name);
    }

    protected abstract InternalLogger newInstance(String var1);
}

