/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.util.internal;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T arg, String text2) {
        if (arg == null) {
            throw new NullPointerException(text2);
        }
        return arg;
    }

    public static int checkPositive(int i, String name) {
        if (i <= 0) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: > 0)");
        }
        return i;
    }

    public static long checkPositive(long i, String name) {
        if (i <= 0L) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: > 0)");
        }
        return i;
    }

    public static int checkPositiveOrZero(int i, String name) {
        if (i < 0) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: >= 0)");
        }
        return i;
    }

    public static long checkPositiveOrZero(long i, String name) {
        if (i < 0L) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: >= 0)");
        }
        return i;
    }

    public static <T> T[] checkNonEmpty(T[] array2, String name) {
        ObjectUtil.checkNotNull(array2, name);
        ObjectUtil.checkPositive(array2.length, name + ".length");
        return array2;
    }

    public static int intValue(Integer wrapper, int defaultValue2) {
        return wrapper != null ? wrapper : defaultValue2;
    }

    public static long longValue(Long wrapper, long defaultValue2) {
        return wrapper != null ? wrapper : defaultValue2;
    }
}

