/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.util;

import java.net.IDN;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.spark_project.io.netty.util.Mapping;
import org.spark_project.io.netty.util.internal.ObjectUtil;
import org.spark_project.io.netty.util.internal.StringUtil;

public class DomainNameMapping<V>
implements Mapping<String, V> {
    final V defaultValue;
    private final Map<String, V> map;
    private final Map<String, V> unmodifiableMap;

    @Deprecated
    public DomainNameMapping(V defaultValue2) {
        this(4, defaultValue2);
    }

    @Deprecated
    public DomainNameMapping(int initialCapacity, V defaultValue2) {
        this(new LinkedHashMap(initialCapacity), defaultValue2);
    }

    DomainNameMapping(Map<String, V> map2, V defaultValue2) {
        this.defaultValue = ObjectUtil.checkNotNull(defaultValue2, "defaultValue");
        this.map = map2;
        this.unmodifiableMap = map2 != null ? Collections.unmodifiableMap(map2) : null;
    }

    @Deprecated
    public DomainNameMapping<V> add(String hostname, V output) {
        this.map.put(DomainNameMapping.normalizeHostname(ObjectUtil.checkNotNull(hostname, "hostname")), ObjectUtil.checkNotNull(output, "output"));
        return this;
    }

    static boolean matches(String template, String hostName) {
        if (template.startsWith("*.")) {
            return template.regionMatches(2, hostName, 0, hostName.length()) || StringUtil.commonSuffixOfLength(hostName, template, template.length() - 1);
        }
        return template.equals(hostName);
    }

    static String normalizeHostname(String hostname) {
        if (DomainNameMapping.needsNormalization(hostname)) {
            hostname = IDN.toASCII(hostname, 1);
        }
        return hostname.toLowerCase(Locale.US);
    }

    private static boolean needsNormalization(String hostname) {
        int length = hostname.length();
        for (int i = 0; i < length; ++i) {
            char c = hostname.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    @Override
    public V map(String hostname) {
        if (hostname != null) {
            hostname = DomainNameMapping.normalizeHostname(hostname);
            for (Map.Entry<String, V> entry2 : this.map.entrySet()) {
                if (!DomainNameMapping.matches(entry2.getKey(), hostname)) continue;
                return entry2.getValue();
            }
        }
        return this.defaultValue;
    }

    public Map<String, V> asMap() {
        return this.unmodifiableMap;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(default: " + this.defaultValue + ", map: " + this.map + ')';
    }
}

