/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.smtp;

import java.util.Collections;
import java.util.List;
import org.spark_project.io.netty.handler.codec.smtp.SmtpResponse;
import org.spark_project.io.netty.handler.codec.smtp.SmtpUtils;

public final class DefaultSmtpResponse
implements SmtpResponse {
    private final int code;
    private final List<CharSequence> details;

    public DefaultSmtpResponse(int code2) {
        this(code2, (List<CharSequence>)null);
    }

    public DefaultSmtpResponse(int code2, CharSequence ... details) {
        this(code2, SmtpUtils.toUnmodifiableList(details));
    }

    DefaultSmtpResponse(int code2, List<CharSequence> details) {
        if (code2 < 100 || code2 > 599) {
            throw new IllegalArgumentException("code must be 100 <= code <= 599");
        }
        this.code = code2;
        this.details = details == null ? Collections.emptyList() : Collections.unmodifiableList(details);
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public List<CharSequence> details() {
        return this.details;
    }

    public int hashCode() {
        return this.code * 31 + this.details.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultSmtpResponse)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        DefaultSmtpResponse other = (DefaultSmtpResponse)o;
        return this.code() == other.code() && this.details().equals(other.details());
    }

    public String toString() {
        return "DefaultSmtpResponse{code=" + this.code + ", details=" + this.details + '}';
    }
}

