/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.redis;

import org.spark_project.io.netty.handler.codec.redis.RedisCodecException;

public enum RedisMessageType {
    SIMPLE_STRING(43, true),
    ERROR(45, true),
    INTEGER(58, true),
    BULK_STRING(36, false),
    ARRAY_HEADER(42, false),
    ARRAY(42, false);

    private final byte value;
    private final boolean inline;

    private RedisMessageType(byte value2, boolean inline2) {
        this.value = value2;
        this.inline = inline2;
    }

    public byte value() {
        return this.value;
    }

    public boolean isInline() {
        return this.inline;
    }

    public static RedisMessageType valueOf(byte value2) {
        switch (value2) {
            case 43: {
                return SIMPLE_STRING;
            }
            case 45: {
                return ERROR;
            }
            case 58: {
                return INTEGER;
            }
            case 36: {
                return BULK_STRING;
            }
            case 42: {
                return ARRAY_HEADER;
            }
        }
        throw new RedisCodecException("Unknown RedisMessageType: " + value2);
    }
}

