/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.redis;

import java.util.List;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.ByteBufAllocator;
import org.spark_project.io.netty.buffer.ByteBufUtil;
import org.spark_project.io.netty.channel.ChannelHandlerContext;
import org.spark_project.io.netty.handler.codec.CodecException;
import org.spark_project.io.netty.handler.codec.MessageToMessageEncoder;
import org.spark_project.io.netty.handler.codec.redis.ArrayHeaderRedisMessage;
import org.spark_project.io.netty.handler.codec.redis.ArrayRedisMessage;
import org.spark_project.io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import org.spark_project.io.netty.handler.codec.redis.BulkStringRedisContent;
import org.spark_project.io.netty.handler.codec.redis.ErrorRedisMessage;
import org.spark_project.io.netty.handler.codec.redis.FixedRedisMessagePool;
import org.spark_project.io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import org.spark_project.io.netty.handler.codec.redis.IntegerRedisMessage;
import org.spark_project.io.netty.handler.codec.redis.LastBulkStringRedisContent;
import org.spark_project.io.netty.handler.codec.redis.RedisCodecUtil;
import org.spark_project.io.netty.handler.codec.redis.RedisConstants;
import org.spark_project.io.netty.handler.codec.redis.RedisMessage;
import org.spark_project.io.netty.handler.codec.redis.RedisMessagePool;
import org.spark_project.io.netty.handler.codec.redis.RedisMessageType;
import org.spark_project.io.netty.handler.codec.redis.SimpleStringRedisMessage;
import org.spark_project.io.netty.util.internal.ObjectUtil;

public class RedisEncoder
extends MessageToMessageEncoder<RedisMessage> {
    private final RedisMessagePool messagePool;

    public RedisEncoder() {
        this(FixedRedisMessagePool.INSTANCE);
    }

    public RedisEncoder(RedisMessagePool messagePool) {
        this.messagePool = ObjectUtil.checkNotNull(messagePool, "messagePool");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, RedisMessage msg, List<Object> out) throws Exception {
        try {
            this.writeRedisMessage(ctx.alloc(), msg, out);
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodecException(e);
        }
    }

    private void writeRedisMessage(ByteBufAllocator allocator, RedisMessage msg, List<Object> out) {
        if (msg instanceof SimpleStringRedisMessage) {
            RedisEncoder.writeSimpleStringMessage(allocator, (SimpleStringRedisMessage)msg, out);
        } else if (msg instanceof ErrorRedisMessage) {
            RedisEncoder.writeErrorMessage(allocator, (ErrorRedisMessage)msg, out);
        } else if (msg instanceof IntegerRedisMessage) {
            this.writeIntegerMessage(allocator, (IntegerRedisMessage)msg, out);
        } else if (msg instanceof FullBulkStringRedisMessage) {
            this.writeFullBulkStringMessage(allocator, (FullBulkStringRedisMessage)msg, out);
        } else if (msg instanceof BulkStringRedisContent) {
            RedisEncoder.writeBulkStringContent(allocator, (BulkStringRedisContent)msg, out);
        } else if (msg instanceof BulkStringHeaderRedisMessage) {
            this.writeBulkStringHeader(allocator, (BulkStringHeaderRedisMessage)msg, out);
        } else if (msg instanceof ArrayHeaderRedisMessage) {
            this.writeArrayHeader(allocator, (ArrayHeaderRedisMessage)msg, out);
        } else if (msg instanceof ArrayRedisMessage) {
            this.writeArrayMessage(allocator, (ArrayRedisMessage)msg, out);
        } else {
            throw new CodecException("unknown message type: " + msg);
        }
    }

    private static void writeSimpleStringMessage(ByteBufAllocator allocator, SimpleStringRedisMessage msg, List<Object> out) {
        RedisEncoder.writeString(allocator, RedisMessageType.SIMPLE_STRING.value(), msg.content(), out);
    }

    private static void writeErrorMessage(ByteBufAllocator allocator, ErrorRedisMessage msg, List<Object> out) {
        RedisEncoder.writeString(allocator, RedisMessageType.ERROR.value(), msg.content(), out);
    }

    private static void writeString(ByteBufAllocator allocator, byte type, String content, List<Object> out) {
        ByteBuf buf = allocator.ioBuffer(1 + ByteBufUtil.utf8MaxBytes(content) + 2);
        buf.writeByte(type);
        ByteBufUtil.writeUtf8(buf, (CharSequence)content);
        buf.writeShort(RedisConstants.EOL_SHORT);
        out.add(buf);
    }

    private void writeIntegerMessage(ByteBufAllocator allocator, IntegerRedisMessage msg, List<Object> out) {
        ByteBuf buf = allocator.ioBuffer(23);
        buf.writeByte(RedisMessageType.INTEGER.value());
        buf.writeBytes(this.numberToBytes(msg.value()));
        buf.writeShort(RedisConstants.EOL_SHORT);
        out.add(buf);
    }

    private void writeBulkStringHeader(ByteBufAllocator allocator, BulkStringHeaderRedisMessage msg, List<Object> out) {
        ByteBuf buf = allocator.ioBuffer(1 + (msg.isNull() ? 2 : 22));
        buf.writeByte(RedisMessageType.BULK_STRING.value());
        if (msg.isNull()) {
            buf.writeShort(RedisConstants.NULL_SHORT);
        } else {
            buf.writeBytes(this.numberToBytes(msg.bulkStringLength()));
            buf.writeShort(RedisConstants.EOL_SHORT);
        }
        out.add(buf);
    }

    private static void writeBulkStringContent(ByteBufAllocator allocator, BulkStringRedisContent msg, List<Object> out) {
        out.add(msg.content().retain());
        if (msg instanceof LastBulkStringRedisContent) {
            out.add(allocator.ioBuffer(2).writeShort(RedisConstants.EOL_SHORT));
        }
    }

    private void writeFullBulkStringMessage(ByteBufAllocator allocator, FullBulkStringRedisMessage msg, List<Object> out) {
        if (msg.isNull()) {
            ByteBuf buf = allocator.ioBuffer(5);
            buf.writeByte(RedisMessageType.BULK_STRING.value());
            buf.writeShort(RedisConstants.NULL_SHORT);
            buf.writeShort(RedisConstants.EOL_SHORT);
            out.add(buf);
        } else {
            ByteBuf headerBuf = allocator.ioBuffer(23);
            headerBuf.writeByte(RedisMessageType.BULK_STRING.value());
            headerBuf.writeBytes(this.numberToBytes(msg.content().readableBytes()));
            headerBuf.writeShort(RedisConstants.EOL_SHORT);
            out.add(headerBuf);
            out.add(msg.content().retain());
            out.add(allocator.ioBuffer(2).writeShort(RedisConstants.EOL_SHORT));
        }
    }

    private void writeArrayHeader(ByteBufAllocator allocator, ArrayHeaderRedisMessage msg, List<Object> out) {
        this.writeArrayHeader(allocator, msg.isNull(), msg.length(), out);
    }

    private void writeArrayMessage(ByteBufAllocator allocator, ArrayRedisMessage msg, List<Object> out) {
        if (msg.isNull()) {
            this.writeArrayHeader(allocator, msg.isNull(), -1L, out);
        } else {
            this.writeArrayHeader(allocator, msg.isNull(), msg.children().size(), out);
            for (RedisMessage child : msg.children()) {
                this.writeRedisMessage(allocator, child, out);
            }
        }
    }

    private void writeArrayHeader(ByteBufAllocator allocator, boolean isNull2, long length, List<Object> out) {
        if (isNull2) {
            ByteBuf buf = allocator.ioBuffer(5);
            buf.writeByte(RedisMessageType.ARRAY_HEADER.value());
            buf.writeShort(RedisConstants.NULL_SHORT);
            buf.writeShort(RedisConstants.EOL_SHORT);
            out.add(buf);
        } else {
            ByteBuf buf = allocator.ioBuffer(23);
            buf.writeByte(RedisMessageType.ARRAY_HEADER.value());
            buf.writeBytes(this.numberToBytes(length));
            buf.writeShort(RedisConstants.EOL_SHORT);
            out.add(buf);
        }
    }

    private byte[] numberToBytes(long value2) {
        byte[] bytes2 = this.messagePool.getByteBufOfInteger(value2);
        return bytes2 != null ? bytes2 : RedisCodecUtil.longToAsciiBytes(value2);
    }
}

