/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.protobuf;

import com.google.protobuf.nano.MessageNano;
import java.util.List;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.channel.ChannelHandler;
import org.spark_project.io.netty.channel.ChannelHandlerContext;
import org.spark_project.io.netty.handler.codec.MessageToMessageDecoder;
import org.spark_project.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz2) {
        this.clazz = ObjectUtil.checkNotNull(clazz2, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array2;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array2 = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array2 = new byte[length];
            msg.getBytes(msg.readerIndex(), array2, 0, length);
            offset = 0;
        }
        MessageNano prototype = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        out.add(MessageNano.mergeFrom((MessageNano)prototype, (byte[])array2, (int)offset, (int)length));
    }
}

