/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.protobuf;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.util.List;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.channel.ChannelHandler;
import org.spark_project.io.netty.channel.ChannelHandlerContext;
import org.spark_project.io.netty.handler.codec.MessageToMessageDecoder;

@ChannelHandler.Sharable
public class ProtobufDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final boolean HAS_PARSER;
    private final MessageLite prototype;
    private final ExtensionRegistryLite extensionRegistry;

    public ProtobufDecoder(MessageLite prototype) {
        this(prototype, (ExtensionRegistry)null);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistry extensionRegistry) {
        this(prototype, (ExtensionRegistryLite)extensionRegistry);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistryLite extensionRegistry) {
        if (prototype == null) {
            throw new NullPointerException("prototype");
        }
        this.prototype = prototype.getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array2;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array2 = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array2 = new byte[length];
            msg.getBytes(msg.readerIndex(), array2, 0, length);
            offset = 0;
        }
        if (this.extensionRegistry == null) {
            if (HAS_PARSER) {
                out.add(this.prototype.getParserForType().parseFrom(array2, offset, length));
            } else {
                out.add(this.prototype.newBuilderForType().mergeFrom(array2, offset, length).build());
            }
        } else if (HAS_PARSER) {
            out.add(this.prototype.getParserForType().parseFrom(array2, offset, length, this.extensionRegistry));
        } else {
            out.add(this.prototype.newBuilderForType().mergeFrom(array2, offset, length, this.extensionRegistry).build());
        }
    }

    static {
        boolean hasParser = false;
        try {
            MessageLite.class.getDeclaredMethod("getParserForType", new Class[0]);
            hasParser = true;
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        HAS_PARSER = hasParser;
    }
}

