/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.mqtt;

import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.handler.codec.DecoderResult;
import org.spark_project.io.netty.handler.codec.mqtt.MqttConnAckMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import org.spark_project.io.netty.handler.codec.mqtt.MqttConnectMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttConnectPayload;
import org.spark_project.io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import org.spark_project.io.netty.handler.codec.mqtt.MqttFixedHeader;
import org.spark_project.io.netty.handler.codec.mqtt.MqttMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import org.spark_project.io.netty.handler.codec.mqtt.MqttPubAckMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttPublishMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import org.spark_project.io.netty.handler.codec.mqtt.MqttSubAckMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttSubAckPayload;
import org.spark_project.io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttSubscribePayload;
import org.spark_project.io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import org.spark_project.io.netty.handler.codec.mqtt.MqttUnsubscribePayload;

public final class MqttMessageFactory {
    public static MqttMessage newMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Object payload) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader, (MqttConnectVariableHeader)variableHeader, (MqttConnectPayload)payload);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader, (MqttConnAckVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubscribePayload)payload);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubAckPayload)payload);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubscribePayload)payload);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader, (MqttPublishVariableHeader)variableHeader, (ByteBuf)payload);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                return new MqttMessage(mqttFixedHeader);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    public static MqttMessage newInvalidMessage(Throwable cause) {
        return new MqttMessage(null, null, null, DecoderResult.failure(cause));
    }

    private MqttMessageFactory() {
    }
}

