/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.memcache.binary;

import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.Unpooled;
import org.spark_project.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import org.spark_project.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;

public class DefaultFullBinaryMemcacheRequest
extends DefaultBinaryMemcacheRequest
implements FullBinaryMemcacheRequest {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheRequest(ByteBuf key, ByteBuf extras2) {
        this(key, extras2, Unpooled.buffer(0));
    }

    public DefaultFullBinaryMemcacheRequest(ByteBuf key, ByteBuf extras2, ByteBuf content) {
        super(key, extras2);
        if (content == null) {
            throw new NullPointerException("Supplied content is null.");
        }
        this.content = content;
        this.setTotalBodyLength(this.keyLength() + this.extrasLength() + content.readableBytes());
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public FullBinaryMemcacheRequest retain() {
        super.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest touch() {
        super.touch();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest touch(Object hint) {
        super.touch(hint);
        this.content.touch(hint);
        return this;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.content.release();
    }

    @Override
    public FullBinaryMemcacheRequest copy() {
        ByteBuf extras2;
        ByteBuf key = this.key();
        if (key != null) {
            key = key.copy();
        }
        if ((extras2 = this.extras()) != null) {
            extras2 = extras2.copy();
        }
        return new DefaultFullBinaryMemcacheRequest(key, extras2, this.content().copy());
    }

    @Override
    public FullBinaryMemcacheRequest duplicate() {
        ByteBuf extras2;
        ByteBuf key = this.key();
        if (key != null) {
            key = key.duplicate();
        }
        if ((extras2 = this.extras()) != null) {
            extras2 = extras2.duplicate();
        }
        return new DefaultFullBinaryMemcacheRequest(key, extras2, this.content().duplicate());
    }

    @Override
    public FullBinaryMemcacheRequest retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullBinaryMemcacheRequest replace(ByteBuf content) {
        ByteBuf extras2;
        ByteBuf key = this.key();
        if (key != null) {
            key = key.retainedDuplicate();
        }
        if ((extras2 = this.extras()) != null) {
            extras2 = extras2.retainedDuplicate();
        }
        return new DefaultFullBinaryMemcacheRequest(key, extras2, content);
    }
}

